# coding: utf-8

"""
    Deep Lynx

    The construction of megaprojects has consistently demonstrated challenges for project managers in regard to meeting cost, schedule, and performance requirements. Megaproject construction challenges are common place within megaprojects with many active projects in the United States failing to meet cost and schedule efforts by significant margins. Currently, engineering teams operate in siloed tools and disparate teams where connections across design, procurement, and construction systems are translated manually or over brittle point-to-point integrations. The manual nature of data exchange increases the risk of silent errors in the reactor design, with each silent error cascading across the design. These cascading errors lead to uncontrollable risk during construction, resulting in significant delays and cost overruns. Deep Lynx allows for an integrated platform during design and operations of mega projects.  The Deep Lynx Core API delivers a few main features.  1. Provides a set of methods and endpoints for manipulating data in an object oriented database. This allows us to store complex datatypes as records and then to compile them into actual, modifiable objects at run-time. Users can store taxonomies or ontologies in a readable format.  2. Provides methods for storing and retrieving data in a graph database. This data is structured and validated against the aformentioned object oriented database before storage.  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class RequiredMethod(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'method_id': 'str',
        'priority': 'str',
        'versions': 'list[Version]'
    }

    attribute_map = {
        'method_id': 'methodId',
        'priority': 'priority',
        'versions': 'versions'
    }

    def __init__(self, method_id=None, priority=None, versions=None):  # noqa: E501
        """RequiredMethod - a model defined in Swagger"""  # noqa: E501
        self._method_id = None
        self._priority = None
        self._versions = None
        self.discriminator = None
        if method_id is not None:
            self.method_id = method_id
        if priority is not None:
            self.priority = priority
        if versions is not None:
            self.versions = versions

    @property
    def method_id(self):
        """Gets the method_id of this RequiredMethod.  # noqa: E501


        :return: The method_id of this RequiredMethod.  # noqa: E501
        :rtype: str
        """
        return self._method_id

    @method_id.setter
    def method_id(self, method_id):
        """Sets the method_id of this RequiredMethod.


        :param method_id: The method_id of this RequiredMethod.  # noqa: E501
        :type: str
        """

        self._method_id = method_id

    @property
    def priority(self):
        """Gets the priority of this RequiredMethod.  # noqa: E501


        :return: The priority of this RequiredMethod.  # noqa: E501
        :rtype: str
        """
        return self._priority

    @priority.setter
    def priority(self, priority):
        """Sets the priority of this RequiredMethod.


        :param priority: The priority of this RequiredMethod.  # noqa: E501
        :type: str
        """

        self._priority = priority

    @property
    def versions(self):
        """Gets the versions of this RequiredMethod.  # noqa: E501


        :return: The versions of this RequiredMethod.  # noqa: E501
        :rtype: list[Version]
        """
        return self._versions

    @versions.setter
    def versions(self, versions):
        """Sets the versions of this RequiredMethod.


        :param versions: The versions of this RequiredMethod.  # noqa: E501
        :type: list[Version]
        """

        self._versions = versions

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RequiredMethod, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RequiredMethod):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
