# coding: utf-8

"""
    Deep Lynx

    The construction of megaprojects has consistently demonstrated challenges for project managers in regard to meeting cost, schedule, and performance requirements. Megaproject construction challenges are common place within megaprojects with many active projects in the United States failing to meet cost and schedule efforts by significant margins. Currently, engineering teams operate in siloed tools and disparate teams where connections across design, procurement, and construction systems are translated manually or over brittle point-to-point integrations. The manual nature of data exchange increases the risk of silent errors in the reactor design, with each silent error cascading across the design. These cascading errors lead to uncontrollable risk during construction, resulting in significant delays and cost overruns. Deep Lynx allows for an integrated platform during design and operations of mega projects.  The Deep Lynx Core API delivers a few main features.  1. Provides a set of methods and endpoints for manipulating data in an object oriented database. This allows us to store complex datatypes as records and then to compile them into actual, modifiable objects at run-time. Users can store taxonomies or ontologies in a readable format.  2. Provides methods for storing and retrieving data in a graph database. This data is structured and validated against the aformentioned object oriented database before storage.  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Exporter(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'adapter': 'str',
        'status': 'str',
        'config': 'ExporterConfig',
        'id': 'str',
        'container_id': 'str',
        'created_at': 'str',
        'modified_at': 'str',
        'created_by': 'str',
        'modified_by': 'str',
        'status_message': 'str',
        'destination_type': 'str'
    }

    attribute_map = {
        'adapter': 'adapter',
        'status': 'status',
        'config': 'config',
        'id': 'id',
        'container_id': 'container_id',
        'created_at': 'created_at',
        'modified_at': 'modified_at',
        'created_by': 'created_by',
        'modified_by': 'modified_by',
        'status_message': 'status_message',
        'destination_type': 'destination_type'
    }

    def __init__(self, adapter=None, status=None, config=None, id=None, container_id=None, created_at=None, modified_at=None, created_by=None, modified_by=None, status_message=None, destination_type=None):  # noqa: E501
        """Exporter - a model defined in Swagger"""  # noqa: E501
        self._adapter = None
        self._status = None
        self._config = None
        self._id = None
        self._container_id = None
        self._created_at = None
        self._modified_at = None
        self._created_by = None
        self._modified_by = None
        self._status_message = None
        self._destination_type = None
        self.discriminator = None
        self.adapter = adapter
        self.status = status
        self.config = config
        self.id = id
        self.container_id = container_id
        self.created_at = created_at
        self.modified_at = modified_at
        self.created_by = created_by
        self.modified_by = modified_by
        if status_message is not None:
            self.status_message = status_message
        if destination_type is not None:
            self.destination_type = destination_type

    @property
    def adapter(self):
        """Gets the adapter of this Exporter.  # noqa: E501


        :return: The adapter of this Exporter.  # noqa: E501
        :rtype: str
        """
        return self._adapter

    @adapter.setter
    def adapter(self, adapter):
        """Sets the adapter of this Exporter.


        :param adapter: The adapter of this Exporter.  # noqa: E501
        :type: str
        """
        if adapter is None:
            raise ValueError("Invalid value for `adapter`, must not be `None`")  # noqa: E501

        self._adapter = adapter

    @property
    def status(self):
        """Gets the status of this Exporter.  # noqa: E501


        :return: The status of this Exporter.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this Exporter.


        :param status: The status of this Exporter.  # noqa: E501
        :type: str
        """
        if status is None:
            raise ValueError("Invalid value for `status`, must not be `None`")  # noqa: E501

        self._status = status

    @property
    def config(self):
        """Gets the config of this Exporter.  # noqa: E501


        :return: The config of this Exporter.  # noqa: E501
        :rtype: ExporterConfig
        """
        return self._config

    @config.setter
    def config(self, config):
        """Sets the config of this Exporter.


        :param config: The config of this Exporter.  # noqa: E501
        :type: ExporterConfig
        """
        if config is None:
            raise ValueError("Invalid value for `config`, must not be `None`")  # noqa: E501

        self._config = config

    @property
    def id(self):
        """Gets the id of this Exporter.  # noqa: E501


        :return: The id of this Exporter.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Exporter.


        :param id: The id of this Exporter.  # noqa: E501
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def container_id(self):
        """Gets the container_id of this Exporter.  # noqa: E501


        :return: The container_id of this Exporter.  # noqa: E501
        :rtype: str
        """
        return self._container_id

    @container_id.setter
    def container_id(self, container_id):
        """Sets the container_id of this Exporter.


        :param container_id: The container_id of this Exporter.  # noqa: E501
        :type: str
        """
        if container_id is None:
            raise ValueError("Invalid value for `container_id`, must not be `None`")  # noqa: E501

        self._container_id = container_id

    @property
    def created_at(self):
        """Gets the created_at of this Exporter.  # noqa: E501


        :return: The created_at of this Exporter.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Exporter.


        :param created_at: The created_at of this Exporter.  # noqa: E501
        :type: str
        """
        if created_at is None:
            raise ValueError("Invalid value for `created_at`, must not be `None`")  # noqa: E501

        self._created_at = created_at

    @property
    def modified_at(self):
        """Gets the modified_at of this Exporter.  # noqa: E501


        :return: The modified_at of this Exporter.  # noqa: E501
        :rtype: str
        """
        return self._modified_at

    @modified_at.setter
    def modified_at(self, modified_at):
        """Sets the modified_at of this Exporter.


        :param modified_at: The modified_at of this Exporter.  # noqa: E501
        :type: str
        """
        if modified_at is None:
            raise ValueError("Invalid value for `modified_at`, must not be `None`")  # noqa: E501

        self._modified_at = modified_at

    @property
    def created_by(self):
        """Gets the created_by of this Exporter.  # noqa: E501


        :return: The created_by of this Exporter.  # noqa: E501
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """Sets the created_by of this Exporter.


        :param created_by: The created_by of this Exporter.  # noqa: E501
        :type: str
        """
        if created_by is None:
            raise ValueError("Invalid value for `created_by`, must not be `None`")  # noqa: E501

        self._created_by = created_by

    @property
    def modified_by(self):
        """Gets the modified_by of this Exporter.  # noqa: E501


        :return: The modified_by of this Exporter.  # noqa: E501
        :rtype: str
        """
        return self._modified_by

    @modified_by.setter
    def modified_by(self, modified_by):
        """Sets the modified_by of this Exporter.


        :param modified_by: The modified_by of this Exporter.  # noqa: E501
        :type: str
        """
        if modified_by is None:
            raise ValueError("Invalid value for `modified_by`, must not be `None`")  # noqa: E501

        self._modified_by = modified_by

    @property
    def status_message(self):
        """Gets the status_message of this Exporter.  # noqa: E501


        :return: The status_message of this Exporter.  # noqa: E501
        :rtype: str
        """
        return self._status_message

    @status_message.setter
    def status_message(self, status_message):
        """Sets the status_message of this Exporter.


        :param status_message: The status_message of this Exporter.  # noqa: E501
        :type: str
        """

        self._status_message = status_message

    @property
    def destination_type(self):
        """Gets the destination_type of this Exporter.  # noqa: E501


        :return: The destination_type of this Exporter.  # noqa: E501
        :rtype: str
        """
        return self._destination_type

    @destination_type.setter
    def destination_type(self, destination_type):
        """Sets the destination_type of this Exporter.


        :param destination_type: The destination_type of this Exporter.  # noqa: E501
        :type: str
        """

        self._destination_type = destination_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Exporter, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Exporter):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
