# coding: utf-8

"""
    Deep Lynx

    The construction of megaprojects has consistently demonstrated challenges for project managers in regard to meeting cost, schedule, and performance requirements. Megaproject construction challenges are common place within megaprojects with many active projects in the United States failing to meet cost and schedule efforts by significant margins. Currently, engineering teams operate in siloed tools and disparate teams where connections across design, procurement, and construction systems are translated manually or over brittle point-to-point integrations. The manual nature of data exchange increases the risk of silent errors in the reactor design, with each silent error cascading across the design. These cascading errors lead to uncontrollable risk during construction, resulting in significant delays and cost overruns. Deep Lynx allows for an integrated platform during design and operations of mega projects.  The Deep Lynx Core API delivers a few main features.  1. Provides a set of methods and endpoints for manipulating data in an object oriented database. This allows us to store complex datatypes as records and then to compile them into actual, modifiable objects at run-time. Users can store taxonomies or ontologies in a readable format.  2. Provides methods for storing and retrieving data in a graph database. This data is structured and validated against the aformentioned object oriented database before storage.  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class CreateOrUpdateNodesRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'container_id': 'str',
        'original_data_id': 'str',
        'data_source_id': 'str',
        'metatype_id': 'str',
        'properties': 'object'
    }

    attribute_map = {
        'id': 'id',
        'container_id': 'container_id',
        'original_data_id': 'original_data_id',
        'data_source_id': 'data_source_id',
        'metatype_id': 'metatype_id',
        'properties': 'properties'
    }

    def __init__(self, id=None, container_id=None, original_data_id=None, data_source_id=None, metatype_id=None, properties=None):  # noqa: E501
        """CreateOrUpdateNodesRequest - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._container_id = None
        self._original_data_id = None
        self._data_source_id = None
        self._metatype_id = None
        self._properties = None
        self.discriminator = None
        if id is not None:
            self.id = id
        self.container_id = container_id
        if original_data_id is not None:
            self.original_data_id = original_data_id
        self.data_source_id = data_source_id
        self.metatype_id = metatype_id
        if properties is not None:
            self.properties = properties

    @property
    def id(self):
        """Gets the id of this CreateOrUpdateNodesRequest.  # noqa: E501


        :return: The id of this CreateOrUpdateNodesRequest.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this CreateOrUpdateNodesRequest.


        :param id: The id of this CreateOrUpdateNodesRequest.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def container_id(self):
        """Gets the container_id of this CreateOrUpdateNodesRequest.  # noqa: E501


        :return: The container_id of this CreateOrUpdateNodesRequest.  # noqa: E501
        :rtype: str
        """
        return self._container_id

    @container_id.setter
    def container_id(self, container_id):
        """Sets the container_id of this CreateOrUpdateNodesRequest.


        :param container_id: The container_id of this CreateOrUpdateNodesRequest.  # noqa: E501
        :type: str
        """
        if container_id is None:
            raise ValueError("Invalid value for `container_id`, must not be `None`")  # noqa: E501

        self._container_id = container_id

    @property
    def original_data_id(self):
        """Gets the original_data_id of this CreateOrUpdateNodesRequest.  # noqa: E501

        Passing in just the original data id will attempt to update a node with the same composite id (data source id, metatype id, and original data id).  # noqa: E501

        :return: The original_data_id of this CreateOrUpdateNodesRequest.  # noqa: E501
        :rtype: str
        """
        return self._original_data_id

    @original_data_id.setter
    def original_data_id(self, original_data_id):
        """Sets the original_data_id of this CreateOrUpdateNodesRequest.

        Passing in just the original data id will attempt to update a node with the same composite id (data source id, metatype id, and original data id).  # noqa: E501

        :param original_data_id: The original_data_id of this CreateOrUpdateNodesRequest.  # noqa: E501
        :type: str
        """

        self._original_data_id = original_data_id

    @property
    def data_source_id(self):
        """Gets the data_source_id of this CreateOrUpdateNodesRequest.  # noqa: E501


        :return: The data_source_id of this CreateOrUpdateNodesRequest.  # noqa: E501
        :rtype: str
        """
        return self._data_source_id

    @data_source_id.setter
    def data_source_id(self, data_source_id):
        """Sets the data_source_id of this CreateOrUpdateNodesRequest.


        :param data_source_id: The data_source_id of this CreateOrUpdateNodesRequest.  # noqa: E501
        :type: str
        """
        if data_source_id is None:
            raise ValueError("Invalid value for `data_source_id`, must not be `None`")  # noqa: E501

        self._data_source_id = data_source_id

    @property
    def metatype_id(self):
        """Gets the metatype_id of this CreateOrUpdateNodesRequest.  # noqa: E501


        :return: The metatype_id of this CreateOrUpdateNodesRequest.  # noqa: E501
        :rtype: str
        """
        return self._metatype_id

    @metatype_id.setter
    def metatype_id(self, metatype_id):
        """Sets the metatype_id of this CreateOrUpdateNodesRequest.


        :param metatype_id: The metatype_id of this CreateOrUpdateNodesRequest.  # noqa: E501
        :type: str
        """
        if metatype_id is None:
            raise ValueError("Invalid value for `metatype_id`, must not be `None`")  # noqa: E501

        self._metatype_id = metatype_id

    @property
    def properties(self):
        """Gets the properties of this CreateOrUpdateNodesRequest.  # noqa: E501


        :return: The properties of this CreateOrUpdateNodesRequest.  # noqa: E501
        :rtype: object
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """Sets the properties of this CreateOrUpdateNodesRequest.


        :param properties: The properties of this CreateOrUpdateNodesRequest.  # noqa: E501
        :type: object
        """

        self._properties = properties

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CreateOrUpdateNodesRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateOrUpdateNodesRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
