from rest_framework import serializers

from .models import Photograph


# Class derived from django-stdimage-serializer 0.1.2
class StdImageField(serializers.ImageField):
    """
    Get all the variations of the StdImageField
    """

    def to_native(self, obj):
        return self.get_variations_urls(obj)

    def to_representation(self, obj):
        return self.get_variations_urls(obj)

    def get_variations_urls(self, obj):
        """
        Get all the logo urls.
        """

        # Initiate return object
        return_object = {}

        # Get the field of the object
        field = obj.field

        # A lot of ifs going araound, first check if it has the field variations
        if hasattr(field, "variations"):
            # Get the variations
            variations = field.variations
            # Go through the variations dict
            for key in variations.keys():
                # Just to be sure if the stdimage object has it stored in the obj
                if hasattr(obj, key):
                    # get the by stdimage properties
                    field_obj = getattr(obj, key, None)
                    if field_obj and hasattr(field_obj, "url"):
                        # store it, with the name of the variation type into our return object
                        return_object[key] = super(
                            StdImageField, self
                        ).to_representation(field_obj)

        # Also include the original (if possible)
        if hasattr(obj, "url"):
            return_object["original"] = super(StdImageField, self).to_representation(
                obj
            )

        return return_object


class PhotographSerializer(serializers.ModelSerializer):
    img = StdImageField()

    class Meta:
        model = Photograph
        exclude = ["content_type", "object_id", "dzi_option"]
