from .toast_document import ToastDocument
from .toast_types import Toast
from typing import Optional
from winsdk.windows.ui.notifications import ToastNotifier

class BaseWindowsToaster:
    applicationText: str
    toastNotifier: Optional[ToastNotifier]
    def __init__(self, applicationText: str) -> None: ...
    def setup_toast(self, toast: Toast) -> ToastDocument: ...
    def show_toast(self, toast: Toast) -> None: ...

class WindowsToaster(BaseWindowsToaster):
    def __init__(self, applicationText: str) -> None: ...
    def show_toast(self, toast: Toast) -> None: ...

class InteractableWindowsToaster(BaseWindowsToaster):
    def __init__(self, applicationText: str, notifierAUMI: str = ...) -> None: ...
    def setup_toast(self, toast: Toast) -> ToastDocument: ...
