/*
T-SQL (Transact-SQL, MSSQL) grammar.
The MIT License (MIT).
Copyright (c) 2017, Mark Adams (madams51703@gmail.com)
Copyright (c) 2015-2017, Ivan Kochurkin (kvanttt@gmail.com), Positive Technologies.
Copyright (c) 2016, Scott Ure (scott@redstormsoftware.com).
Copyright (c) 2016, Rui Zhang (ruizhang.ccs@gmail.com).
Copyright (c) 2016, Marcus Henriksson (kuseman80@gmail.com).
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:
The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

lexer grammar TSqlLexer;

// Basic keywords (from https://msdn.microsoft.com/en-us/library/ms189822.aspx)

options { caseInsensitive = true; }


//Keywords that can exist in ID etc
//More keywords that can also be used as IDs
ABORT:                                 'ABORT';
ABORT_AFTER_WAIT:                      'ABORT_AFTER_WAIT';
ABSENT:                                'ABSENT';
ABSOLUTE:                              'ABSOLUTE';
ACCELERATED_DATABASE_RECOVERY:         'ACCELERATED_DATABASE_RECOVERY';
ACCENT_SENSITIVITY:                    'ACCENT_SENSITIVITY';
ACCESS:                                'ACCESS';
ACTION:                                'ACTION';
ACTIVATION:                            'ACTIVATION';
ACTIVE:                                'ACTIVE';
ADD:                                   'ADD';
ADDRESS:                               'ADDRESS';
ADMINISTER:                            'ADMINISTER';
AES:                                   'AES';
AES_128:                               'AES_128';
AES_192:                               'AES_192';
AES_256:                               'AES_256';
AFFINITY:                              'AFFINITY';
AFTER:                                 'AFTER';
AGGREGATE:                             'AGGREGATE';
ALGORITHM:                             'ALGORITHM';
ALL:                                   'ALL';
ALLOWED:                               'ALLOWED';
ALLOW_CONNECTIONS:                     'ALLOW_CONNECTIONS';
ALLOW_ENCRYPTED_VALUE_MODIFICATIONS:   'ALLOW_ENCRYPTED_VALUE_MODIFICATIONS';
ALLOW_MULTIPLE_EVENT_LOSS:             'ALLOW_MULTIPLE_EVENT_LOSS';
ALLOW_PAGE_LOCKS:                      'ALLOW_PAGE_LOCKS';
ALLOW_ROW_LOCKS:                       'ALLOW_ROW_LOCKS';
ALLOW_SINGLE_EVENT_LOSS:               'ALLOW_SINGLE_EVENT_LOSS';
ALLOW_SNAPSHOT_ISOLATION:              'ALLOW_SNAPSHOT_ISOLATION';
ALL_CONSTRAINTS:                       'ALL_CONSTRAINTS';
ALL_ERRORMSGS:                         'ALL_ERRORMSGS';
ALL_INDEXES:                           'ALL_INDEXES';
ALL_LEVELS:                            'ALL_LEVELS';
ALTER:                                 'ALTER';
ALWAYS:                                'ALWAYS';
AND:                                   'AND';
ANONYMOUS:                             'ANONYMOUS';
ANSI_DEFAULTS:                         'ANSI_DEFAULTS';
ANSI_NULLS:                            'ANSI_NULLS';
ANSI_NULL_DEFAULT:                     'ANSI_NULL_DEFAULT';
ANSI_NULL_DFLT_OFF:                    'ANSI_NULL_DFLT_OFF';
ANSI_NULL_DFLT_ON:                     'ANSI_NULL_DFLT_ON';
ANSI_PADDING:                          'ANSI_PADDING';
ANSI_WARNINGS:                         'ANSI_WARNINGS';
ANY:                                   'ANY';
APPEND:                                'APPEND';
APPLICATION:                           'APPLICATION';
APPLICATION_LOG:                       'APPLICATION_LOG';
APPLOCK_MODE:                          'APPLOCK_MODE';
APPLOCK_TEST:                          'APPLOCK_TEST';
APPLY:                                 'APPLY';
APP_NAME:                              'APP_NAME';
ARITHABORT:                            'ARITHABORT';
ARITHIGNORE:                           'ARITHIGNORE';
AS:                                    'AS';
ASC:                                   'ASC';
ASCII:                                 'ASCII';
ASSEMBLY:                              'ASSEMBLY';
ASSEMBLYPROPERTY:                      'ASSEMBLYPROPERTY';
ASYMMETRIC:                            'ASYMMETRIC';
ASYNCHRONOUS_COMMIT:                   'ASYNCHRONOUS_COMMIT';
AT_KEYWORD:                            'AT';
AUDIT:                                 'AUDIT';
AUDIT_GUID:                            'AUDIT_GUID';
AUTHENTICATE:                          'AUTHENTICATE';
AUTHENTICATION:                        'AUTHENTICATION';
AUTHORIZATION:                         'AUTHORIZATION';
AUTO:                                  'AUTO';
AUTOGROW_ALL_FILES:                    'AUTOGROW_ALL_FILES';
AUTOGROW_SINGLE_FILE:                  'AUTOGROW_SINGLE_FILE';
AUTOMATED_BACKUP_PREFERENCE:           'AUTOMATED_BACKUP_PREFERENCE';
AUTOMATIC:                             'AUTOMATIC';
AUTO_CLEANUP:                          'AUTO_CLEANUP';
AUTO_CLOSE:                            'AUTO_CLOSE';
AUTO_CREATE_STATISTICS:                'AUTO_CREATE_STATISTICS';
AUTO_DROP:                             'AUTO_DROP';
AUTO_SHRINK:                           'AUTO_SHRINK';
AUTO_UPDATE_STATISTICS:                'AUTO_UPDATE_STATISTICS';
AUTO_UPDATE_STATISTICS_ASYNC:          'AUTO_UPDATE_STATISTICS_ASYNC';
AVAILABILITY:                          'AVAILABILITY';
AVAILABILITY_MODE:                     'AVAILABILITY_MODE';
AVG:                                   'AVG';
BACKSLASH:                             '\\';
BACKUP:                                'BACKUP';
BACKUP_CLONEDB:                        'BACKUP_CLONEDB';
BACKUP_PRIORITY:                       'BACKUP_PRIORITY';
BASE64:                                'BASE64';
BEFORE:                                'BEFORE';
BEGIN:                                 'BEGIN';
BEGIN_DIALOG:                          'BEGIN_DIALOG';
BETWEEN:                               'BETWEEN';
BIGINT:                                'BIGINT';
BINARY_CHECKSUM:                       'BINARY_CHECKSUM';
BINARY_KEYWORD:                        'BINARY';
BINDING:                               'BINDING';
BLOB_STORAGE:                          'BLOB_STORAGE';
BLOCK:                                 'BLOCK';
BLOCKERS:                              'BLOCKERS';
BLOCKING_HIERARCHY:                    'BLOCKING_HIERARCHY';
BLOCKSIZE:                             'BLOCKSIZE';
BREAK:                                 'BREAK';
BROKER:                                'BROKER';
BROKER_INSTANCE:                       'BROKER_INSTANCE';
BROWSE:                                'BROWSE';
BUFFER:                                'BUFFER';
BUFFERCOUNT:                           'BUFFERCOUNT';
BULK:                                  'BULK';
BULK_LOGGED:                           'BULK_LOGGED';
BY:                                    'BY';
CACHE:                                 'CACHE';
CALLED:                                'CALLED';
CALLER:                                'CALLER';
CAP_CPU_PERCENT:                       'CAP_CPU_PERCENT';
CASCADE:                               'CASCADE';
CASE:                                  'CASE';
CAST:                                  'CAST';
CATALOG:                               'CATALOG';
CATCH:                                 'CATCH';
CERTENCODED:                           'CERTENCODED';
CERTIFICATE:                           'CERTIFICATE';
CERTPRIVATEKEY:                        'CERTPRIVATEKEY';
CERT_ID:                               'CERT_ID';
CHANGE:                                'CHANGE';
CHANGES:                               'CHANGES';
CHANGETABLE:                           'CHANGETABLE';
CHANGE_RETENTION:                      'CHANGE_RETENTION';
CHANGE_TRACKING:                       'CHANGE_TRACKING';
CHAR:                                  'CHAR';
CHARINDEX:                             'CHARINDEX';
CHECK:                                 'CHECK';
CHECKALLOC:                            'CHECKALLOC';
CHECKCATALOG:                          'CHECKCATALOG';
CHECKCONSTRAINTS:                      'CHECKCONSTRAINTS';
CHECKDB:                               'CHECKDB';
CHECKFILEGROUP:                        'CHECKFILEGROUP';
CHECKPOINT:                            'CHECKPOINT';
CHECKSUM:                              'CHECKSUM';
CHECKSUM_AGG:                          'CHECKSUM_AGG';
CHECKTABLE:                            'CHECKTABLE';
CHECK_EXPIRATION:                      'CHECK_EXPIRATION';
CHECK_POLICY:                          'CHECK_POLICY';
CLASSIFIER_FUNCTION:                   'CLASSIFIER_FUNCTION';
CLEANTABLE:                            'CLEANTABLE';
CLEANUP:                               'CLEANUP';
CLONEDATABASE:                         'CLONEDATABASE';
CLOSE:                                 'CLOSE';
CLUSTER:                               'CLUSTER';
CLUSTERED:                             'CLUSTERED';
COALESCE:                              'COALESCE';
COLLATE:                               'COLLATE';
COLLECTION:                            'COLLECTION';
COLUMN:                                'COLUMN';
COLUMNPROPERTY:                        'COLUMNPROPERTY';
COLUMNS:                               'COLUMNS';
COLUMNSTORE:                           'COLUMNSTORE';
COLUMNSTORE_ARCHIVE:                   'COLUMNSTORE_ARCHIVE';
COLUMN_ENCRYPTION_KEY:                 'COLUMN_ENCRYPTION_KEY';
COLUMN_MASTER_KEY:                     'COLUMN_MASTER_KEY';
COL_LENGTH:                            'COL_LENGTH';
COL_NAME:                              'COL_NAME';
COMMIT:                                'COMMIT';
COMMITTED:                             'COMMITTED';
COMPATIBILITY_LEVEL:                   'COMPATIBILITY_LEVEL';
COMPRESS:                              'COMPRESS';
COMPRESSION:                           'COMPRESSION';
COMPRESSION_DELAY:                     'COMPRESSION_DELAY';
COMPRESS_ALL_ROW_GROUPS:               'COMPRESS_ALL_ROW_GROUPS';
COMPUTE:                               'COMPUTE';
CONCAT:                                'CONCAT';
CONCAT_NULL_YIELDS_NULL:               'CONCAT_NULL_YIELDS_NULL';
CONCAT_WS:                             'CONCAT_WS';
CONFIGURATION:                         'CONFIGURATION';
CONNECT:                               'CONNECT';
CONNECTION:                            'CONNECTION';
CONNECTIONPROPERTY:                    'CONNECTIONPROPERTY';
CONSTRAINT:                            'CONSTRAINT';
CONTAINMENT:                           'CONTAINMENT';
CONTAINS:                              'CONTAINS';
CONTAINSTABLE:                         'CONTAINSTABLE';
CONTENT:                               'CONTENT';
CONTEXT:                               'CONTEXT';
CONTEXT_INFO:                          'CONTEXT_INFO';
CONTINUE:                              'CONTINUE';
CONTINUE_AFTER_ERROR:                  'CONTINUE_AFTER_ERROR';
CONTRACT:                              'CONTRACT';
CONTRACT_NAME:                         'CONTRACT_NAME';
CONTROL:                               'CONTROL';
CONVERSATION:                          'CONVERSATION';
CONVERT:                               'TRY_'? 'CONVERT';
COOKIE:                                'COOKIE';
COPY_ONLY:                             'COPY_ONLY';
COUNT:                                 'COUNT';
COUNTER:                               'COUNTER';
COUNT_BIG:                             'COUNT_BIG';
CPU:                                   'CPU';
CREATE:                                'CREATE';
CREATE_NEW:                            'CREATE_NEW';
CREATION_DISPOSITION:                  'CREATION_DISPOSITION';
CREDENTIAL:                            'CREDENTIAL';
CROSS:                                 'CROSS';
CRYPTOGRAPHIC:                         'CRYPTOGRAPHIC';
CUME_DIST:                             'CUME_DIST';
CURRENT:                               'CURRENT';
CURRENT_DATE:                          'CURRENT_DATE';
CURRENT_REQUEST_ID:                    'CURRENT_REQUEST_ID';
CURRENT_TIME:                          'CURRENT_TIME';
CURRENT_TIMESTAMP:                     'CURRENT_TIMESTAMP';
CURRENT_TRANSACTION_ID:                'CURRENT_TRANSACTION_ID';
CURRENT_USER:                          'CURRENT_USER';
CURSOR:                                'CURSOR';
CURSOR_CLOSE_ON_COMMIT:                'CURSOR_CLOSE_ON_COMMIT';
CURSOR_DEFAULT:                        'CURSOR_DEFAULT';
CURSOR_STATUS:                         'CURSOR_STATUS';
CYCLE:                                 'CYCLE';
DATA:                                  'DATA';
DATABASE:                              'DATABASE';
DATABASEPROPERTYEX:                    'DATABASEPROPERTYEX';
DATABASE_MIRRORING:                    'DATABASE_MIRRORING';
DATABASE_PRINCIPAL_ID:                 'DATABASE_PRINCIPAL_ID';
DATALENGTH:                            'DATALENGTH';
DATASPACE:                             'DATASPACE';
DATA_COMPRESSION:                      'DATA_COMPRESSION';
DATA_PURITY:                           'DATA_PURITY';
DATA_SOURCE:                           'DATA_SOURCE';
DATEADD:                               'DATEADD';
DATEDIFF:                              'DATEDIFF';
DATENAME:                              'DATENAME';
DATEPART:                              'DATEPART';
DATE_CORRELATION_OPTIMIZATION:         'DATE_CORRELATION_OPTIMIZATION';
DAYS:                                  'DAYS';
DBCC:                                  'DBCC';
DBREINDEX:                             'DBREINDEX';
DB_CHAINING:                           'DB_CHAINING';
DB_FAILOVER:                           'DB_FAILOVER';
DB_ID:                                 'DB_ID';
DB_NAME:                               'DB_NAME';
DDL:                                   'DDL';
DEALLOCATE:                            'DEALLOCATE';
DECLARE:                               'DECLARE';
DECOMPRESS:                            'DECOMPRESS';
DECRYPTION:                            'DECRYPTION';
DEFAULT:                               'DEFAULT';
DEFAULT_DATABASE:                      'DEFAULT_DATABASE';
DEFAULT_DOUBLE_QUOTE:                  ["]'DEFAULT'["];
DEFAULT_FULLTEXT_LANGUAGE:             'DEFAULT_FULLTEXT_LANGUAGE';
DEFAULT_LANGUAGE:                      'DEFAULT_LANGUAGE';
DEFAULT_SCHEMA:                        'DEFAULT_SCHEMA';
DEFINITION:                            'DEFINITION';
DELAY:                                 'DELAY';
DELAYED_DURABILITY:                    'DELAYED_DURABILITY';
DELETE:                                'DELETE';
DELETED:                               'DELETED';
DENSE_RANK:                            'DENSE_RANK';
DENY:                                  'DENY';
DEPENDENTS:                            'DEPENDENTS';
DES:                                   'DES';
DESC:                                  'DESC';
DESCRIPTION:                           'DESCRIPTION';
DESX:                                  'DESX';
DETERMINISTIC:                         'DETERMINISTIC';
DHCP:                                  'DHCP';
DIAGNOSTICS:                           'DIAGNOSTICS';
DIALOG:                                'DIALOG';
DIFFERENCE:                            'DIFFERENCE';
DIFFERENTIAL:                          'DIFFERENTIAL';
DIRECTORY_NAME:                        'DIRECTORY_NAME';
DISABLE:                               'DISABLE';
DISABLED:                              'DISABLED';
DISABLE_BROKER:                        'DISABLE_BROKER';
DISK:                                  'DISK';
DISTINCT:                              'DISTINCT';
DISTRIBUTED:                           'DISTRIBUTED';
DISTRIBUTION:                          'DISTRIBUTION';
DOCUMENT:                              'DOCUMENT';
DOLLAR_PARTITION:                      '$PARTITION';
DOUBLE:                                'DOUBLE';
DOUBLE_BACK_SLASH:                     '\\\\';
DOUBLE_FORWARD_SLASH:                  '//';
DROP:                                  'DROP';
DROPCLEANBUFFERS:                      'DROPCLEANBUFFERS';
DROP_EXISTING:                         'DROP_EXISTING';
DTC_SUPPORT:                           'DTC_SUPPORT';
DUMP:                                  'DUMP';
DYNAMIC:                               'DYNAMIC';
ELEMENTS:                              'ELEMENTS';
ELSE:                                  'ELSE';
EMERGENCY:                             'EMERGENCY';
EMPTY:                                 'EMPTY';
ENABLE:                                'ENABLE';
ENABLED:                               'ENABLED';
ENABLE_BROKER:                         'ENABLE_BROKER';
ENCRYPTED:                             'ENCRYPTED';
ENCRYPTED_VALUE:                       'ENCRYPTED_VALUE';
ENCRYPTION:                            'ENCRYPTION';
ENCRYPTION_TYPE:                       'ENCRYPTION_TYPE';
END:                                   'END';
ENDPOINT:                              'ENDPOINT';
ENDPOINT_URL:                          'ENDPOINT_URL';
ERRLVL:                                'ERRLVL';
ERROR:                                 'ERROR';
ERROR_BROKER_CONVERSATIONS:            'ERROR_BROKER_CONVERSATIONS';
ERROR_LINE:                            'ERROR_LINE';
ERROR_MESSAGE:                         'ERROR_MESSAGE';
ERROR_NUMBER:                          'ERROR_NUMBER';
ERROR_PROCEDURE:                       'ERROR_PROCEDURE';
ERROR_SEVERITY:                        'ERROR_SEVERITY';
ERROR_STATE:                           'ERROR_STATE';
ESCAPE:                                'ESCAPE';
ESTIMATEONLY:                          'ESTIMATEONLY';
EVENT:                                 'EVENT';
EVENTDATA:                             'EVENTDATA';
EVENT_RETENTION_MODE:                  'EVENT_RETENTION_MODE';
EXCEPT:                                'EXCEPT';
EXCLUSIVE:                             'EXCLUSIVE';
EXECUTABLE:                            'EXECUTABLE';
EXECUTABLE_FILE:                       'EXECUTABLE_FILE';
EXECUTE:                               'EXEC' 'UTE'?;
EXIST:                                 'EXIST';
EXISTS:                                'EXISTS';
EXIST_SQUARE_BRACKET:                  '[EXIST]';
EXIT:                                  'EXIT';
EXPAND:                                'EXPAND';
EXPIREDATE:                            'EXPIREDATE';
EXPIRY_DATE:                           'EXPIRY_DATE';
EXPLICIT:                              'EXPLICIT';
EXTENDED_LOGICAL_CHECKS:               'EXTENDED_LOGICAL_CHECKS';
EXTENSION:                             'EXTENSION';
EXTERNAL:                              'EXTERNAL';
EXTERNAL_ACCESS:                       'EXTERNAL_ACCESS';
FAILOVER:                              'FAILOVER';
FAILOVER_MODE:                         'FAILOVER_MODE';
FAILURE:                               'FAILURE';
FAILURECONDITIONLEVEL:                 'FAILURECONDITIONLEVEL';
FAILURE_CONDITION_LEVEL:               'FAILURE_CONDITION_LEVEL';
FAIL_OPERATION:                        'FAIL_OPERATION';
FAN_IN:                                'FAN_IN';
FAST:                                  'FAST';
FAST_FORWARD:                          'FAST_FORWARD';
FETCH:                                 'FETCH';
FILE:                                  'FILE';
FILEGROUP:                             'FILEGROUP';
FILEGROUPPROPERTY:                     'FILEGROUPPROPERTY';
FILEGROUP_ID:                          'FILEGROUP_ID';
FILEGROUP_NAME:                        'FILEGROUP_NAME';
FILEGROWTH:                            'FILEGROWTH';
FILENAME:                              'FILENAME';
FILEPATH:                              'FILEPATH';
FILEPROPERTY:                          'FILEPROPERTY';
FILEPROPERTYEX:                        'FILEPROPERTYEX';
FILESTREAM:                            'FILESTREAM';
FILESTREAM_ON:                         'FILESTREAM_ON';
FILE_ID:                               'FILE_ID';
FILE_IDEX:                             'FILE_IDEX';
FILE_NAME:                             'FILE_NAME';
FILE_SNAPSHOT:                         'FILE_SNAPSHOT';
FILLFACTOR:                            'FILLFACTOR';
FILTER:                                'FILTER';
FIRST:                                 'FIRST';
FIRST_VALUE:                           'FIRST_VALUE';
FMTONLY:                               'FMTONLY';
FOLLOWING:                             'FOLLOWING';
FOR:                                   'FOR';
FORCE:                                 'FORCE';
FORCED:                                'FORCED';
FORCEPLAN:                             'FORCEPLAN';
FORCESCAN:                             'FORCESCAN';
FORCESEEK:                             'FORCESEEK';
FORCE_FAILOVER_ALLOW_DATA_LOSS:        'FORCE_FAILOVER_ALLOW_DATA_LOSS';
FORCE_SERVICE_ALLOW_DATA_LOSS:         'FORCE_SERVICE_ALLOW_DATA_LOSS';
FOREIGN:                               'FOREIGN';
FORMAT:                                'FORMAT';
FORMATMESSAGE:                         'FORMATMESSAGE';
FORWARD_ONLY:                          'FORWARD_ONLY';
FREE:                                  'FREE';
FREETEXT:                              'FREETEXT';
FREETEXTTABLE:                         'FREETEXTTABLE';
FROM:                                  'FROM';
FULL:                                  'FULL';
FULLSCAN:                              'FULLSCAN';
FULLTEXT:                              'FULLTEXT';
FULLTEXTCATALOGPROPERTY:               'FULLTEXTCATALOGPROPERTY';
FULLTEXTSERVICEPROPERTY:               'FULLTEXTSERVICEPROPERTY';
FUNCTION:                              'FUNCTION';
GB:                                    'GB';
GENERATED:                             'GENERATED';
GET:                                   'GET';
GETANCESTOR:                           'GETANCESTOR';
GETANSINULL:                           'GETANSINULL';
GETDATE:                               'GETDATE';
GETDESCENDANT:                         'GETDESCENDANT';
GETLEVEL:                              'GETLEVEL';
GETREPARENTEDVALUE:                    'GETREPARENTEDVALUE';
GETROOT:                               'GETROOT';
GETUTCDATE:                            'GETUTCDATE';
GET_FILESTREAM_TRANSACTION_CONTEXT:    'GET_FILESTREAM_TRANSACTION_CONTEXT';
GLOBAL:                                'GLOBAL';
GO:                                    'GO';
GOTO:                                  'GOTO';
GOVERNOR:                              'GOVERNOR';
GRANT:                                 'GRANT';
GREATEST:                              'GREATEST';
GROUP:                                 'GROUP';
GROUPING:                              'GROUPING';
GROUPING_ID:                           'GROUPING_ID';
GROUP_MAX_REQUESTS:                    'GROUP_MAX_REQUESTS';
HADR:                                  'HADR';
HASH:                                  'HASH';
HASHED:                                'HASHED';
HAS_DBACCESS:                          'HAS_DBACCESS';
HAS_PERMS_BY_NAME:                     'HAS_PERMS_BY_NAME';
HAVING:                                'HAVING';
HEALTHCHECKTIMEOUT:                    'HEALTHCHECKTIMEOUT';
HEALTH_CHECK_TIMEOUT:                  'HEALTH_CHECK_TIMEOUT';
HEAP:                                  'HEAP';
HIDDEN_KEYWORD:                        'HIDDEN';
HIERARCHYID:                           'HIERARCHYID';
HIGH:                                  'HIGH';
HOLDLOCK:                              'HOLDLOCK';
HONOR_BROKER_PRIORITY:                 'HONOR_BROKER_PRIORITY';
HOST_ID:                               'HOST_ID';
HOST_NAME:                             'HOST_NAME';
HOURS:                                 'HOURS';
IDENTITY:                              'IDENTITY';
IDENTITYCOL:                           'IDENTITYCOL';
IDENTITY_INSERT:                       'IDENTITY_INSERT';
IDENTITY_VALUE:                        'IDENTITY_VALUE';
IDENT_CURRENT:                         'IDENT_CURRENT';
IDENT_INCR:                            'IDENT_INCR';
IDENT_SEED:                            'IDENT_SEED';
IF:                                    'IF';
IGNORE_CONSTRAINTS:                    'IGNORE_CONSTRAINTS';
IGNORE_DUP_KEY:                        'IGNORE_DUP_KEY';
IGNORE_NONCLUSTERED_COLUMNSTORE_INDEX: 'IGNORE_NONCLUSTERED_COLUMNSTORE_INDEX';
IGNORE_REPLICATED_TABLE_CACHE:         'IGNORE_REPLICATED_TABLE_CACHE';
IGNORE_TRIGGERS:                       'IGNORE_TRIGGERS';
IIF:                                   'IIF';
IMMEDIATE:                             'IMMEDIATE';
IMPERSONATE:                           'IMPERSONATE';
IMPLICIT_TRANSACTIONS:                 'IMPLICIT_TRANSACTIONS';
IMPORTANCE:                            'IMPORTANCE';
IN:                                    'IN';
INCLUDE:                               'INCLUDE';
INCLUDE_NULL_VALUES:                   'INCLUDE_NULL_VALUES';
INCREMENT:                             'INCREMENT';
INCREMENTAL:                           'INCREMENTAL';
INDEX:                                 'INDEX';
INDEXKEY_PROPERTY:                     'INDEXKEY_PROPERTY';
INDEXPROPERTY:                         'INDEXPROPERTY';
INDEX_COL:                             'INDEX_COL';
INFINITE:                              'INFINITE';
INIT:                                  'INIT';
INITIATOR:                             'INITIATOR';
INNER:                                 'INNER';
INPUT:                                 'INPUT';
INSENSITIVE:                           'INSENSITIVE';
INSERT:                                'INSERT';
INSERTED:                              'INSERTED';
INSTEAD:                               'INSTEAD';
INT:                                   'INT';
INTERSECT:                             'INTERSECT';
INTO:                                  'INTO';
IO:                                    'IO';
IP:                                    'IP';
IS:                                    'IS';
ISDESCENDANTOF:                        'ISDESCENDANTOF';
ISJSON:                                'ISJSON';
ISNULL:                                'ISNULL';
ISNUMERIC:                             'ISNUMERIC';
ISOLATION:                             'ISOLATION';
IS_MEMBER:                             'IS_MEMBER';
IS_ROLEMEMBER:                         'IS_ROLEMEMBER';
IS_SRVROLEMEMBER:                      'IS_SRVROLEMEMBER';
JOB:                                   'JOB';
JOIN:                                  'JOIN';
JSON:                                  'JSON';
JSON_ARRAY:                            'JSON_ARRAY';
JSON_MODIFY:                           'JSON_MODIFY';
JSON_OBJECT:                           'JSON_OBJECT';
JSON_PATH_EXISTS:                      'JSON_PATH_EXISTS';
JSON_QUERY:                            'JSON_QUERY';
JSON_VALUE:                            'JSON_VALUE';
KB:                                    'KB';
KEEP:                                  'KEEP';
KEEPDEFAULTS:                          'KEEPDEFAULTS';
KEEPFIXED:                             'KEEPFIXED';
KEEPIDENTITY:                          'KEEPIDENTITY';
KERBEROS:                              'KERBEROS';
KEY:                                   'KEY';
KEYS:                                  'KEYS';
KEYSET:                                'KEYSET';
KEY_PATH:                              'KEY_PATH';
KEY_SOURCE:                            'KEY_SOURCE';
KEY_STORE_PROVIDER_NAME:               'KEY_STORE_PROVIDER_NAME';
KILL:                                  'KILL';
LAG:                                   'LAG';
LANGUAGE:                              'LANGUAGE';
LAST:                                  'LAST';
LAST_VALUE:                            'LAST_VALUE';
LEAD:                                  'LEAD';
LEAST:                                 'LEAST';
LEFT:                                  'LEFT';
LEN:                                   'LEN';
LEVEL:                                 'LEVEL';
LIBRARY:                               'LIBRARY';
LIFETIME:                              'LIFETIME';
LIKE:                                  'LIKE';
LINENO:                                'LINENO';
LINKED:                                'LINKED';
LINUX:                                 'LINUX';
LIST:                                  'LIST';
LISTENER:                              'LISTENER';
LISTENER_IP:                           'LISTENER_IP';
LISTENER_PORT:                         'LISTENER_PORT';
LISTENER_URL:                          'LISTENER_URL';
LOAD:                                  'LOAD';
LOB_COMPACTION:                        'LOB_COMPACTION';
LOCAL:                                 'LOCAL';
LOCAL_SERVICE_NAME:                    'LOCAL_SERVICE_NAME';
LOCATION:                              'LOCATION';
LOCK:                                  'LOCK';
LOCK_ESCALATION:                       'LOCK_ESCALATION';
LOG:                                   'LOG';
LOGIN:                                 'LOGIN';
LOGINPROPERTY:                         'LOGINPROPERTY';
LOOP:                                  'LOOP';
LOW:                                   'LOW';
LOWER:                                 'LOWER';
LTRIM:                                 'LTRIM';
MANUAL:                                'MANUAL';
MARK:                                  'MARK';
MASK:                                  'MASK';
MASKED:                                'MASKED';
MASTER:                                'MASTER';
MATCHED:                               'MATCHED';
MATERIALIZED:                          'MATERIALIZED';
MAX:                                   'MAX';
MAXDOP:                                'MAXDOP';
MAXRECURSION:                          'MAXRECURSION';
MAXSIZE:                               'MAXSIZE';
MAXTRANSFER:                           'MAXTRANSFER';
MAXVALUE:                              'MAXVALUE';
MAX_CPU_PERCENT:                       'MAX_CPU_PERCENT';
MAX_DISPATCH_LATENCY:                  'MAX_DISPATCH_LATENCY';
MAX_DOP:                               'MAX_DOP';
MAX_DURATION:                          'MAX_DURATION';
MAX_EVENT_SIZE:                        'MAX_EVENT_SIZE';
MAX_FILES:                             'MAX_FILES';
MAX_IOPS_PER_VOLUME:                   'MAX_IOPS_PER_VOLUME';
MAX_MEMORY:                            'MAX_MEMORY';
MAX_MEMORY_PERCENT:                    'MAX_MEMORY_PERCENT';
MAX_OUTSTANDING_IO_PER_VOLUME:         'MAX_OUTSTANDING_IO_PER_VOLUME';
MAX_PROCESSES:                         'MAX_PROCESSES';
MAX_QUEUE_READERS:                     'MAX_QUEUE_READERS';
MAX_ROLLOVER_FILES:                    'MAX_ROLLOVER_FILES';
MAX_SIZE:                              'MAX_SIZE';
MB:                                    'MB';
MEDIADESCRIPTION:                      'MEDIADESCRIPTION';
MEDIANAME:                             'MEDIANAME';
MEDIUM:                                'MEDIUM';
MEMBER:                                'MEMBER';
MEMORY_OPTIMIZED_DATA:                 'MEMORY_OPTIMIZED_DATA';
MEMORY_PARTITION_MODE:                 'MEMORY_PARTITION_MODE';
MERGE:                                 'MERGE';
MESSAGE:                               'MESSAGE';
MESSAGE_FORWARDING:                    'MESSAGE_FORWARDING';
MESSAGE_FORWARD_SIZE:                  'MESSAGE_FORWARD_SIZE';
MIN:                                   'MIN';
MINUTES:                               'MINUTES';
MINVALUE:                              'MINVALUE';
MIN_ACTIVE_ROWVERSION:                 'MIN_ACTIVE_ROWVERSION';
MIN_CPU_PERCENT:                       'MIN_CPU_PERCENT';
MIN_IOPS_PER_VOLUME:                   'MIN_IOPS_PER_VOLUME';
MIN_MEMORY_PERCENT:                    'MIN_MEMORY_PERCENT';
MIRROR:                                'MIRROR';
MIRROR_ADDRESS:                        'MIRROR_ADDRESS';
MIXED_PAGE_ALLOCATION:                 'MIXED_PAGE_ALLOCATION';
MODE:                                  'MODE';
MODIFY:                                'MODIFY';
MODIFY_SQUARE_BRACKET:                 '[MODIFY]';
MOVE:                                  'MOVE';
MULTI_USER:                            'MULTI_USER';
MUST_CHANGE:                           'MUST_CHANGE';
NAME:                                  'NAME';
NATIONAL:                              'NATIONAL';
NCHAR:                                 'NCHAR';
NEGOTIATE:                             'NEGOTIATE';
NESTED_TRIGGERS:                       'NESTED_TRIGGERS';
NEWID:                                 'NEWID';
NEWNAME:                               'NEWNAME';
NEWSEQUENTIALID:                       'NEWSEQUENTIALID';
NEW_ACCOUNT:                           'NEW_ACCOUNT';
NEW_BROKER:                            'NEW_BROKER';
NEW_PASSWORD:                          'NEW_PASSWORD';
NEXT:                                  'NEXT';
NO:                                    'NO';
NOCHECK:                               'NOCHECK';
NOCOUNT:                               'NOCOUNT';
NODES:                                 'NODES';
NOEXEC:                                'NOEXEC';
NOEXPAND:                              'NOEXPAND';
NOFORMAT:                              'NOFORMAT';
NOHOLDLOCK:                            'NOHOLDLOCK';
NOINDEX:                               'NOINDEX';
NOINIT:                                'NOINIT';
NOLOCK:                                'NOLOCK';
NONCLUSTERED:                          'NONCLUSTERED';
NONE:                                  'NONE';
NON_TRANSACTED_ACCESS:                 'NON_TRANSACTED_ACCESS';
NORECOMPUTE:                           'NORECOMPUTE';
NORECOVERY:                            'NORECOVERY';
NOREWIND:                              'NOREWIND';
NOSKIP:                                'NOSKIP';
NOT:                                   'NOT';
NOTIFICATION:                          'NOTIFICATION';
NOTIFICATIONS:                         'NOTIFICATIONS';
NOUNLOAD:                              'NOUNLOAD';
NOWAIT:                                'NOWAIT';
NO_CHECKSUM:                           'NO_CHECKSUM';
NO_COMPRESSION:                        'NO_COMPRESSION';
NO_EVENT_LOSS:                         'NO_EVENT_LOSS';
NO_INFOMSGS:                           'NO_INFOMSGS';
NO_QUERYSTORE:                         'NO_QUERYSTORE';
NO_STATISTICS:                         'NO_STATISTICS';
NO_TRUNCATE:                           'NO_TRUNCATE';
NO_WAIT:                               'NO_WAIT';
NTILE:                                 'NTILE';
NTLM:                                  'NTLM';
NULLIF:                                'NULLIF';
NULL_:                                 'NULL';
NULL_DOUBLE_QUOTE:                     ["]'NULL'["];
NUMANODE:                              'NUMANODE';
NUMBER:                                'NUMBER';
NUMERIC_ROUNDABORT:                    'NUMERIC_ROUNDABORT';
OBJECT:                                'OBJECT';
OBJECTPROPERTY:                        'OBJECTPROPERTY';
OBJECTPROPERTYEX:                      'OBJECTPROPERTYEX';
OBJECT_DEFINITION:                     'OBJECT_DEFINITION';
OBJECT_ID:                             'OBJECT_ID';
OBJECT_NAME:                           'OBJECT_NAME';
OBJECT_SCHEMA_NAME:                    'OBJECT_SCHEMA_NAME';
OF:                                    'OF';
OFF:                                   'OFF';
OFFLINE:                               'OFFLINE';
OFFSET:                                'OFFSET';
OFFSETS:                               'OFFSETS';
OLD_ACCOUNT:                           'OLD_ACCOUNT';
OLD_PASSWORD:                          'OLD_PASSWORD';
ON:                                    'ON';
ONLINE:                                'ONLINE';
ONLY:                                  'ONLY';
ON_FAILURE:                            'ON_FAILURE';
OPEN:                                  'OPEN';
OPENDATASOURCE:                        'OPENDATASOURCE';
OPENJSON:                              'OPENJSON';
OPENQUERY:                             'OPENQUERY';
OPENROWSET:                            'OPENROWSET';
OPENXML:                               'OPENXML';
OPEN_EXISTING:                         'OPEN_EXISTING';
OPERATIONS:                            'OPERATIONS';
OPTIMISTIC:                            'OPTIMISTIC';
OPTIMIZE:                              'OPTIMIZE';
OPTIMIZE_FOR_SEQUENTIAL_KEY:           'OPTIMIZE_FOR_SEQUENTIAL_KEY';
OPTION:                                'OPTION';
OR:                                    'OR';
ORDER:                                 'ORDER';
ORIGINAL_DB_NAME:                      'ORIGINAL_DB_NAME';
ORIGINAL_LOGIN:                        'ORIGINAL_LOGIN';
OUT:                                   'OUT';
OUTER:                                 'OUTER';
OUTPUT:                                'OUTPUT';
OVER:                                  'OVER';
OVERRIDE:                              'OVERRIDE';
OWNER:                                 'OWNER';
OWNERSHIP:                             'OWNERSHIP';
PAD_INDEX:                             'PAD_INDEX';
PAGE:                                  'PAGE';
PAGECOUNT:                             'PAGECOUNT';
PAGE_VERIFY:                           'PAGE_VERIFY';
PAGLOCK:                               'PAGLOCK';
PARAMETERIZATION:                      'PARAMETERIZATION';
PARAM_NODE:                            'PARAM_NODE';
PARSE:                                 'TRY_'? 'PARSE';
PARSENAME:                             'PARSENAME';
PARSEONLY:                             'PARSEONLY';
PARTIAL:                               'PARTIAL';
PARTITION:                             'PARTITION';
PARTITIONS:                            'PARTITIONS';
PARTNER:                               'PARTNER';
PASSWORD:                              'PASSWORD';
PATH:                                  'PATH';
PATINDEX:                              'PATINDEX';
PAUSE:                                 'PAUSE';
PDW_SHOWSPACEUSED:                     'PDW_SHOWSPACEUSED';
PERCENT:                               'PERCENT';
PERCENTILE_CONT:                       'PERCENTILE_CONT';
PERCENTILE_DISC:                       'PERCENTILE_DISC';
PERCENT_RANK:                          'PERCENT_RANK';
PERMISSIONS:                           'PERMISSIONS';
PERMISSION_SET:                        'PERMISSION_SET';
PERSISTED:                             'PERSISTED';
PERSIST_SAMPLE_PERCENT:                'PERSIST_SAMPLE_PERCENT';
PER_CPU:                               'PER_CPU';
PER_DB:                                'PER_DB';
PER_NODE:                              'PER_NODE';
PHYSICAL_ONLY:                         'PHYSICAL_ONLY';
PIVOT:                                 'PIVOT';
PLAN:                                  'PLAN';
PLATFORM:                              'PLATFORM';
POISON_MESSAGE_HANDLING:               'POISON_MESSAGE_HANDLING';
POLICY:                                'POLICY';
POOL:                                  'POOL';
PORT:                                  'PORT';
PRECEDING:                             'PRECEDING';
PRECISION:                             'PRECISION';
PREDICATE:                             'PREDICATE';
PRIMARY:                               'PRIMARY';
PRIMARY_ROLE:                          'PRIMARY_ROLE';
PRINT:                                 'PRINT';
PRIOR:                                 'PRIOR';
PRIORITY:                              'PRIORITY';
PRIORITY_LEVEL:                        'PRIORITY_LEVEL';
PRIVATE:                               'PRIVATE';
PRIVATE_KEY:                           'PRIVATE_KEY';
PRIVILEGES:                            'PRIVILEGES';
PROC:                                  'PROC';
PROCCACHE:                             'PROCCACHE';
PROCEDURE:                             'PROCEDURE';
PROCEDURE_NAME:                        'PROCEDURE_NAME';
PROCESS:                               'PROCESS';
PROFILE:                               'PROFILE';
PROPERTY:                              'PROPERTY';
PROVIDER:                              'PROVIDER';
PROVIDER_KEY_NAME:                     'PROVIDER_KEY_NAME';
PUBLIC:                                'PUBLIC';
PWDCOMPARE:                            'PWDCOMPARE';
PWDENCRYPT:                            'PWDENCRYPT';
PYTHON:                                'PYTHON';
QUERY:                                 'QUERY';
QUERY_SQUARE_BRACKET:                  '[QUERY]';
QUEUE:                                 'QUEUE';
QUEUE_DELAY:                           'QUEUE_DELAY';
QUOTED_IDENTIFIER:                     'QUOTED_IDENTIFIER';
QUOTENAME:                             'QUOTENAME';
R:                                     'R';
RAISERROR:                             'RAISERROR';
RANDOMIZED:                            'RANDOMIZED';
RANGE:                                 'RANGE';
RANK:                                  'RANK';
RAW:                                   'RAW';
RC2:                                   'RC2';
RC4:                                   'RC4';
RC4_128:                               'RC4_128';
READ:                                  'READ';
READCOMMITTED:                         'READCOMMITTED';
READCOMMITTEDLOCK:                     'READCOMMITTEDLOCK';
READONLY:                              'READONLY';
READPAST:                              'READPAST';
READTEXT:                              'READTEXT';
READUNCOMMITTED:                       'READUNCOMMITTED';
READWRITE:                             'READWRITE';
READ_COMMITTED_SNAPSHOT:               'READ_COMMITTED_SNAPSHOT';
READ_ONLY:                             'READ_ONLY';
READ_ONLY_ROUTING_LIST:                'READ_ONLY_ROUTING_LIST';
READ_WRITE:                            'READ_WRITE';
READ_WRITE_FILEGROUPS:                 'READ_WRITE_FILEGROUPS';
REBUILD:                               'REBUILD';
RECEIVE:                               'RECEIVE';
RECOMPILE:                             'RECOMPILE';
RECONFIGURE:                           'RECONFIGURE';
RECOVERY:                              'RECOVERY';
RECURSIVE_TRIGGERS:                    'RECURSIVE_TRIGGERS';
REFERENCES:                            'REFERENCES';
REGENERATE:                            'REGENERATE';
RELATED_CONVERSATION:                  'RELATED_CONVERSATION';
RELATED_CONVERSATION_GROUP:            'RELATED_CONVERSATION_GROUP';
RELATIVE:                              'RELATIVE';
REMOTE:                                'REMOTE';
REMOTE_PROC_TRANSACTIONS:              'REMOTE_PROC_TRANSACTIONS';
REMOTE_SERVICE_NAME:                   'REMOTE_SERVICE_NAME';
REMOVE:                                'REMOVE';
REORGANIZE:                            'REORGANIZE';
REPAIR_ALLOW_DATA_LOSS:                'REPAIR_ALLOW_DATA_LOSS';
REPAIR_FAST:                           'REPAIR_FAST';
REPAIR_REBUILD:                        'REPAIR_REBUILD';
REPEATABLE:                            'REPEATABLE';
REPEATABLEREAD:                        'REPEATABLEREAD';
REPLACE:                               'REPLACE';
REPLICA:                               'REPLICA';
REPLICATE:                             'REPLICATE';
REPLICATION:                           'REPLICATION';
REQUEST_MAX_CPU_TIME_SEC:              'REQUEST_MAX_CPU_TIME_SEC';
REQUEST_MAX_MEMORY_GRANT_PERCENT:      'REQUEST_MAX_MEMORY_GRANT_PERCENT';
REQUEST_MEMORY_GRANT_TIMEOUT_SEC:      'REQUEST_MEMORY_GRANT_TIMEOUT_SEC';
REQUIRED:                              'REQUIRED';
REQUIRED_SYNCHRONIZED_SECONDARIES_TO_COMMIT: 'REQUIRED_SYNCHRONIZED_SECONDARIES_TO_COMMIT';
RESAMPLE:                              'RESAMPLE';
RESERVE_DISK_SPACE:                    'RESERVE_DISK_SPACE';
RESET:                                 'RESET';
RESOURCE:                              'RESOURCE';
RESOURCES:                             'RESOURCES';
RESOURCE_MANAGER_LOCATION:             'RESOURCE_MANAGER_LOCATION';
RESTART:                               'RESTART';
RESTORE:                               'RESTORE';
RESTRICT:                              'RESTRICT';
RESTRICTED_USER:                       'RESTRICTED_USER';
RESUMABLE:                             'RESUMABLE';
RESUME:                                'RESUME';
RETAINDAYS:                            'RETAINDAYS';
RETENTION:                             'RETENTION';
RETURN:                                'RETURN';
RETURNS:                               'RETURNS';
REVERSE:                               'REVERSE';
REVERT:                                'REVERT';
REVOKE:                                'REVOKE';
REWIND:                                'REWIND';
RIGHT:                                 'RIGHT';
ROBUST:                                'ROBUST';
ROLE:                                  'ROLE';
ROLLBACK:                              'ROLLBACK';
ROOT:                                  'ROOT';
ROUND_ROBIN:                           'ROUND_ROBIN';
ROUTE:                                 'ROUTE';
ROW:                                   'ROW';
ROWCOUNT:                              'ROWCOUNT';
ROWCOUNT_BIG:                          'ROWCOUNT_BIG';
ROWGUID:                               'ROWGUID';
ROWGUIDCOL:                            'ROWGUIDCOL';
ROWLOCK:                               'ROWLOCK';
ROWS:                                  'ROWS';
ROW_NUMBER:                            'ROW_NUMBER';
RSA_1024:                              'RSA_1024';
RSA_2048:                              'RSA_2048';
RSA_3072:                              'RSA_3072';
RSA_4096:                              'RSA_4096';
RSA_512:                               'RSA_512';
RTRIM:                                 'RTRIM';
RULE:                                  'RULE';
SAFE:                                  'SAFE';
SAFETY:                                'SAFETY';
SAMPLE:                                'SAMPLE';
SAVE:                                  'SAVE';
SCHEDULER:                             'SCHEDULER';
SCHEMA:                                'SCHEMA';
SCHEMABINDING:                         'SCHEMABINDING';
SCHEMA_ID:                             'SCHEMA_ID';
SCHEMA_NAME:                           'SCHEMA_NAME';
SCHEME:                                'SCHEME';
SCOPED:                                'SCOPED';
SCOPE_IDENTITY:                        'SCOPE_IDENTITY';
SCRIPT:                                'SCRIPT';
SCROLL:                                'SCROLL';
SCROLL_LOCKS:                          'SCROLL_LOCKS';
SEARCH:                                'SEARCH';
SECONDARY:                             'SECONDARY';
SECONDARY_ONLY:                        'SECONDARY_ONLY';
SECONDARY_ROLE:                        'SECONDARY_ROLE';
SECONDS:                               'SECONDS';
SECRET:                                'SECRET';
SECURABLES:                            'SECURABLES';
SECURITY:                              'SECURITY';
SECURITYAUDIT:                         'SECURITYAUDIT';
SECURITY_LOG:                          'SECURITY_LOG';
SEEDING_MODE:                          'SEEDING_MODE';
SELECT:                                'SELECT';
SELF:                                  'SELF';
SEMANTICKEYPHRASETABLE:                'SEMANTICKEYPHRASETABLE';
SEMANTICSIMILARITYDETAILSTABLE:        'SEMANTICSIMILARITYDETAILSTABLE';
SEMANTICSIMILARITYTABLE:               'SEMANTICSIMILARITYTABLE';
SEMI_SENSITIVE:                        'SEMI_SENSITIVE';
SEND:                                  'SEND';
SENT:                                  'SENT';
SEQUENCE:                              'SEQUENCE';
SEQUENCE_NUMBER:                       'SEQUENCE_NUMBER';
SERIALIZABLE:                          'SERIALIZABLE';
SERVER:                                'SERVER';
SERVERPROPERTY:                        'SERVERPROPERTY';
SERVICE:                               'SERVICE';
SERVICEBROKER:                         'SERVICEBROKER';
SERVICE_BROKER:                        'SERVICE_BROKER';
SERVICE_NAME:                          'SERVICE_NAME';
SESSION:                               'SESSION';
SESSIONPROPERTY:                       'SESSIONPROPERTY';
SESSION_CONTEXT:                       'SESSION_CONTEXT';
SESSION_TIMEOUT:                       'SESSION_TIMEOUT';
SESSION_USER:                          'SESSION_USER';
SET:                                   'SET';
SETERROR:                              'SETERROR';
SETS:                                  'SETS';
SETTINGS:                              'SETTINGS';
SETUSER:                               'SETUSER';
SHARE:                                 'SHARE';
SHARED:                                'SHARED';
SHOWCONTIG:                            'SHOWCONTIG';
SHOWPLAN:                              'SHOWPLAN';
SHOWPLAN_ALL:                          'SHOWPLAN_ALL';
SHOWPLAN_TEXT:                         'SHOWPLAN_TEXT';
SHOWPLAN_XML:                          'SHOWPLAN_XML';
SHRINKLOG:                             'SHRINKLOG';
SHUTDOWN:                              'SHUTDOWN';
SID:                                   'SID';
SIGNATURE:                             'SIGNATURE';
SIMPLE:                                'SIMPLE';
SINGLE_USER:                           'SINGLE_USER';
SIZE:                                  'SIZE';
SKIP_KEYWORD:                          'SKIP';
SMALLINT:                              'SMALLINT';
SNAPSHOT:                              'SNAPSHOT';
SOFTNUMA:                              'SOFTNUMA';
SOME:                                  'SOME';
SORT_IN_TEMPDB:                        'SORT_IN_TEMPDB';
SOUNDEX:                               'SOUNDEX';
SOURCE:                                'SOURCE';
SPACE_KEYWORD:                         'SPACE';
SPARSE:                                'SPARSE';
SPATIAL_WINDOW_MAX_CELLS:              'SPATIAL_WINDOW_MAX_CELLS';
SPECIFICATION:                         'SPECIFICATION';
SPLIT:                                 'SPLIT';
SQL:                                   'SQL';
SQLDUMPERFLAGS:                        'SQLDUMPERFLAGS';
SQLDUMPERPATH:                         'SQLDUMPERPATH';
SQLDUMPERTIMEOUT:                      'SQLDUMPERTIMEOUT';
SQL_VARIANT_PROPERTY:                  'SQL_VARIANT_PROPERTY';
STANDBY:                               'STANDBY';
START:                                 'START';
STARTED:                               'STARTED';
STARTUP_STATE:                         'STARTUP_STATE';
START_DATE:                            'START_DATE';
STATE:                                 'STATE';
STATIC:                                'STATIC';
STATISTICS:                            'STATISTICS';
STATISTICS_INCREMENTAL:                'STATISTICS_INCREMENTAL';
STATISTICS_NORECOMPUTE:                'STATISTICS_NORECOMPUTE';
STATS:                                 'STATS';
STATS_DATE:                            'STATS_DATE';
STATS_STREAM:                          'STATS_STREAM';
STATUS:                                'STATUS';
STATUSONLY:                            'STATUSONLY';
STDEV:                                 'STDEV';
STDEVP:                                'STDEVP';
STOP:                                  'STOP';
STOPLIST:                              'STOPLIST';
STOPPED:                               'STOPPED';
STOP_ON_ERROR:                         'STOP_ON_ERROR';
STR:                                   'STR';
STRING_AGG:                            'STRING_AGG';
STRING_ESCAPE:                         'STRING_ESCAPE';
STUFF:                                 'STUFF';
SUBJECT:                               'SUBJECT';
SUBSCRIBE:                             'SUBSCRIBE';
SUBSCRIPTION:                          'SUBSCRIPTION';
SUBSTRING:                             'SUBSTRING';
SUM:                                   'SUM';
SUPPORTED:                             'SUPPORTED';
SUSER_ID:                              'SUSER_ID';
SUSER_NAME:                            'SUSER_NAME';
SUSER_SID:                             'SUSER_SID';
SUSER_SNAME:                           'SUSER_SNAME';
SUSPEND:                               'SUSPEND';
SWITCH:                                'SWITCH';
SYMMETRIC:                             'SYMMETRIC';
SYNCHRONOUS_COMMIT:                    'SYNCHRONOUS_COMMIT';
SYNONYM:                               'SYNONYM';
SYSTEM:                                'SYSTEM';
SYSTEM_USER:                           'SYSTEM_USER';
TABLE:                                 'TABLE';
TABLERESULTS:                          'TABLERESULTS';
TABLESAMPLE:                           'TABLESAMPLE';
TABLOCK:                               'TABLOCK';
TABLOCKX:                              'TABLOCKX';
TAKE:                                  'TAKE';
TAPE:                                  'TAPE';
TARGET:                                'TARGET';
TARGET_RECOVERY_TIME:                  'TARGET_RECOVERY_TIME';
TB:                                    'TB';
TCP:                                   'TCP';
TEXTIMAGE_ON:                          'TEXTIMAGE_ON';
TEXTSIZE:                              'TEXTSIZE';
THEN:                                  'THEN';
THROW:                                 'THROW';
TIES:                                  'TIES';
TIME:                                  'TIME';
TIMEOUT:                               'TIMEOUT';
TIMER:                                 'TIMER';
TINYINT:                               'TINYINT';
TO:                                    'TO';
TOP:                                   'TOP';
TORN_PAGE_DETECTION:                   'TORN_PAGE_DETECTION';
TOSTRING:                              'TOSTRING';
TRACE:                                 'TRACE';
TRACKING:                              'TRACKING';
TRACK_CAUSALITY:                       'TRACK_CAUSALITY';
TRAN:                                  'TRAN';
TRANSACTION:                           'TRANSACTION';
TRANSACTION_ID:                        'TRANSACTION_ID';
TRANSFER:                              'TRANSFER';
TRANSFORM_NOISE_WORDS:                 'TRANSFORM_NOISE_WORDS';
TRANSLATE:                             'TRANSLATE';
TRIGGER:                               'TRIGGER';
TRIM:                                  'TRIM';
TRIPLE_DES:                            'TRIPLE_DES';
TRIPLE_DES_3KEY:                       'TRIPLE_DES_3KEY';
TRUNCATE:                              'TRUNCATE';
TRUSTWORTHY:                           'TRUSTWORTHY';
TRY:                                   'TRY';
TRY_CAST:                              'TRY_CAST';
TSEQUAL:                               'TSEQUAL';
TSQL:                                  'TSQL';
TWO_DIGIT_YEAR_CUTOFF:                 'TWO_DIGIT_YEAR_CUTOFF';
TYPE:                                  'TYPE';
TYPEPROPERTY:                          'TYPEPROPERTY';
TYPE_ID:                               'TYPE_ID';
TYPE_NAME:                             'TYPE_NAME';
TYPE_WARNING:                          'TYPE_WARNING';
UNBOUNDED:                             'UNBOUNDED';
UNCHECKED:                             'UNCHECKED';
UNCOMMITTED:                           'UNCOMMITTED';
UNICODE:                               'UNICODE';
UNION:                                 'UNION';
UNIQUE:                                'UNIQUE';
UNKNOWN:                               'UNKNOWN';
UNLIMITED:                             'UNLIMITED';
UNLOCK:                                'UNLOCK';
UNMASK:                                'UNMASK';
UNPIVOT:                               'UNPIVOT';
UNSAFE:                                'UNSAFE';
UOW:                                   'UOW';
UPDATE:                                'UPDATE';
UPDATETEXT:                            'UPDATETEXT';
UPDLOCK:                               'UPDLOCK';
UPPER:                                 'UPPER';
URL:                                   'URL';
USE:                                   'USE';
USED:                                  'USED';
USER:                                  'USER';
USER_ID:                               'USER_ID';
USER_NAME:                             'USER_NAME';
USING:                                 'USING';
VALIDATION:                            'VALIDATION';
VALID_XML:                             'VALID_XML';
VALUE:                                 'VALUE';
VALUES:                                'VALUES';
VALUE_SQUARE_BRACKET:                  '[VALUE]';
VAR:                                   'VAR';
VARBINARY_KEYWORD:                     'VARBINARY';
VARP:                                  'VARP';
VARYING:                               'VARYING';
VERBOSELOGGING:                        'VERBOSELOGGING';
VERIFY_CLONEDB:                        'VERIFY_CLONEDB';
VERSION:                               'VERSION';
VIEW:                                  'VIEW';
VIEWS:                                 'VIEWS';
VIEW_METADATA:                         'VIEW_METADATA';
VISIBILITY:                            'VISIBILITY';
WAIT:                                  'WAIT';
WAITFOR:                               'WAITFOR';
WAIT_AT_LOW_PRIORITY:                  'WAIT_AT_LOW_PRIORITY';
WELL_FORMED_XML:                       'WELL_FORMED_XML';
WHEN:                                  'WHEN';
WHERE:                                 'WHERE';
WHILE:                                 'WHILE';
WINDOWS:                               'WINDOWS';
WITH:                                  'WITH';
WITHIN:                                'WITHIN';
WITHOUT:                               'WITHOUT';
WITHOUT_ARRAY_WRAPPER:                 'WITHOUT_ARRAY_WRAPPER';
WITNESS:                               'WITNESS';
WORK:                                  'WORK';
WORKLOAD:                              'WORKLOAD';
WRITETEXT:                             'WRITETEXT';
XACT_ABORT:                            'XACT_ABORT';
XACT_STATE:                            'XACT_STATE';
XLOCK:                                 'XLOCK';
XML:                                   'XML';
XMLDATA:                               'XMLDATA';
XMLNAMESPACES:                         'XMLNAMESPACES';
XMLSCHEMA:                             'XMLSCHEMA';
XML_COMPRESSION:                       'XML_COMPRESSION';
XSINIL:                                'XSINIL';
ZONE:                                  'ZONE';

ABS:                                   'ABS';
ACOS:                                  'ACOS';
ASIN:                                  'ASIN';
ATAN:                                  'ATAN';
ATN2:                                  'ATN2';
CEILING:                               'CEILING';
COS:                                   'COS';
COT:                                   'COT';
DEGREES:                               'DEGREES';
EXP:                                   'EXP';
FLOOR:                                 'FLOOR';
LOG10:                                 'LOG10';
PI:                                    'PI';
POWER:                                 'POWER';
RADIANS:                               'RADIANS';
RAND:                                  'RAND';
ROUND:                                 'ROUND';
SIGN:                                  'SIGN';
SIN:                                   'SIN';
SQRT:                                  'SQRT';
SQUARE:                                'SQUARE';
TAN:                                   'TAN';

CURRENT_TIMEZONE:                      'CURRENT_TIMEZONE';
CURRENT_TIMEZONE_ID:                   'CURRENT_TIMEZONE_ID';
DATE_BUCKET:                           'DATE_BUCKET';
DATEDIFF_BIG:                          'DATEDIFF_BIG';
DATEFROMPARTS:                         'DATEFROMPARTS';
DATETIME2FROMPARTS:                    'DATETIME2FROMPARTS';
DATETIMEFROMPARTS:                     'DATETIMEFROMPARTS';
DATETIMEOFFSETFROMPARTS:               'DATETIMEOFFSETFROMPARTS';
DATETRUNC:                             'DATETRUNC';
DAY:                                   'DAY';
EOMONTH:                               'EOMONTH';
ISDATE:                                'ISDATE';
MONTH:                                 'MONTH';
SMALLDATETIMEFROMPARTS:                'SMALLDATETIMEFROMPARTS';
SWITCHOFFSET:                          'SWITCHOFFSET';
SYSDATETIME:                           'SYSDATETIME';
SYSDATETIMEOFFSET:                     'SYSDATETIMEOFFSET';
SYSUTCDATETIME:                        'SYSUTCDATETIME';
TIMEFROMPARTS:                         'TIMEFROMPARTS';
TODATETIMEOFFSET:                      'TODATETIMEOFFSET';
YEAR:                                  'YEAR';

QUARTER:                               'QUARTER';
DAYOFYEAR:                             'DAYOFYEAR';
WEEK:                                  'WEEK';
HOUR:                                  'HOUR';
MINUTE:                                'MINUTE';
SECOND:                                'SECOND';
MILLISECOND:                           'MILLISECOND';
MICROSECOND:                           'MICROSECOND';
NANOSECOND:                            'NANOSECOND';
TZOFFSET:                              'TZOFFSET';
ISO_WEEK:                              'ISO_WEEK';
WEEKDAY:                               'WEEKDAY';

YEAR_ABBR:                             'yy' | 'yyyy';
QUARTER_ABBR:                          'qq' | 'q';
MONTH_ABBR:                            'mm' | 'm';
DAYOFYEAR_ABBR:                        'dy' | 'y';
DAY_ABBR:                              'dd' | 'd';
WEEK_ABBR:                             'wk' | 'ww';
HOUR_ABBR:                             'hh';
MINUTE_ABBR:                           'mi' | 'n';
SECOND_ABBR:                           'ss' | 's';
MILLISECOND_ABBR:                      'ms';
MICROSECOND_ABBR:                      'mcs';
NANOSECOND_ABBR:                       'ns';
TZOFFSET_ABBR:                         'tz';
ISO_WEEK_ABBR:                         'isowk' | 'isoww';
WEEKDAY_ABBR:                          'dw';

SP_EXECUTESQL:                         'SP_EXECUTESQL';

//Build-ins:
VARCHAR:                               'VARCHAR';
NVARCHAR:                              'NVARCHAR';

//Combinations that cannot be used as IDs
DISK_DRIVE:                            [A-Z][:];
DOLLAR_ACTION:                         '$ACTION';

// Functions starting with double at signs
// https://learn.microsoft.com/en-us/sql/t-sql/language-elements/variables-transact-sql?view=sql-server-ver16
CURSOR_ROWS:                           '@@CURSOR_ROWS';
FETCH_STATUS:                          '@@FETCH_STATUS';

IPV4_ADDR:                             DEC_DIGIT+ '.' DEC_DIGIT+ '.' DEC_DIGIT+ '.' DEC_DIGIT+;

SPACE:              [ \t\r\n]+    -> skip;
// https://docs.microsoft.com/en-us/sql/t-sql/language-elements/slash-star-comment-transact-sql
COMMENT:            '/*' (COMMENT | .)*? '*/' -> channel(HIDDEN);
LINE_COMMENT:       '--' ~[\r\n]* -> channel(HIDDEN);

// TODO: ID can be not only Latin.
DOUBLE_QUOTE_ID:    '"' ~'"'+ '"';
DOUBLE_QUOTE_BLANK: '""';
SINGLE_QUOTE:       '\'';
SQUARE_BRACKET_ID:  '[' (~']' | ']' ']')* ']';
LOCAL_ID:           '@' ([A-Z_$@#0-9] | FullWidthLetter)*;
TEMP_ID:            '#' ([A-Z_$@#0-9] | FullWidthLetter)*;
DECIMAL:             DEC_DIGIT+;
ID:                  ( [A-Z_#] | FullWidthLetter) ( [A-Z_#$@0-9] | FullWidthLetter )*;
STRING options { caseInsensitive=false; } : 'N'? '\'' (~'\'' | '\'\'')* '\'';
BINARY:              '0' 'X' HEX_DIGIT*;
FLOAT:               DEC_DOT_DEC;
REAL:                (DECIMAL | DEC_DOT_DEC) ('E' [+-]? DEC_DIGIT+);

EQUAL:               '=';

GREATER:             '>';
LESS:                '<';
EXCLAMATION:         '!';

PLUS_ASSIGN:         '+=';
MINUS_ASSIGN:        '-=';
MULT_ASSIGN:         '*=';
DIV_ASSIGN:          '/=';
MOD_ASSIGN:          '%=';
AND_ASSIGN:          '&=';
XOR_ASSIGN:          '^=';
OR_ASSIGN:           '|=';

DOUBLE_BAR:          '||';
DOT:                 '.';
UNDERLINE:           '_';
AT:                  '@';
SHARP:               '#';
DOLLAR:              '$';
LR_BRACKET:          '(';
RR_BRACKET:          ')';
COMMA:               ',';
SEMI:                ';';
COLON:               ':';
DOUBLE_COLON:        '::';
STAR:                '*';
DIVIDE:              '/';
MODULE:              '%';
PLUS:                '+';
MINUS:               '-';
BIT_NOT:             '~';
BIT_OR:              '|';
BIT_AND:             '&';
BIT_XOR:             '^';

PLACEHOLDER:         '?';

fragment LETTER:       [A-Z_];
fragment DEC_DOT_DEC:  (DEC_DIGIT+ '.' DEC_DIGIT+ |  DEC_DIGIT+ '.' | '.' DEC_DIGIT+);
fragment HEX_DIGIT:    [0-9A-F];
fragment DEC_DIGIT:    [0-9];


fragment FullWidthLetter options { caseInsensitive=false; }
    : '\u00c0'..'\u00d6'
    | '\u00d8'..'\u00f6'
    | '\u00f8'..'\u00ff'
    | '\u0100'..'\u1fff'
    | '\u2c00'..'\u2fff'
    | '\u3040'..'\u318f'
    | '\u3300'..'\u337f'
    | '\u3400'..'\u3fff'
    | '\u4e00'..'\u9fff'
    | '\ua000'..'\ud7ff'
    | '\uf900'..'\ufaff'
    | '\uff00'..'\ufff0'
    // | '\u10000'..'\u1F9FF'  //not support four bytes chars
    // | '\u20000'..'\u2FA1F'
    ;
