# coding: utf-8

"""
    Akeyless API

    The purpose of this application is to provide access to Akeyless API.  # noqa: E501

    The version of the OpenAPI document: 2.0
    Contact: support@akeyless.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from akeyless.configuration import Configuration


class KMIPConfigPart(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'clients': 'dict(str, KMIPClient)',
        'key_enc': 'list[int]',
        'server': 'KMIPServer',
        'server_enc': 'list[int]'
    }

    attribute_map = {
        'clients': 'clients',
        'key_enc': 'key_enc',
        'server': 'server',
        'server_enc': 'server_enc'
    }

    def __init__(self, clients=None, key_enc=None, server=None, server_enc=None, local_vars_configuration=None):  # noqa: E501
        """KMIPConfigPart - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._clients = None
        self._key_enc = None
        self._server = None
        self._server_enc = None
        self.discriminator = None

        if clients is not None:
            self.clients = clients
        if key_enc is not None:
            self.key_enc = key_enc
        if server is not None:
            self.server = server
        if server_enc is not None:
            self.server_enc = server_enc

    @property
    def clients(self):
        """Gets the clients of this KMIPConfigPart.  # noqa: E501


        :return: The clients of this KMIPConfigPart.  # noqa: E501
        :rtype: dict(str, KMIPClient)
        """
        return self._clients

    @clients.setter
    def clients(self, clients):
        """Sets the clients of this KMIPConfigPart.


        :param clients: The clients of this KMIPConfigPart.  # noqa: E501
        :type: dict(str, KMIPClient)
        """

        self._clients = clients

    @property
    def key_enc(self):
        """Gets the key_enc of this KMIPConfigPart.  # noqa: E501

        Saves the private key of the cert issuer in encypted form  # noqa: E501

        :return: The key_enc of this KMIPConfigPart.  # noqa: E501
        :rtype: list[int]
        """
        return self._key_enc

    @key_enc.setter
    def key_enc(self, key_enc):
        """Sets the key_enc of this KMIPConfigPart.

        Saves the private key of the cert issuer in encypted form  # noqa: E501

        :param key_enc: The key_enc of this KMIPConfigPart.  # noqa: E501
        :type: list[int]
        """

        self._key_enc = key_enc

    @property
    def server(self):
        """Gets the server of this KMIPConfigPart.  # noqa: E501


        :return: The server of this KMIPConfigPart.  # noqa: E501
        :rtype: KMIPServer
        """
        return self._server

    @server.setter
    def server(self, server):
        """Sets the server of this KMIPConfigPart.


        :param server: The server of this KMIPConfigPart.  # noqa: E501
        :type: KMIPServer
        """

        self._server = server

    @property
    def server_enc(self):
        """Gets the server_enc of this KMIPConfigPart.  # noqa: E501

        Saved for backward compatibility TODO: remove this after all clients upgrade  # noqa: E501

        :return: The server_enc of this KMIPConfigPart.  # noqa: E501
        :rtype: list[int]
        """
        return self._server_enc

    @server_enc.setter
    def server_enc(self, server_enc):
        """Sets the server_enc of this KMIPConfigPart.

        Saved for backward compatibility TODO: remove this after all clients upgrade  # noqa: E501

        :param server_enc: The server_enc of this KMIPConfigPart.  # noqa: E501
        :type: list[int]
        """

        self._server_enc = server_enc

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, KMIPConfigPart):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, KMIPConfigPart):
            return True

        return self.to_dict() != other.to_dict()
