"""
Vesting Schedule Relative Trigger Object

Describes a vesting condition satisfied when a period of time, relative to
another vesting condition, has elapsed.

Copyright © Shoobx, 2023
Schema is Copyright © 2023 Open Cap Table Coalition (https://opencaptablecoalition.com) /
Original File: https://github.com/Open-Cap-Table-Coalition/Open-Cap-Format-
OCF/tree/main/schema/types/vesting/VestingScheduleRelativeTrigger.schema.json

Autogenerated, do not edit.
"""

from pydantic import Field
from pyocf.primitives.types.vesting.vestingconditiontrigger import (
    VestingConditionTrigger,
)
from pyocf.types.vesting.vestingperiodindays import VestingPeriodInDays
from pyocf.types.vesting.vestingperiodinmonths import VestingPeriodInMonths
from typing import Annotated
from typing import Literal
from typing import Union


class VestingScheduleRelativeTrigger(VestingConditionTrigger):
    """Vesting Schedule Relative Trigger"""

    type: Literal["VESTING_SCHEDULE_RELATIVE"] = "VESTING_SCHEDULE_RELATIVE"
    # The span of time that must have elapsed since the condition
    # `relative_to_condition_id` occurred for this condition to trigger. For weeks or
    # "ideal" years (365 days), use `VestingPeriodInDays`. For calendar years use
    # `VestingPeriodInMonths`.
    period: Annotated[
        Union[VestingPeriodInDays, VestingPeriodInMonths], Field(discriminator="type")
    ]
    # Reference to the vesting condition ID to which the `period` is relative
    relative_to_condition_id: str
