"""
Vesting Period in Months Object

Describes a period of time expressed in months (e.g. 3 months) for use in
Vesting Terms.

Copyright © Shoobx, 2023
Schema is Copyright © 2023 Open Cap Table Coalition (https://opencaptablecoalition.com) /
Original File: https://github.com/Open-Cap-Table-Coalition/Open-Cap-Format-
OCF/tree/main/schema/types/vesting/VestingPeriodInMonths.schema.json

Autogenerated, do not edit.
"""

from pyocf.enums.vestingdayofmonth import VestingDayOfMonth
from pyocf.primitives.types.vesting.vestingperiod import VestingPeriod
from typing import Literal


class VestingPeriodInMonths(VestingPeriod):
    """Vesting Period in Months"""

    # The quantity of `type` units of time; e.g. for 3 months, this would be `3`; for
    # 30 days, this would be `30`
    length: int
    type: Literal["MONTHS"] = "MONTHS"
    # The number of times this vesting period triggers. If vesting occurs monthly for
    # 36 months, for example, this would be `36`
    occurrences: int
    # The calendar day of a month to award vesting.
    day_of_month: VestingDayOfMonth
