"""
Vesting Period in Days Object

Describes a period of time expressed in days (e.g. 365 days) for use in Vesting
Terms

Copyright © Shoobx, 2023
Schema is Copyright © 2023 Open Cap Table Coalition (https://opencaptablecoalition.com) /
Original File: https://github.com/Open-Cap-Table-Coalition/Open-Cap-Format-
OCF/tree/main/schema/types/vesting/VestingPeriodInDays.schema.json

Autogenerated, do not edit.
"""

from pyocf.primitives.types.vesting.vestingperiod import VestingPeriod
from typing import Literal


class VestingPeriodInDays(VestingPeriod):
    """Vesting Period in Days"""

    # The quantity of `type` units of time; e.g. for 3 months, this would be `3`; for
    # 30 days, this would be `30`
    length: int
    type: Literal["DAYS"] = "DAYS"
    # The number of times this vesting period triggers. If vesting occurs monthly for
    # 36 months, for example, this would be `36`
    occurrences: int
