"""
Tax Identifier Object

Type representation of a government identifier for tax purposes (e.g. EIN) and
corresponding country code (ISO-3166)

Copyright © Shoobx, 2023
Schema is Copyright © 2023 Open Cap Table Coalition (https://opencaptablecoalition.com) /
Original File: https://github.com/Open-Cap-Table-Coalition/Open-Cap-Format-
OCF/tree/main/schema/types/TaxID.schema.json

Autogenerated, do not edit.
"""

from pydantic import BaseModel
from pyocf.types.countrycode import CountryCode


class TaxID(BaseModel):
    """Tax Identifier"""

    # Tax identifier as string
    tax_id: str
    # Issuing country code (ISO 3166-1 alpha-2) for the tax identifier
    country: CountryCode
