"""
Stock Parent Object

Type representation of the parent security of a given stock issuance (e.g. if a
stock issuance came from a plan, such as an RSA, or if a stock came from a
previous stock entry)

Copyright © Shoobx, 2023
Schema is Copyright © 2023 Open Cap Table Coalition (https://opencaptablecoalition.com) /
Original File: https://github.com/Open-Cap-Table-Coalition/Open-Cap-Format-
OCF/tree/main/schema/types/StockParent.schema.json

Autogenerated, do not edit.
"""

from pydantic import BaseModel
from pyocf.enums.parentsecuritytype import ParentSecurityType


class StockParent(BaseModel):
    """Stock Parent"""

    # Parent object type for this stock issuance (e.g. a stock plan or warrant)
    parent_object_type: ParentSecurityType
    # Parent object's ID must be a valid ID pointing to an object of the type
    # specified in parent_object_type
    parent_object_id: str
