"""
Share Number Range Object

Type representation of a range of share numbers associated with an event (such
as the share numbers associated with an issuance) - for use where shares are not
fungible and need unique identifiers *per share*

Copyright © Shoobx, 2023
Schema is Copyright © 2023 Open Cap Table Coalition (https://opencaptablecoalition.com) /
Original File: https://github.com/Open-Cap-Table-Coalition/Open-Cap-Format-
OCF/tree/main/schema/types/ShareNumberRange.schema.json

Autogenerated, do not edit.
"""

from pydantic import BaseModel
from pyocf.types.numeric import Numeric


class ShareNumberRange(BaseModel):
    """Share Number Range"""

    # The starting share number of a range of shares impacted by a particular event
    # (**INCLUSIVE** and assuming **share counts start at 1**)
    starting_share_number: Numeric
    # The ending share number of a range of shares impacted by a particular event
    # (**INCLUSIVE**)
    ending_share_number: Numeric
