"""
Ratio Object

Type representation of a ratio as two parts of a quotient, i.e. numerator and
denominator numeric values

Copyright © Shoobx, 2023
Schema is Copyright © 2023 Open Cap Table Coalition (https://opencaptablecoalition.com) /
Original File: https://github.com/Open-Cap-Table-Coalition/Open-Cap-Format-
OCF/tree/main/schema/types/Ratio.schema.json

Autogenerated, do not edit.
"""

from pydantic import BaseModel
from pyocf.types.numeric import Numeric


class Ratio(BaseModel):
    """Ratio"""

    # Numerator of the ratio, i.e. the ratio of A to B (A:B) can be expressed as a
    # fraction (A/B), where A is the numerator
    numerator: Numeric
    # Denominator of the ratio, i.e. the ratio of A to B (A:B) can be expressed as a
    # fraction (A/B), where B is the denominator
    denominator: Numeric
