"""
Phone Object

Type representation of a phone number

Copyright © Shoobx, 2023
Schema is Copyright © 2023 Open Cap Table Coalition (https://opencaptablecoalition.com) /
Original File: https://github.com/Open-Cap-Table-Coalition/Open-Cap-Format-
OCF/tree/main/schema/types/Phone.schema.json

Autogenerated, do not edit.
"""

from pydantic import BaseModel
from pydantic import constr
from pyocf.enums.phonetype import PhoneType


class Phone(BaseModel):
    """Phone"""

    # Type of phone number (e.g. mobile, home or business)
    phone_type: PhoneType
    # A valid phone number string in ITU E.123 international notation (e.g. +123 123
    # 456 7890)
    phone_number: constr(regex=r"^\+\d{1,3}\s\d{2,3}\s\d{2,3}\s\d{4}$")
