"""
Interest Rate Object

Type representation of an interest rate, including accrual start and end dates

Copyright © Shoobx, 2023
Schema is Copyright © 2023 Open Cap Table Coalition (https://opencaptablecoalition.com) /
Original File: https://github.com/Open-Cap-Table-Coalition/Open-Cap-Format-
OCF/tree/main/schema/types/InterestRate.schema.json

Autogenerated, do not edit.
"""

from pydantic import BaseModel
from pyocf.types.date import Date
from pyocf.types.percentage import Percentage
from typing import Optional


class InterestRate(BaseModel):
    """Interest Rate"""

    # Interest rate for the convertible (decimal representation - e.g. 0.125 for
    # 12.5%)
    rate: Percentage
    # Commencement date for interest accruing at the specified rate
    accrual_start_date: Date
    # Optional end date (inclusive) for interest accruing at the specified rate. If
    # none specified, interest will accrue indefinitely or until accrual of next
    # interest rate commences
    accrual_end_date: Optional[Date]
