"""
Elective Conversion In Date Range Trigger Object

Type representation of elective trigger valid on or after start_date and until
or before end_date.

Copyright © Shoobx, 2023
Schema is Copyright © 2023 Open Cap Table Coalition (https://opencaptablecoalition.com) /
Original File: https://github.com/Open-Cap-Table-Coalition/Open-Cap-Format-OCF/t
ree/main/schema/types/conversion_triggers/ElectiveConversionInDateRangeTrigger.s
chema.json

Autogenerated, do not edit.
"""

from pydantic import Field
from pyocf.primitives.types.conversion_triggers.conversiontrigger import (
    ConversionTrigger,
)
from pyocf.types.conversion_rights.convertibleconversionright import (
    ConvertibleConversionRight,
)
from pyocf.types.conversion_rights.stockclassconversionright import (
    StockClassConversionRight,
)
from pyocf.types.conversion_rights.warrantconversionright import WarrantConversionRight
from pyocf.types.date import Date
from typing import Annotated
from typing import Literal
from typing import Optional
from typing import Union


class ElectiveConversionInDateRangeTrigger(ConversionTrigger):
    """Elective Conversion In Date Range Trigger"""

    # Id for this conversion trigger, unique within list of ConversionTriggers in
    # parent convertible issuance's `conversion_triggers` field.
    trigger_id: str
    type: Literal["ELECTIVE_IN_RANGE"] = "ELECTIVE_IN_RANGE"
    # Start date of range (inclusive)
    start_date: Date
    # End date of range (inclusive)
    end_date: Date
    # Human-friendly nickname to describe the conversion right
    nickname: Optional[str]
    # Long-form description of the trigger
    trigger_description: Optional[str]
    # When the conditions of the trigger are met, how does the convertible convert?
    conversion_right: Annotated[
        Union[
            ConvertibleConversionRight,
            WarrantConversionRight,
            StockClassConversionRight,
        ],
        Field(discriminator="type"),
    ]
