"""
Stock Class Conversion Rights Object

Type representation of a conversion right from one Stock Class into another
Stock Class

Copyright © Shoobx, 2023
Schema is Copyright © 2023 Open Cap Table Coalition (https://opencaptablecoalition.com) /
Original File: https://github.com/Open-Cap-Table-Coalition/Open-Cap-Format-OCF/t
ree/main/schema/types/conversion_rights/StockClassConversionRight.schema.json

Autogenerated, do not edit.
"""

from pyocf.primitives.types.conversion_rights.conversionright import ConversionRight
from pyocf.types.conversion_mechanisms.ratioconversionmechanism import (
    RatioConversionMechanism,
)
from typing import Literal
from typing import Optional


class StockClassConversionRight(ConversionRight):
    """Stock Class Conversion Rights"""

    type: Optional[
        Literal["STOCK_CLASS_CONVERSION_RIGHT"]
    ] = "STOCK_CLASS_CONVERSION_RIGHT"
    conversion_mechanism: RatioConversionMechanism
    # Is this stock class potentially convertible into a future, as-yet undetermined
    # stock class (e.g. Founder Preferred)
    converts_to_future_round: Optional[bool]
    # The identifier of the existing, known stock class this stock class can convert
    # into
    converts_to_stock_class_id: Optional[str]
