"""
Convertible Conversion Rights Object

Type representation of a conversion right from a convertible into another non-
plan security

Copyright © Shoobx, 2023
Schema is Copyright © 2023 Open Cap Table Coalition (https://opencaptablecoalition.com) /
Original File: https://github.com/Open-Cap-Table-Coalition/Open-Cap-Format-OCF/t
ree/main/schema/types/conversion_rights/ConvertibleConversionRight.schema.json

Autogenerated, do not edit.
"""

from pydantic import Field
from pyocf.primitives.types.conversion_rights.conversionright import ConversionRight
from pyocf.types.conversion_mechanisms.customconversionmechanism import (
    CustomConversionMechanism,
)
from pyocf.types.conversion_mechanisms.fixedamountconversionmechanism import (
    FixedAmountConversionMechanism,
)
from pyocf.types.conversion_mechanisms.noteconversionmechanism import (
    NoteConversionMechanism,
)
from pyocf.types.conversion_mechanisms.percentcapitalizationconversionmechanism import (
    PercentCapitalizationConversionMechanism,
)
from pyocf.types.conversion_mechanisms.safeconversionmechanism import (
    SAFEConversionMechanism,
)
from typing import Annotated
from typing import Literal
from typing import Optional
from typing import Union


class ConvertibleConversionRight(ConversionRight):
    """Convertible Conversion Rights"""

    type: Optional[
        Literal["CONVERTIBLE_CONVERSION_RIGHT"]
    ] = "CONVERTIBLE_CONVERSION_RIGHT"
    conversion_mechanism: Annotated[
        Union[
            SAFEConversionMechanism,
            NoteConversionMechanism,
            CustomConversionMechanism,
            PercentCapitalizationConversionMechanism,
            FixedAmountConversionMechanism,
        ],
        Field(discriminator="type"),
    ]
    # Is this stock class potentially convertible into a future, as-yet undetermined
    # stock class (e.g. Founder Preferred)
    converts_to_future_round: Optional[bool]
    # The identifier of the existing, known stock class this stock class can convert
    # into
    converts_to_stock_class_id: Optional[str]
