"""
SAFE Object

Sets forth inputs and conversion mechanism of a SAFE (mirrors the flavors and
inputs of the Y Combinator SAFE)

Copyright © Shoobx, 2023
Schema is Copyright © 2023 Open Cap Table Coalition (https://opencaptablecoalition.com) /
Original File: https://github.com/Open-Cap-Table-Coalition/Open-Cap-Format-OCF/t
ree/main/schema/types/conversion_mechanisms/SAFEConversionMechanism.schema.json

Autogenerated, do not edit.
"""

from pyocf.enums.conversiontimingtype import ConversionTimingType
from pyocf.primitives.types.conversion_mechanisms.conversionmechanism import (
    ConversionMechanism,
)
from pyocf.types.monetary import Monetary
from pyocf.types.percentage import Percentage
from pyocf.types.ratio import Ratio
from typing import Literal
from typing import Optional


class SAFEConversionMechanism(ConversionMechanism):
    """SAFE"""

    type: Literal["SAFE_CONVERSION"] = "SAFE_CONVERSION"
    # What is the percentage discount available upon conversion, if applicable?
    # (decimal representation - e.g. 0.125 for 12.5%)
    conversion_discount: Optional[Percentage]
    # What is the valuation cap (if applicable)?
    conversion_valuation_cap: Optional[Monetary]
    # For cash proceeds calculation during a liquidity event.
    exit_multiple: Optional[Ratio]
    # Is this an MFN flavored SAFE?
    conversion_mfn: bool
    # Should the conversion amount be based on pre or post money capitalization
    conversion_timing: ConversionTimingType
    # How is company capitalization defined for purposes of conversion? If possible,
    # include the legal language from the instrument.
    capitalization_definition: Optional[str]
