"""
Ratio Object

Sets forth inputs and conversion mechanism of a ratio conversion (primarily used
to describe conversion from one stock class (e.g. Preferred) into another (e.g.
Common)

Copyright © Shoobx, 2023
Schema is Copyright © 2023 Open Cap Table Coalition (https://opencaptablecoalition.com) /
Original File: https://github.com/Open-Cap-Table-Coalition/Open-Cap-Format-OCF/t
ree/main/schema/types/conversion_mechanisms/RatioConversionMechanism.schema.json

Autogenerated, do not edit.
"""

from pyocf.enums.roundingtype import RoundingType
from pyocf.primitives.types.conversion_mechanisms.conversionmechanism import (
    ConversionMechanism,
)
from pyocf.types.monetary import Monetary
from pyocf.types.ratio import Ratio
from typing import Literal


class RatioConversionMechanism(ConversionMechanism):
    """Ratio"""

    type: Literal["RATIO_CONVERSION"] = "RATIO_CONVERSION"
    # What is the effective conversion price per share of this stock class?
    conversion_price: Monetary
    # One share of this stock class converts into this many target stock class shares
    ratio: Ratio
    # How should fractional shares be rounded?
    rounding_type: RoundingType
