"""
Address Object

Type representation of an address

Copyright © Shoobx, 2023
Schema is Copyright © 2023 Open Cap Table Coalition (https://opencaptablecoalition.com) /
Original File: https://github.com/Open-Cap-Table-Coalition/Open-Cap-Format-
OCF/tree/main/schema/types/Address.schema.json

Autogenerated, do not edit.
"""

from pydantic import BaseModel
from pyocf.enums.addresstype import AddressType
from pyocf.types.countrycode import CountryCode
from pyocf.types.countrysubdivisioncode import CountrySubdivisionCode
from typing import Optional


class Address(BaseModel):
    """Address"""

    # What type of address is this (e.g. legal address, contact address, etc.)
    address_type: AddressType
    # Street address (multi-line string)
    street_suite: Optional[str]
    # City
    city: Optional[str]
    # State, province, or equivalent identifier required for an address in this
    # country
    country_subdivision: Optional[CountrySubdivisionCode]
    # Country code for this address (ISO 3166-1 alpha-2)
    country: CountryCode
    # Address postal code
    postal_code: Optional[str]
