"""
Vesting Period Type Object

Abstract type describing the fields common to all periods of time (e.g. 3
months, 365 days) for use in Vesting Terms

Copyright © Shoobx, 2023
Schema is Copyright © 2023 Open Cap Table Coalition (https://opencaptablecoalition.com) /
Original File: https://github.com/Open-Cap-Table-Coalition/Open-Cap-Format-
OCF/tree/main/schema/primitives/types/vesting/VestingPeriod.schema.json

Autogenerated, do not edit.
"""

from pydantic import BaseModel
from pyocf.enums.periodtype import PeriodType


class VestingPeriod(BaseModel):
    """Vesting Period Type"""

    # The quantity of `type` units of time; e.g. for 3 months, this would be `3`; for
    # 30 days, this would be `30`
    length: int
    # The unit of time for the period, e.g. `MONTHS` or `DAYS`
    type: PeriodType
    # The number of times this vesting period triggers. If vesting occurs monthly for
    # 36 months, for example, this would be `36`
    occurrences: int
