"""
Conversion Trigger Type Object

Abstract type representation of required fields require for conversion rights
types.

Copyright © Shoobx, 2023
Schema is Copyright © 2023 Open Cap Table Coalition (https://opencaptablecoalition.com) /
Original File: https://github.com/Open-Cap-Table-Coalition/Open-Cap-Format-OCF/t
ree/main/schema/primitives/types/conversion_triggers/ConversionTrigger.schema.js
on

Autogenerated, do not edit.
"""

from pydantic import BaseModel
from pyocf.enums.conversiontriggertype import ConversionTriggerType
from pyocf.primitives.types.conversion_rights.conversionright import ConversionRight
from typing import Optional


class ConversionTrigger(BaseModel):
    """Conversion Trigger Type"""

    # When the trigger condition is met, is the conversion automatic, elective or
    # automatic with an elective right not to convert
    type: ConversionTriggerType
    # Id for this conversion trigger, unique within list of ConversionTriggers in
    # parent convertible issuance's `conversion_triggers` field.
    trigger_id: str
    # Human-friendly nickname to describe the conversion right
    nickname: Optional[str]
    # Long-form description of the trigger
    trigger_description: Optional[str]
    # When the conditions of the trigger are met, how does the convertible convert?
    conversion_right: ConversionRight
