"""
Conversion Right Type Object

Abstract type representation of a conversion right from a non-plan security into
another non-plan security

Copyright © Shoobx, 2023
Schema is Copyright © 2023 Open Cap Table Coalition (https://opencaptablecoalition.com) /
Original File: https://github.com/Open-Cap-Table-Coalition/Open-Cap-Format-OCF/t
ree/main/schema/primitives/types/conversion_rights/ConversionRight.schema.json

Autogenerated, do not edit.
"""

from pydantic import BaseModel
from pyocf.enums.conversionrighttype import ConversionRightType
from pyocf.primitives.types.conversion_mechanisms.conversionmechanism import (
    ConversionMechanism,
)
from typing import Optional


class ConversionRight(BaseModel):
    """Conversion Right Type"""

    # What kind of conversion right is this?
    type: Optional[ConversionRightType]
    # What conversion mechanism applies to calculate the number of resulting
    # securities?
    conversion_mechanism: ConversionMechanism
    # Is this stock class potentially convertible into a future, as-yet undetermined
    # stock class (e.g. Founder Preferred)
    converts_to_future_round: Optional[bool]
    # The identifier of the existing, known stock class this stock class can convert
    # into
    converts_to_stock_class_id: Optional[str]
