"""
Security Transaction Object

Abstract transaction object to be extended by all transaction objects that deal
with individual securities

Copyright © Shoobx, 2023
Schema is Copyright © 2023 Open Cap Table Coalition (https://opencaptablecoalition.com) /
Original File: https://github.com/Open-Cap-Table-Coalition/Open-Cap-Format-OCF/t
ree/main/schema/primitives/objects/transactions/SecurityTransaction.schema.json

Autogenerated, do not edit.
"""

from pydantic import BaseModel


class SecurityTransaction(BaseModel):
    """Security Transaction"""

    # Identifier for the security (stock, plan security, warrant, or convertible) by
    # which it can be referenced by other transaction objects. Note that while this
    # identifier is created with an issuance object, it should be different than the
    # issuance object's `id` field which identifies the issuance transaction object
    # itself. All future transactions on the security (e.g. acceptance, transfer,
    # cancel, etc.) must reference this `security_id` to qualify which security the
    # transaction applies to.
    security_id: str
