"""
Security Repurchase Transaction Object

Abstract object describing common properties to a repurchase transaction

Copyright © Shoobx, 2023
Schema is Copyright © 2023 Open Cap Table Coalition (https://opencaptablecoalition.com) /
Original File: https://github.com/Open-Cap-Table-Coalition/Open-Cap-Format-OCF/t
ree/main/schema/primitives/objects/transactions/repurchase/Repurchase.schema.jso
n

Autogenerated, do not edit.
"""

from pydantic import BaseModel
from pyocf.types.monetary import Monetary
from pyocf.types.numeric import Numeric
from typing import Optional


class Repurchase(BaseModel):
    """Security Repurchase Transaction"""

    # Repurchase price per share of the stock
    price: Monetary
    # Number of shares of stock repurchased
    quantity: Numeric
    # Unstructured text description of consideration provided in exchange for security
    # repurchase
    consideration_text: Optional[str]
    # Identifier for the security that holds the remainder balance (for partial
    # repurchases)
    balance_security_id: Optional[str]
