"""
Security Release Transaction Object

Abstract object describing fields common to all release transaction objects

Copyright © Shoobx, 2023
Schema is Copyright © 2023 Open Cap Table Coalition (https://opencaptablecoalition.com) /
Original File: https://github.com/Open-Cap-Table-Coalition/Open-Cap-Format-
OCF/tree/main/schema/primitives/objects/transactions/release/Release.schema.json

Autogenerated, do not edit.
"""

from pydantic import BaseModel
from pyocf.types.date import Date
from pyocf.types.monetary import Monetary
from pyocf.types.numeric import Numeric
from typing import Optional


class Release(BaseModel):
    """Security Release Transaction"""

    # The settlement date for the shares released, typically after the release
    # transaction date
    settlement_date: Date
    # The release price used to determine the value of the security at the time of
    # release
    release_price: Monetary
    # Quantity of shares released
    quantity: Numeric
    # Unstructured text description of consideration provided in exchange for security
    # release
    consideration_text: Optional[str]
    # Identifier of the new security (or securities) issuance resulting from a release
    # transaction
    resulting_security_ids: list[str]
