"""
Security Reissuance Transaction Object

Abstract object describing common properties to a reissuance of a security

Copyright © Shoobx, 2023
Schema is Copyright © 2023 Open Cap Table Coalition (https://opencaptablecoalition.com) /
Original File: https://github.com/Open-Cap-Table-Coalition/Open-Cap-Format-OCF/t
ree/main/schema/primitives/objects/transactions/reissuance/Reissuance.schema.jso
n

Autogenerated, do not edit.
"""

from pydantic import BaseModel
from typing import Optional


class Reissuance(BaseModel):
    """Security Reissuance Transaction"""

    # Identifier of the new security (or securities) issuance resulting from a
    # reissuance
    resulting_security_ids: list[str]
    # When stock is reissued as a result of a stock split, this field contains id of
    # the respective stock class split transaction. It is not set otherwise.
    split_transaction_id: Optional[str]
    # Free-form human-readable reason for stock reissuance
    reason_text: Optional[str]
