"""
Security Issuance Transaction Object

Abstract object describing fields common to all issuance objects

Copyright © Shoobx, 2023
Schema is Copyright © 2023 Open Cap Table Coalition (https://opencaptablecoalition.com) /
Original File: https://github.com/Open-Cap-Table-Coalition/Open-Cap-Format-OCF/t
ree/main/schema/primitives/objects/transactions/issuance/Issuance.schema.json

Autogenerated, do not edit.
"""

from pydantic import BaseModel
from pyocf.types.date import Date
from pyocf.types.securityexemption import SecurityExemption
from typing import Optional


class Issuance(BaseModel):
    """Security Issuance Transaction"""

    # A custom ID for this security (e.g. CN-1.)
    custom_id: str
    # Identifier for the stakeholder that holds legal title to this security
    stakeholder_id: str
    # Date of board approval for the security
    board_approval_date: Optional[Date]
    # Unstructured text description of consideration provided in exchange for security
    # issuance
    consideration_text: Optional[str]
    # List of security law exemptions (and applicable jurisdictions) for this security
    security_law_exemptions: list[SecurityExemption]
