"""
Valuation Object

Object describing a valuation used in the cap table

Copyright © Shoobx, 2023
Schema is Copyright © 2023 Open Cap Table Coalition (https://opencaptablecoalition.com) /
Original File: https://github.com/Open-Cap-Table-Coalition/Open-Cap-Format-
OCF/tree/main/schema/objects/Valuation.schema.json

Autogenerated, do not edit.
"""

from pyocf.enums.valuationtype import ValuationType
from pyocf.primitives.objects.object import Object
from pyocf.types.date import Date
from pyocf.types.monetary import Monetary
from typing import Literal
from typing import Optional


class Valuation(Object):
    """Valuation"""

    object_type: Literal["VALUATION"] = "VALUATION"
    # Entity which provided the valuation
    provider: Optional[str]
    # Date on which board approved the valuation. This is essential for 409A
    # valuations, in particular, which require the Board to approve the valuation.
    board_approval_date: Optional[Date]
    # Valued price per share
    price_per_share: Monetary
    # Date on which this valuation is first valid
    effective_date: Date
    # Identifier of the stock class for this valuation
    stock_class_id: str
    # Seam for supporting different types of valuations in future versions
    valuation_type: ValuationType
    # Identifier for the object
    id: str
    # Unstructured text comments related to and stored for the object
    comments: Optional[list[str]]
