"""
Stock Split Transaction Object

Object describing a split of a stock class

Copyright © Shoobx, 2023
Schema is Copyright © 2023 Open Cap Table Coalition (https://opencaptablecoalition.com) /
Original File: https://github.com/Open-Cap-Table-Coalition/Open-Cap-Format-
OCF/tree/main/schema/objects/transactions/split/StockClassSplit.schema.json

Autogenerated, do not edit.
"""

from pyocf.primitives.objects.object import Object
from pyocf.primitives.objects.transactions.stockclasstransaction import (
    StockClassTransaction,
)
from pyocf.primitives.objects.transactions.transaction import Transaction
from pyocf.types.date import Date
from pyocf.types.ratio import Ratio
from typing import Literal
from typing import Optional


class StockClassSplit(Object, Transaction, StockClassTransaction):
    """Stock Split Transaction"""

    object_type: Literal["TX_STOCK_CLASS_SPLIT"] = "TX_STOCK_CLASS_SPLIT"
    # Identifier for the object
    id: str
    # Unstructured text comments related to and stored for the object
    comments: Optional[list[str]]
    # Date on which the transaction occurred
    date: Date
    # Identifier of the StockClass object, a subject of this transaction
    stock_class_id: str
    # Ratio of new shares to old shares. For 2-for-1 split the numerator of the ratio
    # is 2 and the denominator is 1.
    split_ratio: Ratio
