"""
Plan Security Issuance Transaction Object

Object describing securities issuance transaction from a plan by the issuer and
held by a stakeholder

Copyright © Shoobx, 2023
Schema is Copyright © 2023 Open Cap Table Coalition (https://opencaptablecoalition.com) /
Original File: https://github.com/Open-Cap-Table-Coalition/Open-Cap-Format-OCF/t
ree/main/schema/objects/transactions/issuance/PlanSecurityIssuance.schema.json

Autogenerated, do not edit.
"""

from pydantic import root_validator
from pyocf.enums.compensationtype import CompensationType
from pyocf.enums.optiontype import OptionType
from pyocf.primitives.objects.object import Object
from pyocf.primitives.objects.transactions.issuance.issuance import Issuance
from pyocf.primitives.objects.transactions.securitytransaction import (
    SecurityTransaction,
)
from pyocf.primitives.objects.transactions.transaction import Transaction
from pyocf.types.date import Date
from pyocf.types.monetary import Monetary
from pyocf.types.numeric import Numeric
from pyocf.types.securityexemption import SecurityExemption
from pyocf.types.terminationwindow import TerminationWindow
from typing import Literal
from typing import Optional
from typing import Union


class PlanSecurityIssuance(Object, Transaction, SecurityTransaction, Issuance):
    """Plan Security Issuance Transaction"""

    object_type: Literal["TX_PLAN_SECURITY_ISSUANCE"] = "TX_PLAN_SECURITY_ISSUANCE"
    # Identifier of StockPlan the PlanSecurities were issued from
    stock_plan_id: str
    # If the plan security is compensation, what kind?
    compensation_type: CompensationType
    # If the plan security is an option, what kind?
    option_grant_type: Optional[OptionType]
    # How many shares are subject to this plan security?
    quantity: Numeric
    # What is the exercise price?
    exercise_price: Monetary
    # Identifier of the VestingTerms to which this security is subject.  If not
    # present, security is fully vested on issuance.
    vesting_terms_id: Optional[str]
    # Expiration date of the plan security
    expiration_date: Union[None, Date]
    # Exercise periods applicable to plan security after a termination for a given,
    # enumerated reason
    termination_exercise_windows: list[TerminationWindow]
    # Identifier for the object
    id: str
    # Unstructured text comments related to and stored for the object
    comments: Optional[list[str]]
    # Identifier for the security (stock, plan security, warrant, or convertible) by
    # which it can be referenced by other transaction objects. Note that while this
    # identifier is created with an issuance object, it should be different than the
    # issuance object's `id` field which identifies the issuance transaction object
    # itself. All future transactions on the security (e.g. acceptance, transfer,
    # cancel, etc.) must reference this `security_id` to qualify which security the
    # transaction applies to.
    security_id: str
    # Date on which the transaction occurred
    date: Date
    # A custom ID for this security (e.g. CN-1.)
    custom_id: str
    # Identifier for the stakeholder that holds legal title to this security
    stakeholder_id: str
    # Date of board approval for the security
    board_approval_date: Optional[Date]
    # Unstructured text description of consideration provided in exchange for security
    # issuance
    consideration_text: Optional[str]
    # List of security law exemptions (and applicable jurisdictions) for this security
    security_law_exemptions: list[SecurityExemption]

    @root_validator(pre=True)
    def validator_compensation_type(cls, values):
        if (
            values.get("compensation_type") == "OPTION"
            and values.get("option_grant_type") is None
        ):
            raise ValueError(
                "When compensation_type is 'OPTION' then option_grant_type is required"
            )

        return values
