"""
Convertible Conversion Transaction Object

Object describing a conversion of a convertible security

Copyright © Shoobx, 2023
Schema is Copyright © 2023 Open Cap Table Coalition (https://opencaptablecoalition.com) /
Original File: https://github.com/Open-Cap-Table-Coalition/Open-Cap-Format-OCF/t
ree/main/schema/objects/transactions/conversion/ConvertibleConversion.schema.jso
n

Autogenerated, do not edit.
"""

from pyocf.primitives.objects.object import Object
from pyocf.primitives.objects.transactions.conversion.conversion import Conversion
from pyocf.primitives.objects.transactions.securitytransaction import (
    SecurityTransaction,
)
from pyocf.primitives.objects.transactions.transaction import Transaction
from pyocf.types.capitalizationdefinition import CapitalizationDefinition
from pyocf.types.date import Date
from pyocf.types.numeric import Numeric
from typing import Literal
from typing import Optional


class ConvertibleConversion(Object, Transaction, SecurityTransaction, Conversion):
    """Convertible Conversion Transaction"""

    object_type: Literal["TX_CONVERTIBLE_CONVERSION"] = "TX_CONVERTIBLE_CONVERSION"
    # Reason for the conversion
    reason_text: str
    # Quantity of security units converted
    quantity_converted: Optional[Numeric]
    # Identifier for the convertible that holds the remainder balance (for partial
    # conversions)
    balance_security_id: Optional[str]
    # What is the id of the convertible's conversion trigger that resulted in this
    # conversion
    trigger_id: str
    # If this conversion event and its `quantity_converted` value was based on the
    # company's capitalization, please specify what stock classes, stock plans and
    # securities were aggregated to calculate the capitalization value used in the
    # calculation (e.g. if it was based on "fully diluted" capitalization, please
    # provide details on how this was calculated using the capitalization type
    # datastructure).
    capitalization_definition: Optional[CapitalizationDefinition]
    # Identifier for the object
    id: str
    # Unstructured text comments related to and stored for the object
    comments: Optional[list[str]]
    # Identifier for the security (stock, plan security, warrant, or convertible) by
    # which it can be referenced by other transaction objects. Note that while this
    # identifier is created with an issuance object, it should be different than the
    # issuance object's `id` field which identifies the issuance transaction object
    # itself. All future transactions on the security (e.g. acceptance, transfer,
    # cancel, etc.) must reference this `security_id` to qualify which security the
    # transaction applies to.
    security_id: str
    # Date on which the transaction occurred
    date: Date
    # Identifier for the security (or securities) that resulted from the conversion
    resulting_security_ids: list[str]
