"""
Stock Plan Pool Adjustment Transaction Object

Object describing the change in the size of a Stock Plan pool.

Copyright © Shoobx, 2023
Schema is Copyright © 2023 Open Cap Table Coalition (https://opencaptablecoalition.com) /
Original File: https://github.com/Open-Cap-Table-Coalition/Open-Cap-Format-OCF/t
ree/main/schema/objects/transactions/adjustment/StockPlanPoolAdjustment.schema.j
son

Autogenerated, do not edit.
"""

from pyocf.primitives.objects.object import Object
from pyocf.primitives.objects.transactions.stockplantransaction import (
    StockPlanTransaction,
)
from pyocf.primitives.objects.transactions.transaction import Transaction
from pyocf.types.date import Date
from pyocf.types.numeric import Numeric
from typing import Literal
from typing import Optional


class StockPlanPoolAdjustment(Object, Transaction, StockPlanTransaction):
    """Stock Plan Pool Adjustment Transaction"""

    object_type: Literal[
        "TX_STOCK_PLAN_POOL_ADJUSTMENT"
    ] = "TX_STOCK_PLAN_POOL_ADJUSTMENT"
    # Identifier for the object
    id: str
    # Unstructured text comments related to and stored for the object
    comments: Optional[list[str]]
    # Date on which the transaction occurred
    date: Date
    # Identifier of the Stock Plan object, a subject of this transaction
    stock_plan_id: str
    # Date on which board approved the change to the plan.
    board_approval_date: Date
    # This optional field tracks when the stockholders approved this change to the
    # stock plan. This is intended for use by US companies that want to issue
    # Incentive Stock Options (ISOs), as the issuing StockPlan must receive
    # shareholder approval within a specified time frame in order to issue valid ISOs.
    stockholder_approval_date: Optional[Date]
    # The number of shares reserved in the pool for this stock plan by the Board or
    # equivalent body as of the effective date of this pool adjustment.
    shares_reserved: Numeric
