"""
Stock Class Authorized Shares Adjustment Transaction Object

Object describing an event to change the number of authoried shares of a stock
class.

Copyright © Shoobx, 2023
Schema is Copyright © 2023 Open Cap Table Coalition (https://opencaptablecoalition.com) /
Original File: https://github.com/Open-Cap-Table-Coalition/Open-Cap-Format-OCF/t
ree/main/schema/objects/transactions/adjustment/StockClassAuthorizedSharesAdjust
ment.schema.json

Autogenerated, do not edit.
"""

from pyocf.primitives.objects.object import Object
from pyocf.primitives.objects.transactions.stockclasstransaction import (
    StockClassTransaction,
)
from pyocf.primitives.objects.transactions.transaction import Transaction
from pyocf.types.date import Date
from pyocf.types.numeric import Numeric
from typing import Literal
from typing import Optional


class StockClassAuthorizedSharesAdjustment(Object, Transaction, StockClassTransaction):
    """Stock Class Authorized Shares Adjustment Transaction"""

    object_type: Literal[
        "TX_STOCK_CLASS_AUTHORIZED_SHARES_ADJUSTMENT"
    ] = "TX_STOCK_CLASS_AUTHORIZED_SHARES_ADJUSTMENT"
    # Identifier for the object
    id: str
    # Unstructured text comments related to and stored for the object
    comments: Optional[list[str]]
    # Date on which the transaction occurred
    date: Date
    # Identifier of the StockClass object, a subject of this transaction
    stock_class_id: str
    # The new number of shares authorized for this stock class as of the event of this
    # transaction
    new_shares_authorized: Numeric
    # Date on which the board approved the change to the stock class
    board_approval_date: Optional[Date]
