"""
Warrant Acceptance Transaction Object

Object describing a warrant acceptance transaction

Copyright © Shoobx, 2023
Schema is Copyright © 2023 Open Cap Table Coalition (https://opencaptablecoalition.com) /
Original File: https://github.com/Open-Cap-Table-Coalition/Open-Cap-Format-OCF/t
ree/main/schema/objects/transactions/acceptance/WarrantAcceptance.schema.json

Autogenerated, do not edit.
"""

from pyocf.primitives.objects.object import Object
from pyocf.primitives.objects.transactions.acceptance.acceptance import Acceptance
from pyocf.primitives.objects.transactions.securitytransaction import (
    SecurityTransaction,
)
from pyocf.primitives.objects.transactions.transaction import Transaction
from pyocf.types.date import Date
from typing import Literal
from typing import Optional


class WarrantAcceptance(Object, Transaction, SecurityTransaction, Acceptance):
    """Warrant Acceptance Transaction"""

    object_type: Literal["TX_WARRANT_ACCEPTANCE"] = "TX_WARRANT_ACCEPTANCE"
    # Identifier for the object
    id: str
    # Unstructured text comments related to and stored for the object
    comments: Optional[list[str]]
    # Identifier for the security (stock, plan security, warrant, or convertible) by
    # which it can be referenced by other transaction objects. Note that while this
    # identifier is created with an issuance object, it should be different than the
    # issuance object's `id` field which identifies the issuance transaction object
    # itself. All future transactions on the security (e.g. acceptance, transfer,
    # cancel, etc.) must reference this `security_id` to qualify which security the
    # transaction applies to.
    security_id: str
    # Date on which the transaction occurred
    date: Date
