"""
Stock Plan Object

Object describing a plan which stock options are issued from

Copyright © Shoobx, 2023
Schema is Copyright © 2023 Open Cap Table Coalition (https://opencaptablecoalition.com) /
Original File: https://github.com/Open-Cap-Table-Coalition/Open-Cap-Format-
OCF/tree/main/schema/objects/StockPlan.schema.json

Autogenerated, do not edit.
"""

from pyocf.primitives.objects.object import Object
from pyocf.types.date import Date
from pyocf.types.numeric import Numeric
from typing import Literal
from typing import Optional


class StockPlan(Object):
    """Stock Plan"""

    object_type: Literal["STOCK_PLAN"] = "STOCK_PLAN"
    # Name for the stock plan
    plan_name: str
    # Date on which board approved the plan
    board_approval_date: Optional[Date]
    # This optional field tracks when the stockholders approved this stock plan. This
    # is intended for use by US companies that want to issue Incentive Stock Options
    # (ISOs), as the issuing StockPlan must receive shareholder approval within a
    # specified time frame in order to issue valid ISOs.
    stockholder_approval_date: Optional[Date]
    # The initial number of shares reserved in the pool for this stock plan by the
    # Board or equivalent body.
    initial_shares_reserved: Numeric
    # Identifier of the StockClass object this plan is composed of
    stock_class_id: str
    # Identifier for the object
    id: str
    # Unstructured text comments related to and stored for the object
    comments: Optional[list[str]]
