"""
Stakeholder Object

Object describing a stakeholder

Copyright © Shoobx, 2023
Schema is Copyright © 2023 Open Cap Table Coalition (https://opencaptablecoalition.com) /
Original File: https://github.com/Open-Cap-Table-Coalition/Open-Cap-Format-
OCF/tree/main/schema/objects/Stakeholder.schema.json

Autogenerated, do not edit.
"""

from pyocf.enums.stakeholderrelationshiptype import StakeholderRelationshipType
from pyocf.enums.stakeholdertype import StakeholderType
from pyocf.primitives.objects.object import Object
from pyocf.types.address import Address
from pyocf.types.contactinfo import ContactInfo
from pyocf.types.name import Name
from pyocf.types.taxid import TaxID
from typing import Literal
from typing import Optional


class Stakeholder(Object):
    """Stakeholder"""

    object_type: Literal["STAKEHOLDER"] = "STAKEHOLDER"
    # Name for the stakeholder
    name: Name
    # Distinguish individuals from institutions
    stakeholder_type: StakeholderType
    # This might be any sort of id assigned to the stakeholder by the issuer, such as
    # an internal company ID for an employee stakeholder
    issuer_assigned_id: Optional[str]
    # What is the current relationship of the stakeholder to the issuer?
    current_relationship: Optional[StakeholderRelationshipType]
    # The primary contact info for the stakeholder
    primary_contact: Optional[ContactInfo]
    # Addresses for the stakeholder
    addresses: Optional[list[Address]]
    # The tax ids for this stakeholder
    tax_ids: Optional[list[TaxID]]
    # Identifier for the object
    id: str
    # Unstructured text comments related to and stored for the object
    comments: Optional[list[str]]
