"""
Transactions Object

JSON containing file type identifier and list transactions

Copyright © Shoobx, 2023
Schema is Copyright © 2023 Open Cap Table Coalition (https://opencaptablecoalition.com) /
Original File: https://github.com/Open-Cap-Table-Coalition/Open-Cap-Format-
OCF/tree/main/schema/files/TransactionsFile.schema.json

Autogenerated, do not edit.
"""

from pydantic import Field
from pyocf.objects.transactions.acceptance.convertibleacceptance import (
    ConvertibleAcceptance,
)
from pyocf.objects.transactions.acceptance.plansecurityacceptance import (
    PlanSecurityAcceptance,
)
from pyocf.objects.transactions.acceptance.stockacceptance import StockAcceptance
from pyocf.objects.transactions.acceptance.warrantacceptance import WarrantAcceptance
from pyocf.objects.transactions.adjustment.stockclassauthorizedsharesadjustment import (
    StockClassAuthorizedSharesAdjustment,
)
from pyocf.objects.transactions.adjustment.stockclassconversionratioadjustment import (
    StockClassConversionRatioAdjustment,
)
from pyocf.objects.transactions.adjustment.stockplanpooladjustment import (
    StockPlanPoolAdjustment,
)
from pyocf.objects.transactions.cancellation.convertiblecancellation import (
    ConvertibleCancellation,
)
from pyocf.objects.transactions.cancellation.plansecuritycancellation import (
    PlanSecurityCancellation,
)
from pyocf.objects.transactions.cancellation.stockcancellation import StockCancellation
from pyocf.objects.transactions.cancellation.warrantcancellation import (
    WarrantCancellation,
)
from pyocf.objects.transactions.conversion.convertibleconversion import (
    ConvertibleConversion,
)
from pyocf.objects.transactions.conversion.stockconversion import StockConversion
from pyocf.objects.transactions.exercise.plansecurityexercise import (
    PlanSecurityExercise,
)
from pyocf.objects.transactions.exercise.warrantexercise import WarrantExercise
from pyocf.objects.transactions.issuance.convertibleissuance import ConvertibleIssuance
from pyocf.objects.transactions.issuance.plansecurityissuance import (
    PlanSecurityIssuance,
)
from pyocf.objects.transactions.issuance.stockissuance import StockIssuance
from pyocf.objects.transactions.issuance.warrantissuance import WarrantIssuance
from pyocf.objects.transactions.reissuance.stockreissuance import StockReissuance
from pyocf.objects.transactions.release.plansecurityrelease import PlanSecurityRelease
from pyocf.objects.transactions.repurchase.stockrepurchase import StockRepurchase
from pyocf.objects.transactions.retraction.convertibleretraction import (
    ConvertibleRetraction,
)
from pyocf.objects.transactions.retraction.plansecurityretraction import (
    PlanSecurityRetraction,
)
from pyocf.objects.transactions.retraction.stockretraction import StockRetraction
from pyocf.objects.transactions.retraction.warrantretraction import WarrantRetraction
from pyocf.objects.transactions.split.stockclasssplit import StockClassSplit
from pyocf.objects.transactions.transfer.convertibletransfer import ConvertibleTransfer
from pyocf.objects.transactions.transfer.plansecuritytransfer import (
    PlanSecurityTransfer,
)
from pyocf.objects.transactions.transfer.stocktransfer import StockTransfer
from pyocf.objects.transactions.transfer.warranttransfer import WarrantTransfer
from pyocf.objects.transactions.vesting.vestingacceleration import VestingAcceleration
from pyocf.objects.transactions.vesting.vestingevent import VestingEvent
from pyocf.objects.transactions.vesting.vestingstart import VestingStart
from pyocf.primitives.files.file import FileObject
from typing import Annotated
from typing import Literal
from typing import Union


class TransactionsFile(FileObject):
    """Transactions"""

    # List of OCF transaction objects
    items: list[
        Annotated[
            Union[
                ConvertibleAcceptance,
                PlanSecurityAcceptance,
                StockAcceptance,
                WarrantAcceptance,
                ConvertibleCancellation,
                PlanSecurityCancellation,
                StockCancellation,
                WarrantCancellation,
                ConvertibleConversion,
                StockConversion,
                PlanSecurityExercise,
                WarrantExercise,
                ConvertibleIssuance,
                PlanSecurityIssuance,
                StockIssuance,
                WarrantIssuance,
                StockReissuance,
                StockRepurchase,
                PlanSecurityRelease,
                ConvertibleRetraction,
                PlanSecurityRetraction,
                StockRetraction,
                WarrantRetraction,
                StockClassSplit,
                StockClassConversionRatioAdjustment,
                StockClassAuthorizedSharesAdjustment,
                ConvertibleTransfer,
                PlanSecurityTransfer,
                StockTransfer,
                WarrantTransfer,
                VestingAcceleration,
                VestingStart,
                VestingEvent,
                StockPlanPoolAdjustment,
            ],
            Field(discriminator="object_type"),
        ]
    ]
    file_type: Literal["OCF_TRANSACTIONS_FILE"] = "OCF_TRANSACTIONS_FILE"
