# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetAppTokenResult',
    'AwaitableGetAppTokenResult',
    'get_app_token',
    'get_app_token_output',
]

@pulumi.output_type
class GetAppTokenResult:
    """
    A collection of values returned by getAppToken.
    """
    def __init__(__self__, app_id=None, id=None, installation_id=None, pem_file=None, token=None):
        if app_id and not isinstance(app_id, str):
            raise TypeError("Expected argument 'app_id' to be a str")
        pulumi.set(__self__, "app_id", app_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if installation_id and not isinstance(installation_id, str):
            raise TypeError("Expected argument 'installation_id' to be a str")
        pulumi.set(__self__, "installation_id", installation_id)
        if pem_file and not isinstance(pem_file, str):
            raise TypeError("Expected argument 'pem_file' to be a str")
        pulumi.set(__self__, "pem_file", pem_file)
        if token and not isinstance(token, str):
            raise TypeError("Expected argument 'token' to be a str")
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> str:
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="installationId")
    def installation_id(self) -> str:
        return pulumi.get(self, "installation_id")

    @property
    @pulumi.getter(name="pemFile")
    def pem_file(self) -> str:
        return pulumi.get(self, "pem_file")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The generated GitHub APP JWT.
        """
        return pulumi.get(self, "token")


class AwaitableGetAppTokenResult(GetAppTokenResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAppTokenResult(
            app_id=self.app_id,
            id=self.id,
            installation_id=self.installation_id,
            pem_file=self.pem_file,
            token=self.token)


def get_app_token(app_id: Optional[str] = None,
                  installation_id: Optional[str] = None,
                  pem_file: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAppTokenResult:
    """
    Use this data source to generate a [GitHub App JWT](https://docs.github.com/en/apps/creating-github-apps/authenticating-with-a-github-app/generating-a-json-web-token-jwt-for-a-github-app).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_github as github

    this = github.get_app_token(app_id="123456",
        installation_id="78910",
        pem_file=(lambda path: open(path).read())("foo/bar.pem"))
    ```


    :param str app_id: This is the ID of the GitHub App.
    :param str installation_id: This is the ID of the GitHub App installation.
    :param str pem_file: This is the contents of the GitHub App private key PEM file.
    """
    __args__ = dict()
    __args__['appId'] = app_id
    __args__['installationId'] = installation_id
    __args__['pemFile'] = pem_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('github:index/getAppToken:getAppToken', __args__, opts=opts, typ=GetAppTokenResult).value

    return AwaitableGetAppTokenResult(
        app_id=pulumi.get(__ret__, 'app_id'),
        id=pulumi.get(__ret__, 'id'),
        installation_id=pulumi.get(__ret__, 'installation_id'),
        pem_file=pulumi.get(__ret__, 'pem_file'),
        token=pulumi.get(__ret__, 'token'))


@_utilities.lift_output_func(get_app_token)
def get_app_token_output(app_id: Optional[pulumi.Input[str]] = None,
                         installation_id: Optional[pulumi.Input[str]] = None,
                         pem_file: Optional[pulumi.Input[str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAppTokenResult]:
    """
    Use this data source to generate a [GitHub App JWT](https://docs.github.com/en/apps/creating-github-apps/authenticating-with-a-github-app/generating-a-json-web-token-jwt-for-a-github-app).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_github as github

    this = github.get_app_token(app_id="123456",
        installation_id="78910",
        pem_file=(lambda path: open(path).read())("foo/bar.pem"))
    ```


    :param str app_id: This is the ID of the GitHub App.
    :param str installation_id: This is the ID of the GitHub App installation.
    :param str pem_file: This is the contents of the GitHub App private key PEM file.
    """
    ...
