# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ActionsOrganizationOidcSubjectClaimCustomizationTemplateArgs', 'ActionsOrganizationOidcSubjectClaimCustomizationTemplate']

@pulumi.input_type
class ActionsOrganizationOidcSubjectClaimCustomizationTemplateArgs:
    def __init__(__self__, *,
                 include_claim_keys: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        The set of arguments for constructing a ActionsOrganizationOidcSubjectClaimCustomizationTemplate resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] include_claim_keys: A list of OpenID Connect claims.
        """
        pulumi.set(__self__, "include_claim_keys", include_claim_keys)

    @property
    @pulumi.getter(name="includeClaimKeys")
    def include_claim_keys(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of OpenID Connect claims.
        """
        return pulumi.get(self, "include_claim_keys")

    @include_claim_keys.setter
    def include_claim_keys(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "include_claim_keys", value)


@pulumi.input_type
class _ActionsOrganizationOidcSubjectClaimCustomizationTemplateState:
    def __init__(__self__, *,
                 include_claim_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering ActionsOrganizationOidcSubjectClaimCustomizationTemplate resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] include_claim_keys: A list of OpenID Connect claims.
        """
        if include_claim_keys is not None:
            pulumi.set(__self__, "include_claim_keys", include_claim_keys)

    @property
    @pulumi.getter(name="includeClaimKeys")
    def include_claim_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of OpenID Connect claims.
        """
        return pulumi.get(self, "include_claim_keys")

    @include_claim_keys.setter
    def include_claim_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "include_claim_keys", value)


class ActionsOrganizationOidcSubjectClaimCustomizationTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 include_claim_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        This resource allows you to create and manage an OpenID Connect subject claim customization template within a GitHub
        organization.

        More information on integrating GitHub with cloud providers using OpenID Connect and a list of available claims is
        available in the [Actions documentation](https://docs.github.com/en/actions/deployment/security-hardening-your-deployments/about-security-hardening-with-openid-connect).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        example_template = github.ActionsOrganizationOidcSubjectClaimCustomizationTemplate("exampleTemplate", include_claim_keys=[
            "actor",
            "context",
            "repository_owner",
        ])
        ```

        ## Import

        This resource can be imported using the organization's name.

        ```sh
         $ pulumi import github:index/actionsOrganizationOidcSubjectClaimCustomizationTemplate:ActionsOrganizationOidcSubjectClaimCustomizationTemplate test example_organization
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] include_claim_keys: A list of OpenID Connect claims.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ActionsOrganizationOidcSubjectClaimCustomizationTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to create and manage an OpenID Connect subject claim customization template within a GitHub
        organization.

        More information on integrating GitHub with cloud providers using OpenID Connect and a list of available claims is
        available in the [Actions documentation](https://docs.github.com/en/actions/deployment/security-hardening-your-deployments/about-security-hardening-with-openid-connect).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        example_template = github.ActionsOrganizationOidcSubjectClaimCustomizationTemplate("exampleTemplate", include_claim_keys=[
            "actor",
            "context",
            "repository_owner",
        ])
        ```

        ## Import

        This resource can be imported using the organization's name.

        ```sh
         $ pulumi import github:index/actionsOrganizationOidcSubjectClaimCustomizationTemplate:ActionsOrganizationOidcSubjectClaimCustomizationTemplate test example_organization
        ```

        :param str resource_name: The name of the resource.
        :param ActionsOrganizationOidcSubjectClaimCustomizationTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ActionsOrganizationOidcSubjectClaimCustomizationTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 include_claim_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ActionsOrganizationOidcSubjectClaimCustomizationTemplateArgs.__new__(ActionsOrganizationOidcSubjectClaimCustomizationTemplateArgs)

            if include_claim_keys is None and not opts.urn:
                raise TypeError("Missing required property 'include_claim_keys'")
            __props__.__dict__["include_claim_keys"] = include_claim_keys
        super(ActionsOrganizationOidcSubjectClaimCustomizationTemplate, __self__).__init__(
            'github:index/actionsOrganizationOidcSubjectClaimCustomizationTemplate:ActionsOrganizationOidcSubjectClaimCustomizationTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            include_claim_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'ActionsOrganizationOidcSubjectClaimCustomizationTemplate':
        """
        Get an existing ActionsOrganizationOidcSubjectClaimCustomizationTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] include_claim_keys: A list of OpenID Connect claims.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ActionsOrganizationOidcSubjectClaimCustomizationTemplateState.__new__(_ActionsOrganizationOidcSubjectClaimCustomizationTemplateState)

        __props__.__dict__["include_claim_keys"] = include_claim_keys
        return ActionsOrganizationOidcSubjectClaimCustomizationTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="includeClaimKeys")
    def include_claim_keys(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of OpenID Connect claims.
        """
        return pulumi.get(self, "include_claim_keys")

