import datetime

import yaml


def datetime_representer(dumper, dt):
    return dumper.represent_scalar("!time", dt.isoformat())


def datetime_constructor(loader, node):
    value = loader.construct_scalar(node)
    return datetime.datetime.fromisoformat(value).time()


def configure_yaml():
    yaml.add_representer(datetime.time, datetime_representer)
    yaml.add_constructor("!time", datetime_constructor)
