# coding: utf-8

"""
    Netilion API Documentation

    Welcome to the Netilion API Documentation, which provides interactive access and documentation to our REST API. Please visit our developer portal for further instructions and information: https://developer.netilion.endress.com/   # noqa: E501

    OpenAPI spec version: 01.00.00
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class WebhookBase(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'url': 'str',
        'event_types': 'list[str]',
        'properties': 'WebhookBaseProperties',
        'disabled': 'bool'
    }

    attribute_map = {
        'url': 'url',
        'event_types': 'event_types',
        'properties': 'properties',
        'disabled': 'disabled'
    }

    discriminator_value_class_map = {
          'WebhookRequest': 'WebhookRequest'    }

    def __init__(self, url=None, event_types=None, properties=None, disabled=False):  # noqa: E501
        """WebhookBase - a model defined in Swagger"""  # noqa: E501
        self._url = None
        self._event_types = None
        self._properties = None
        self._disabled = None
        self.discriminator = 'webhookBaseType'
        self.url = url
        self.event_types = event_types
        if properties is not None:
            self.properties = properties
        if disabled is not None:
            self.disabled = disabled

    @property
    def url(self):
        """Gets the url of this WebhookBase.  # noqa: E501

        url of the webhook  # noqa: E501

        :return: The url of this WebhookBase.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this WebhookBase.

        url of the webhook  # noqa: E501

        :param url: The url of this WebhookBase.  # noqa: E501
        :type: str
        """
        if url is None:
            raise ValueError("Invalid value for `url`, must not be `None`")  # noqa: E501

        self._url = url

    @property
    def event_types(self):
        """Gets the event_types of this WebhookBase.  # noqa: E501

        Array of event types to be subscribed.  # noqa: E501

        :return: The event_types of this WebhookBase.  # noqa: E501
        :rtype: list[str]
        """
        return self._event_types

    @event_types.setter
    def event_types(self, event_types):
        """Sets the event_types of this WebhookBase.

        Array of event types to be subscribed.  # noqa: E501

        :param event_types: The event_types of this WebhookBase.  # noqa: E501
        :type: list[str]
        """
        if event_types is None:
            raise ValueError("Invalid value for `event_types`, must not be `None`")  # noqa: E501

        self._event_types = event_types

    @property
    def properties(self):
        """Gets the properties of this WebhookBase.  # noqa: E501


        :return: The properties of this WebhookBase.  # noqa: E501
        :rtype: WebhookBaseProperties
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """Sets the properties of this WebhookBase.


        :param properties: The properties of this WebhookBase.  # noqa: E501
        :type: WebhookBaseProperties
        """

        self._properties = properties

    @property
    def disabled(self):
        """Gets the disabled of this WebhookBase.  # noqa: E501

        Disables the webhook.  # noqa: E501

        :return: The disabled of this WebhookBase.  # noqa: E501
        :rtype: bool
        """
        return self._disabled

    @disabled.setter
    def disabled(self, disabled):
        """Sets the disabled of this WebhookBase.

        Disables the webhook.  # noqa: E501

        :param disabled: The disabled of this WebhookBase.  # noqa: E501
        :type: bool
        """

        self._disabled = disabled

    def get_real_child_model(self, data):
        """Returns the real base class specified by the discriminator"""
        discriminator_value = data[self.discriminator].lower()
        return self.discriminator_value_class_map.get(discriminator_value)

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(WebhookBase, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, WebhookBase):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
