# coding: utf-8

"""
    Netilion API Documentation

    Welcome to the Netilion API Documentation, which provides interactive access and documentation to our REST API. Please visit our developer portal for further instructions and information: https://developer.netilion.endress.com/   # noqa: E501

    OpenAPI spec version: 01.00.00
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ClientApplicationBase(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'description': 'str',
        'redirect_uris': 'list[str]',
        'is_insider': 'bool',
        'can_send_mails': 'bool'
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'redirect_uris': 'redirect_uris',
        'is_insider': 'is_insider',
        'can_send_mails': 'can_send_mails'
    }

    discriminator_value_class_map = {
          'ClientApplicationResponse': 'ClientApplicationResponse',
'ClientApplicationPublicResponse': 'ClientApplicationPublicResponse',
'ClientApplicationRequest': 'ClientApplicationRequest'    }

    def __init__(self, name=None, description=None, redirect_uris=None, is_insider=None, can_send_mails=None):  # noqa: E501
        """ClientApplicationBase - a model defined in Swagger"""  # noqa: E501
        self._name = None
        self._description = None
        self._redirect_uris = None
        self._is_insider = None
        self._can_send_mails = None
        self.discriminator = 'clientApplicationBaseType'
        self.name = name
        if description is not None:
            self.description = description
        if redirect_uris is not None:
            self.redirect_uris = redirect_uris
        if is_insider is not None:
            self.is_insider = is_insider
        if can_send_mails is not None:
            self.can_send_mails = can_send_mails

    @property
    def name(self):
        """Gets the name of this ClientApplicationBase.  # noqa: E501

        Name of the client application  # noqa: E501

        :return: The name of this ClientApplicationBase.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ClientApplicationBase.

        Name of the client application  # noqa: E501

        :param name: The name of this ClientApplicationBase.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def description(self):
        """Gets the description of this ClientApplicationBase.  # noqa: E501

        Description of the client application  # noqa: E501

        :return: The description of this ClientApplicationBase.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this ClientApplicationBase.

        Description of the client application  # noqa: E501

        :param description: The description of this ClientApplicationBase.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def redirect_uris(self):
        """Gets the redirect_uris of this ClientApplicationBase.  # noqa: E501

        Redirect URIs array  # noqa: E501

        :return: The redirect_uris of this ClientApplicationBase.  # noqa: E501
        :rtype: list[str]
        """
        return self._redirect_uris

    @redirect_uris.setter
    def redirect_uris(self, redirect_uris):
        """Sets the redirect_uris of this ClientApplicationBase.

        Redirect URIs array  # noqa: E501

        :param redirect_uris: The redirect_uris of this ClientApplicationBase.  # noqa: E501
        :type: list[str]
        """

        self._redirect_uris = redirect_uris

    @property
    def is_insider(self):
        """Gets the is_insider of this ClientApplicationBase.  # noqa: E501

        Endress+Hauser Application  # noqa: E501

        :return: The is_insider of this ClientApplicationBase.  # noqa: E501
        :rtype: bool
        """
        return self._is_insider

    @is_insider.setter
    def is_insider(self, is_insider):
        """Sets the is_insider of this ClientApplicationBase.

        Endress+Hauser Application  # noqa: E501

        :param is_insider: The is_insider of this ClientApplicationBase.  # noqa: E501
        :type: bool
        """

        self._is_insider = is_insider

    @property
    def can_send_mails(self):
        """Gets the can_send_mails of this ClientApplicationBase.  # noqa: E501

        Is client application allowed to send mails?  # noqa: E501

        :return: The can_send_mails of this ClientApplicationBase.  # noqa: E501
        :rtype: bool
        """
        return self._can_send_mails

    @can_send_mails.setter
    def can_send_mails(self, can_send_mails):
        """Sets the can_send_mails of this ClientApplicationBase.

        Is client application allowed to send mails?  # noqa: E501

        :param can_send_mails: The can_send_mails of this ClientApplicationBase.  # noqa: E501
        :type: bool
        """

        self._can_send_mails = can_send_mails

    def get_real_child_model(self, data):
        """Returns the real base class specified by the discriminator"""
        discriminator_value = data[self.discriminator].lower()
        return self.discriminator_value_class_map.get(discriminator_value)

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ClientApplicationBase, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ClientApplicationBase):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
