# coding: utf-8

"""
    Netilion API Documentation

    Welcome to the Netilion API Documentation, which provides interactive access and documentation to our REST API. Please visit our developer portal for further instructions and information: https://developer.netilion.endress.com/   # noqa: E501

    OpenAPI spec version: 01.00.00
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from netilion_api.api_client import ApiClient


class ValuesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_asset_values(self, body, asset_id, **kwargs):  # noqa: E501
        """Create asset values  # noqa: E501

        Store values measured by an asset. For performance reasons, this endpoint behaves somewhat differently than normal endpoints:  * The data passed to this endpoint is processed asynchronously. * This endpoint always returns an empty response with status 204 No Content. * The data will be validated during processing. Invalid data will be dropped silently. * The request size is limited to 500kb, requests larger then 500kb will get an \"413 Payload Too Large\" error.  Data validations and manipultation:    * Keys and groups can only consist of the charaters [a-z A-Z 0-9 . - _ ].   * Keys and groups will be converted to lower case strings.   * Keys and groups must be between 1 and 128 characters long.   * Units can be passed as id or code. See the units endpoint for all available units.   * The timestamp is not mandatory and will be set to the time the value was transmitted to the server (This only works if the values get transfered one at a time, if you send multiple values without timestamp at once, all values will get the same timestamp and there for only the last one will be stored)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_asset_values(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetValuesRequest body: Values to store to an asset. (required)
        :param int asset_id: The resource defined in the URL (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_asset_values_with_http_info(body, asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_asset_values_with_http_info(body, asset_id, **kwargs)  # noqa: E501
            return data

    def create_asset_values_with_http_info(self, body, asset_id, **kwargs):  # noqa: E501
        """Create asset values  # noqa: E501

        Store values measured by an asset. For performance reasons, this endpoint behaves somewhat differently than normal endpoints:  * The data passed to this endpoint is processed asynchronously. * This endpoint always returns an empty response with status 204 No Content. * The data will be validated during processing. Invalid data will be dropped silently. * The request size is limited to 500kb, requests larger then 500kb will get an \"413 Payload Too Large\" error.  Data validations and manipultation:    * Keys and groups can only consist of the charaters [a-z A-Z 0-9 . - _ ].   * Keys and groups will be converted to lower case strings.   * Keys and groups must be between 1 and 128 characters long.   * Units can be passed as id or code. See the units endpoint for all available units.   * The timestamp is not mandatory and will be set to the time the value was transmitted to the server (This only works if the values get transfered one at a time, if you send multiple values without timestamp at once, all values will get the same timestamp and there for only the last one will be stored)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_asset_values_with_http_info(body, asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AssetValuesRequest body: Values to store to an asset. (required)
        :param int asset_id: The resource defined in the URL (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'asset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_asset_values" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_asset_values`")  # noqa: E501
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `create_asset_values`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/values', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_asset_values(self, asset_id, **kwargs):  # noqa: E501
        """Get latest values for the asset.  # noqa: E501

        Returns a collection of the latest value for every key of the asset. Possible include values: ```unit, unit.base_unit```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_values(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param bool use_preferred_units: whether to return the values in the preferred units described in the asset specification 'preferred_units' or not. These values have lower precedence than the parameter key_unit_id. Example value of the specification is '{\"key_1\"\\:\"unit_code_1\", \"key_2\"\\:\"unit_code_2\"}'
        :param str key: only the values of the specified keys will be returned. If no key is specified all keys of the asset with its latest values will be received. Multiple values can be specified in a comma seperated list.
        :param str key_unit_id: value of the provided key will be returned in the specified unit. If no key_unit is defined the last written unit will be returned. Accepted format is `key[unit_id]`. Multiple values can be provided in a comma seperated list.
        :param str group: Group of the asset value.
        :return: AssetValuesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_asset_values_with_http_info(asset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_asset_values_with_http_info(asset_id, **kwargs)  # noqa: E501
            return data

    def get_asset_values_with_http_info(self, asset_id, **kwargs):  # noqa: E501
        """Get latest values for the asset.  # noqa: E501

        Returns a collection of the latest value for every key of the asset. Possible include values: ```unit, unit.base_unit```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_values_with_http_info(asset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param bool use_preferred_units: whether to return the values in the preferred units described in the asset specification 'preferred_units' or not. These values have lower precedence than the parameter key_unit_id. Example value of the specification is '{\"key_1\"\\:\"unit_code_1\", \"key_2\"\\:\"unit_code_2\"}'
        :param str key: only the values of the specified keys will be returned. If no key is specified all keys of the asset with its latest values will be received. Multiple values can be specified in a comma seperated list.
        :param str key_unit_id: value of the provided key will be returned in the specified unit. If no key_unit is defined the last written unit will be returned. Accepted format is `key[unit_id]`. Multiple values can be provided in a comma seperated list.
        :param str group: Group of the asset value.
        :return: AssetValuesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_id', 'page', 'per_page', 'include', 'use_preferred_units', 'key', 'key_unit_id', 'group']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_asset_values" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `get_asset_values`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'use_preferred_units' in params:
            query_params.append(('use_preferred_units', params['use_preferred_units']))  # noqa: E501
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
        if 'key_unit_id' in params:
            query_params.append(('key_unit_id', params['key_unit_id']))  # noqa: E501
        if 'group' in params:
            query_params.append(('group', params['group']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/values', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetValuesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_asset_values_for_key(self, asset_id, key, **kwargs):  # noqa: E501
        """Get asset values for a specific key.  # noqa: E501

        Returns a collection of the history values of an values for the specified key. For a aggregated result of the values the filter parameters aggregation and interval are mandatory. Receiving the result in a specific unit please use the filter parameter unit. The allowed units can be found in the intro section. With the filter parameters from to it is possible to receive the history of a defined time period. Possible include values: ```unit```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_values_for_key(asset_id, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: The resource defined in the URL (required)
        :param str key: key for the asset values (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page, default value is 500, maximum is 1000
        :param str include: Comma separated list of objects to include in response
        :param bool use_preferred_units: whether to return the values in the preferred units described in the asset specification 'preferred_units' or not. These values have lower precedence than the parameter unit_id. Example value of the specification is '{\"key_1\"\\:\"unit_code_1\", \"key_2\"\\:\"unit_code_2\"}'
        :param date _from: Start date filter for history values. Expected date format is YYYY-MM-DDThh:mm:ss
        :param date to: End date for history values. Expected date format is YYYY-MM-DDThh:mm:ss
        :param int unit_id: Id of the unit in which the values are to be returned.
        :param str aggregation: Supported aggregation methods are `mean, min, max, sum, stddev`. This value is mandatory if interval is defined.
        :param str interval: Interval which is used for the aggregation. The value is mandatory if aggregation is defined. Supported intervals are number of `s, m, h, d, w`. Example `3h`.
        :param str order_by: Order result by attribute value, accepts `timestamp`, add `-` as a prefix for descending order. Default ordering is the order the values were entered in.
        :return: AssetKeyValuesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_asset_values_for_key_with_http_info(asset_id, key, **kwargs)  # noqa: E501
        else:
            (data) = self.get_asset_values_for_key_with_http_info(asset_id, key, **kwargs)  # noqa: E501
            return data

    def get_asset_values_for_key_with_http_info(self, asset_id, key, **kwargs):  # noqa: E501
        """Get asset values for a specific key.  # noqa: E501

        Returns a collection of the history values of an values for the specified key. For a aggregated result of the values the filter parameters aggregation and interval are mandatory. Receiving the result in a specific unit please use the filter parameter unit. The allowed units can be found in the intro section. With the filter parameters from to it is possible to receive the history of a defined time period. Possible include values: ```unit```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_asset_values_for_key_with_http_info(asset_id, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int asset_id: The resource defined in the URL (required)
        :param str key: key for the asset values (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page, default value is 500, maximum is 1000
        :param str include: Comma separated list of objects to include in response
        :param bool use_preferred_units: whether to return the values in the preferred units described in the asset specification 'preferred_units' or not. These values have lower precedence than the parameter unit_id. Example value of the specification is '{\"key_1\"\\:\"unit_code_1\", \"key_2\"\\:\"unit_code_2\"}'
        :param date _from: Start date filter for history values. Expected date format is YYYY-MM-DDThh:mm:ss
        :param date to: End date for history values. Expected date format is YYYY-MM-DDThh:mm:ss
        :param int unit_id: Id of the unit in which the values are to be returned.
        :param str aggregation: Supported aggregation methods are `mean, min, max, sum, stddev`. This value is mandatory if interval is defined.
        :param str interval: Interval which is used for the aggregation. The value is mandatory if aggregation is defined. Supported intervals are number of `s, m, h, d, w`. Example `3h`.
        :param str order_by: Order result by attribute value, accepts `timestamp`, add `-` as a prefix for descending order. Default ordering is the order the values were entered in.
        :return: AssetKeyValuesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['asset_id', 'key', 'page', 'per_page', 'include', 'use_preferred_units', '_from', 'to', 'unit_id', 'aggregation', 'interval', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_asset_values_for_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'asset_id' is set
        if ('asset_id' not in params or
                params['asset_id'] is None):
            raise ValueError("Missing the required parameter `asset_id` when calling `get_asset_values_for_key`")  # noqa: E501
        # verify the required parameter 'key' is set
        if ('key' not in params or
                params['key'] is None):
            raise ValueError("Missing the required parameter `key` when calling `get_asset_values_for_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in params:
            path_params['asset_id'] = params['asset_id']  # noqa: E501
        if 'key' in params:
            path_params['key'] = params['key']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'use_preferred_units' in params:
            query_params.append(('use_preferred_units', params['use_preferred_units']))  # noqa: E501
        if '_from' in params:
            query_params.append(('from', params['_from']))  # noqa: E501
        if 'to' in params:
            query_params.append(('to', params['to']))  # noqa: E501
        if 'unit_id' in params:
            query_params.append(('unit_id', params['unit_id']))  # noqa: E501
        if 'aggregation' in params:
            query_params.append(('aggregation', params['aggregation']))  # noqa: E501
        if 'interval' in params:
            query_params.append(('interval', params['interval']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/assets/{asset_id}/values/{key}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetKeyValuesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_batch_values(self, batch_id, **kwargs):  # noqa: E501
        """Get latest values for the batch.  # noqa: E501

        Returns a collection of the latest values for all keys of the batch. Possible include values: ```unit, asset, system```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_batch_values(batch_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int batch_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param bool use_preferred_units: whether to return the values in the preferred units described in the asset specification 'preferred_units' or not, for the instrumentation the mapping will result from the merge of all its assets mappings. These values have lower precedence than the parameter key_unit_id. Example value of the specification is '{\"key_1\"\\:\"unit_code_1\", \"key_2\"\\:\"unit_code_2\"}'
        :param str key: only the values of the specified keys will be returned. If no key is specified all keys of the asset with its latest values will be received. Multiple values can be specified in a comma seperated list.
        :param str key_unit_id: value of the provided key will be returned in the specified unit. If no key_unit is defined the last written unit will be returned. Accepted format is `key[unit_id]`. Multiple values can be provided in a comma seperated list.
        :param str group: Group of the asset value.
        :return: AssetValuesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_batch_values_with_http_info(batch_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_batch_values_with_http_info(batch_id, **kwargs)  # noqa: E501
            return data

    def get_batch_values_with_http_info(self, batch_id, **kwargs):  # noqa: E501
        """Get latest values for the batch.  # noqa: E501

        Returns a collection of the latest values for all keys of the batch. Possible include values: ```unit, asset, system```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_batch_values_with_http_info(batch_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int batch_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param bool use_preferred_units: whether to return the values in the preferred units described in the asset specification 'preferred_units' or not, for the instrumentation the mapping will result from the merge of all its assets mappings. These values have lower precedence than the parameter key_unit_id. Example value of the specification is '{\"key_1\"\\:\"unit_code_1\", \"key_2\"\\:\"unit_code_2\"}'
        :param str key: only the values of the specified keys will be returned. If no key is specified all keys of the asset with its latest values will be received. Multiple values can be specified in a comma seperated list.
        :param str key_unit_id: value of the provided key will be returned in the specified unit. If no key_unit is defined the last written unit will be returned. Accepted format is `key[unit_id]`. Multiple values can be provided in a comma seperated list.
        :param str group: Group of the asset value.
        :return: AssetValuesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['batch_id', 'page', 'per_page', 'include', 'use_preferred_units', 'key', 'key_unit_id', 'group']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_batch_values" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'batch_id' is set
        if ('batch_id' not in params or
                params['batch_id'] is None):
            raise ValueError("Missing the required parameter `batch_id` when calling `get_batch_values`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'batch_id' in params:
            path_params['batch_id'] = params['batch_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'use_preferred_units' in params:
            query_params.append(('use_preferred_units', params['use_preferred_units']))  # noqa: E501
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
        if 'key_unit_id' in params:
            query_params.append(('key_unit_id', params['key_unit_id']))  # noqa: E501
        if 'group' in params:
            query_params.append(('group', params['group']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/batches/{batch_id}/values', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetValuesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_batch_values_for_key(self, batch_id, key, **kwargs):  # noqa: E501
        """Get batch values for a specific key.  # noqa: E501

        Returns a collection of the history values of an values for the specified key. For a aggregated result of the values the filter parameters aggregation and interval are mandatory. Receiving the result in a specific unit please use the filter parameter unit. The allowed units can be found in the intro section. With the filter parameters from to it is possible to receive the history of a defined time period. Possible include values: ```unit```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_batch_values_for_key(batch_id, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int batch_id: The resource defined in the URL (required)
        :param str key: key for the batch values (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page, default value is 500, maximum is 1000
        :param str include: Comma separated list of objects to include in response
        :param bool use_preferred_units: whether to return the values in the preferred units described in the asset specification 'preferred_units' or not, for the instrumentation the mapping will result from the merge of all its assets mappings. These values have lower precedence than the parameter unit_id. Example value of the specification is '{\"key_1\"\\:\"unit_code_1\", \"key_2\"\\:\"unit_code_2\"}'
        :param date _from: Start date filter for history values. Expected date format is YYYY-MM-DDThh:mm:ss
        :param date to: End date for history values. Expected date format is YYYY-MM-DDThh:mm:ss
        :param int unit_id: Id of the unit in which the values are to be returned.
        :param str aggregation: Supported aggregation methods are `mean, min, max, sum, stddev`. This value is mandatory if interval is defined.
        :param str interval: Interval which is used for the aggregation. The value is mandatory if aggregation is defined. Supported intervals are number of `s, m, h, d, w`. Example `3h`.
        :param str order_by: Order result by attribute value, accepts `timestamp`, add `-` as a prefix for descending order. Default ordering is the order the values were entered in.
        :return: AssetKeyValuesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_batch_values_for_key_with_http_info(batch_id, key, **kwargs)  # noqa: E501
        else:
            (data) = self.get_batch_values_for_key_with_http_info(batch_id, key, **kwargs)  # noqa: E501
            return data

    def get_batch_values_for_key_with_http_info(self, batch_id, key, **kwargs):  # noqa: E501
        """Get batch values for a specific key.  # noqa: E501

        Returns a collection of the history values of an values for the specified key. For a aggregated result of the values the filter parameters aggregation and interval are mandatory. Receiving the result in a specific unit please use the filter parameter unit. The allowed units can be found in the intro section. With the filter parameters from to it is possible to receive the history of a defined time period. Possible include values: ```unit```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_batch_values_for_key_with_http_info(batch_id, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int batch_id: The resource defined in the URL (required)
        :param str key: key for the batch values (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page, default value is 500, maximum is 1000
        :param str include: Comma separated list of objects to include in response
        :param bool use_preferred_units: whether to return the values in the preferred units described in the asset specification 'preferred_units' or not, for the instrumentation the mapping will result from the merge of all its assets mappings. These values have lower precedence than the parameter unit_id. Example value of the specification is '{\"key_1\"\\:\"unit_code_1\", \"key_2\"\\:\"unit_code_2\"}'
        :param date _from: Start date filter for history values. Expected date format is YYYY-MM-DDThh:mm:ss
        :param date to: End date for history values. Expected date format is YYYY-MM-DDThh:mm:ss
        :param int unit_id: Id of the unit in which the values are to be returned.
        :param str aggregation: Supported aggregation methods are `mean, min, max, sum, stddev`. This value is mandatory if interval is defined.
        :param str interval: Interval which is used for the aggregation. The value is mandatory if aggregation is defined. Supported intervals are number of `s, m, h, d, w`. Example `3h`.
        :param str order_by: Order result by attribute value, accepts `timestamp`, add `-` as a prefix for descending order. Default ordering is the order the values were entered in.
        :return: AssetKeyValuesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['batch_id', 'key', 'page', 'per_page', 'include', 'use_preferred_units', '_from', 'to', 'unit_id', 'aggregation', 'interval', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_batch_values_for_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'batch_id' is set
        if ('batch_id' not in params or
                params['batch_id'] is None):
            raise ValueError("Missing the required parameter `batch_id` when calling `get_batch_values_for_key`")  # noqa: E501
        # verify the required parameter 'key' is set
        if ('key' not in params or
                params['key'] is None):
            raise ValueError("Missing the required parameter `key` when calling `get_batch_values_for_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'batch_id' in params:
            path_params['batch_id'] = params['batch_id']  # noqa: E501
        if 'key' in params:
            path_params['key'] = params['key']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'use_preferred_units' in params:
            query_params.append(('use_preferred_units', params['use_preferred_units']))  # noqa: E501
        if '_from' in params:
            query_params.append(('from', params['_from']))  # noqa: E501
        if 'to' in params:
            query_params.append(('to', params['to']))  # noqa: E501
        if 'unit_id' in params:
            query_params.append(('unit_id', params['unit_id']))  # noqa: E501
        if 'aggregation' in params:
            query_params.append(('aggregation', params['aggregation']))  # noqa: E501
        if 'interval' in params:
            query_params.append(('interval', params['interval']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/batches/{batch_id}/values/{key}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetKeyValuesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_instrumentation_values(self, instrumentation_id, **kwargs):  # noqa: E501
        """Get latest values for the instrumentation.  # noqa: E501

        Returns a collection of the latest values for all keys of the instrumentation. Possible include values: ```unit, asset```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentation_values(instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param bool use_preferred_units: whether to return the values in the preferred units described in the asset specification 'preferred_units' or not, for the instrumentation the mapping will result from the merge of all its assets mappings. These values have lower precedence than the parameter key_unit_id. Example value of the specification is '{\"key_1\"\\:\"unit_code_1\", \"key_2\"\\:\"unit_code_2\"}'
        :param str key: only the values of the specified keys will be returned. If no key is specified all keys of the asset with its latest values will be received. Multiple values can be specified in a comma seperated list.
        :param str key_unit_id: value of the provided key will be returned in the specified unit. If no key_unit is defined the last written unit will be returned. Accepted format is `key[unit_id]`. Multiple values can be provided in a comma seperated list.
        :param str group: Group of the asset value.
        :return: AssetValuesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_instrumentation_values_with_http_info(instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_instrumentation_values_with_http_info(instrumentation_id, **kwargs)  # noqa: E501
            return data

    def get_instrumentation_values_with_http_info(self, instrumentation_id, **kwargs):  # noqa: E501
        """Get latest values for the instrumentation.  # noqa: E501

        Returns a collection of the latest values for all keys of the instrumentation. Possible include values: ```unit, asset```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentation_values_with_http_info(instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param bool use_preferred_units: whether to return the values in the preferred units described in the asset specification 'preferred_units' or not, for the instrumentation the mapping will result from the merge of all its assets mappings. These values have lower precedence than the parameter key_unit_id. Example value of the specification is '{\"key_1\"\\:\"unit_code_1\", \"key_2\"\\:\"unit_code_2\"}'
        :param str key: only the values of the specified keys will be returned. If no key is specified all keys of the asset with its latest values will be received. Multiple values can be specified in a comma seperated list.
        :param str key_unit_id: value of the provided key will be returned in the specified unit. If no key_unit is defined the last written unit will be returned. Accepted format is `key[unit_id]`. Multiple values can be provided in a comma seperated list.
        :param str group: Group of the asset value.
        :return: AssetValuesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instrumentation_id', 'page', 'per_page', 'include', 'use_preferred_units', 'key', 'key_unit_id', 'group']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instrumentation_values" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `get_instrumentation_values`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'use_preferred_units' in params:
            query_params.append(('use_preferred_units', params['use_preferred_units']))  # noqa: E501
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
        if 'key_unit_id' in params:
            query_params.append(('key_unit_id', params['key_unit_id']))  # noqa: E501
        if 'group' in params:
            query_params.append(('group', params['group']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/values', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetValuesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_instrumentation_values_for_key(self, instrumentation_id, key, **kwargs):  # noqa: E501
        """Get instrumentation values for a specific key.  # noqa: E501

        Returns a collection of the history values of an values for the specified key. For a aggregated result of the values the filter parameters aggregation and interval are mandatory. Receiving the result in a specific unit please use the filter parameter unit. The allowed units can be found in the intro section. With the filter parameters from to it is possible to receive the history of a defined time period. Possible include values: ```unit```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentation_values_for_key(instrumentation_id, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: The resource defined in the URL (required)
        :param str key: key for the instrumentation values (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page, default value is 500, maximum is 1000
        :param str include: Comma separated list of objects to include in response
        :param bool use_preferred_units: whether to return the values in the preferred units described in the asset specification 'preferred_units' or not, for the instrumentation the mapping will result from the merge of all its assets mappings. These values have lower precedence than the parameter unit_id. Example value of the specification is '{\"key_1\"\\:\"unit_code_1\", \"key_2\"\\:\"unit_code_2\"}'
        :param date _from: Start date filter for history values. Expected date format is YYYY-MM-DDThh:mm:ss
        :param date to: End date for history values. Expected date format is YYYY-MM-DDThh:mm:ss
        :param int unit_id: Id of the unit in which the values are to be returned.
        :param str aggregation: Supported aggregation methods are `mean, min, max, sum, stddev`. This value is mandatory if interval is defined.
        :param str interval: Interval which is used for the aggregation. The value is mandatory if aggregation is defined. Supported intervals are number of `s, m, h, d, w`. Example `3h`.
        :param str order_by: Order result by attribute value, accepts `timestamp`, add `-` as a prefix for descending order. Default ordering is the order the values were entered in.
        :return: AssetKeyValuesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_instrumentation_values_for_key_with_http_info(instrumentation_id, key, **kwargs)  # noqa: E501
        else:
            (data) = self.get_instrumentation_values_for_key_with_http_info(instrumentation_id, key, **kwargs)  # noqa: E501
            return data

    def get_instrumentation_values_for_key_with_http_info(self, instrumentation_id, key, **kwargs):  # noqa: E501
        """Get instrumentation values for a specific key.  # noqa: E501

        Returns a collection of the history values of an values for the specified key. For a aggregated result of the values the filter parameters aggregation and interval are mandatory. Receiving the result in a specific unit please use the filter parameter unit. The allowed units can be found in the intro section. With the filter parameters from to it is possible to receive the history of a defined time period. Possible include values: ```unit```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentation_values_for_key_with_http_info(instrumentation_id, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: The resource defined in the URL (required)
        :param str key: key for the instrumentation values (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page, default value is 500, maximum is 1000
        :param str include: Comma separated list of objects to include in response
        :param bool use_preferred_units: whether to return the values in the preferred units described in the asset specification 'preferred_units' or not, for the instrumentation the mapping will result from the merge of all its assets mappings. These values have lower precedence than the parameter unit_id. Example value of the specification is '{\"key_1\"\\:\"unit_code_1\", \"key_2\"\\:\"unit_code_2\"}'
        :param date _from: Start date filter for history values. Expected date format is YYYY-MM-DDThh:mm:ss
        :param date to: End date for history values. Expected date format is YYYY-MM-DDThh:mm:ss
        :param int unit_id: Id of the unit in which the values are to be returned.
        :param str aggregation: Supported aggregation methods are `mean, min, max, sum, stddev`. This value is mandatory if interval is defined.
        :param str interval: Interval which is used for the aggregation. The value is mandatory if aggregation is defined. Supported intervals are number of `s, m, h, d, w`. Example `3h`.
        :param str order_by: Order result by attribute value, accepts `timestamp`, add `-` as a prefix for descending order. Default ordering is the order the values were entered in.
        :return: AssetKeyValuesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instrumentation_id', 'key', 'page', 'per_page', 'include', 'use_preferred_units', '_from', 'to', 'unit_id', 'aggregation', 'interval', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instrumentation_values_for_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `get_instrumentation_values_for_key`")  # noqa: E501
        # verify the required parameter 'key' is set
        if ('key' not in params or
                params['key'] is None):
            raise ValueError("Missing the required parameter `key` when calling `get_instrumentation_values_for_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501
        if 'key' in params:
            path_params['key'] = params['key']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'use_preferred_units' in params:
            query_params.append(('use_preferred_units', params['use_preferred_units']))  # noqa: E501
        if '_from' in params:
            query_params.append(('from', params['_from']))  # noqa: E501
        if 'to' in params:
            query_params.append(('to', params['to']))  # noqa: E501
        if 'unit_id' in params:
            query_params.append(('unit_id', params['unit_id']))  # noqa: E501
        if 'aggregation' in params:
            query_params.append(('aggregation', params['aggregation']))  # noqa: E501
        if 'interval' in params:
            query_params.append(('interval', params['interval']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/values/{key}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetKeyValuesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_system_values(self, system_id, **kwargs):  # noqa: E501
        """Get latest values for the system.  # noqa: E501

        Returns a collection of the latest values for all keys of the system. Possible include values: ```unit, asset```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_system_values(system_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int system_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param bool use_preferred_units: whether to return the values in the preferred units described in the asset specification 'preferred_units' or not, for the instrumentation the mapping will result from the merge of all its assets mappings. These values have lower precedence than the parameter key_unit_id. Example value of the specification is '{\"key_1\"\\:\"unit_code_1\", \"key_2\"\\:\"unit_code_2\"}'
        :param str key: only the values of the specified keys will be returned. If no key is specified all keys of the asset with its latest values will be received. Multiple values can be specified in a comma seperated list.
        :param str key_unit_id: value of the provided key will be returned in the specified unit. If no key_unit is defined the last written unit will be returned. Accepted format is `key[unit_id]`. Multiple values can be provided in a comma seperated list.
        :param str group: Group of the asset value.
        :return: AssetValuesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_system_values_with_http_info(system_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_system_values_with_http_info(system_id, **kwargs)  # noqa: E501
            return data

    def get_system_values_with_http_info(self, system_id, **kwargs):  # noqa: E501
        """Get latest values for the system.  # noqa: E501

        Returns a collection of the latest values for all keys of the system. Possible include values: ```unit, asset```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_system_values_with_http_info(system_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int system_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param bool use_preferred_units: whether to return the values in the preferred units described in the asset specification 'preferred_units' or not, for the instrumentation the mapping will result from the merge of all its assets mappings. These values have lower precedence than the parameter key_unit_id. Example value of the specification is '{\"key_1\"\\:\"unit_code_1\", \"key_2\"\\:\"unit_code_2\"}'
        :param str key: only the values of the specified keys will be returned. If no key is specified all keys of the asset with its latest values will be received. Multiple values can be specified in a comma seperated list.
        :param str key_unit_id: value of the provided key will be returned in the specified unit. If no key_unit is defined the last written unit will be returned. Accepted format is `key[unit_id]`. Multiple values can be provided in a comma seperated list.
        :param str group: Group of the asset value.
        :return: AssetValuesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['system_id', 'page', 'per_page', 'include', 'use_preferred_units', 'key', 'key_unit_id', 'group']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_system_values" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'system_id' is set
        if ('system_id' not in params or
                params['system_id'] is None):
            raise ValueError("Missing the required parameter `system_id` when calling `get_system_values`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'system_id' in params:
            path_params['system_id'] = params['system_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'use_preferred_units' in params:
            query_params.append(('use_preferred_units', params['use_preferred_units']))  # noqa: E501
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
        if 'key_unit_id' in params:
            query_params.append(('key_unit_id', params['key_unit_id']))  # noqa: E501
        if 'group' in params:
            query_params.append(('group', params['group']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/systems/{system_id}/values', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetValuesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_system_values_for_key(self, system_id, key, **kwargs):  # noqa: E501
        """Get system values for a specific key.  # noqa: E501

        Returns a collection of the history values of an values for the specified key. For a aggregated result of the values the filter parameters aggregation and interval are mandatory. Receiving the result in a specific unit please use the filter parameter unit. The allowed units can be found in the intro section. With the filter parameters from to it is possible to receive the history of a defined time period. Possible include values: ```unit```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_system_values_for_key(system_id, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int system_id: The resource defined in the URL (required)
        :param str key: key for the system values (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page, default value is 500, maximum is 1000
        :param str include: Comma separated list of objects to include in response
        :param bool use_preferred_units: whether to return the values in the preferred units described in the asset specification 'preferred_units' or not, for the instrumentation the mapping will result from the merge of all its assets mappings. These values have lower precedence than the parameter unit_id. Example value of the specification is '{\"key_1\"\\:\"unit_code_1\", \"key_2\"\\:\"unit_code_2\"}'
        :param date _from: Start date filter for history values. Expected date format is YYYY-MM-DDThh:mm:ss
        :param date to: End date for history values. Expected date format is YYYY-MM-DDThh:mm:ss
        :param int unit_id: Id of the unit in which the values are to be returned.
        :param str aggregation: Supported aggregation methods are `mean, min, max, sum, stddev`. This value is mandatory if interval is defined.
        :param str interval: Interval which is used for the aggregation. The value is mandatory if aggregation is defined. Supported intervals are number of `s, m, h, d, w`. Example `3h`.
        :param str order_by: Order result by attribute value, accepts `timestamp`, add `-` as a prefix for descending order. Default ordering is the order the values were entered in.
        :return: AssetKeyValuesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_system_values_for_key_with_http_info(system_id, key, **kwargs)  # noqa: E501
        else:
            (data) = self.get_system_values_for_key_with_http_info(system_id, key, **kwargs)  # noqa: E501
            return data

    def get_system_values_for_key_with_http_info(self, system_id, key, **kwargs):  # noqa: E501
        """Get system values for a specific key.  # noqa: E501

        Returns a collection of the history values of an values for the specified key. For a aggregated result of the values the filter parameters aggregation and interval are mandatory. Receiving the result in a specific unit please use the filter parameter unit. The allowed units can be found in the intro section. With the filter parameters from to it is possible to receive the history of a defined time period. Possible include values: ```unit```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_system_values_for_key_with_http_info(system_id, key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int system_id: The resource defined in the URL (required)
        :param str key: key for the system values (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page, default value is 500, maximum is 1000
        :param str include: Comma separated list of objects to include in response
        :param bool use_preferred_units: whether to return the values in the preferred units described in the asset specification 'preferred_units' or not, for the instrumentation the mapping will result from the merge of all its assets mappings. These values have lower precedence than the parameter unit_id. Example value of the specification is '{\"key_1\"\\:\"unit_code_1\", \"key_2\"\\:\"unit_code_2\"}'
        :param date _from: Start date filter for history values. Expected date format is YYYY-MM-DDThh:mm:ss
        :param date to: End date for history values. Expected date format is YYYY-MM-DDThh:mm:ss
        :param int unit_id: Id of the unit in which the values are to be returned.
        :param str aggregation: Supported aggregation methods are `mean, min, max, sum, stddev`. This value is mandatory if interval is defined.
        :param str interval: Interval which is used for the aggregation. The value is mandatory if aggregation is defined. Supported intervals are number of `s, m, h, d, w`. Example `3h`.
        :param str order_by: Order result by attribute value, accepts `timestamp`, add `-` as a prefix for descending order. Default ordering is the order the values were entered in.
        :return: AssetKeyValuesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['system_id', 'key', 'page', 'per_page', 'include', 'use_preferred_units', '_from', 'to', 'unit_id', 'aggregation', 'interval', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_system_values_for_key" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'system_id' is set
        if ('system_id' not in params or
                params['system_id'] is None):
            raise ValueError("Missing the required parameter `system_id` when calling `get_system_values_for_key`")  # noqa: E501
        # verify the required parameter 'key' is set
        if ('key' not in params or
                params['key'] is None):
            raise ValueError("Missing the required parameter `key` when calling `get_system_values_for_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'system_id' in params:
            path_params['system_id'] = params['system_id']  # noqa: E501
        if 'key' in params:
            path_params['key'] = params['key']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'use_preferred_units' in params:
            query_params.append(('use_preferred_units', params['use_preferred_units']))  # noqa: E501
        if '_from' in params:
            query_params.append(('from', params['_from']))  # noqa: E501
        if 'to' in params:
            query_params.append(('to', params['to']))  # noqa: E501
        if 'unit_id' in params:
            query_params.append(('unit_id', params['unit_id']))  # noqa: E501
        if 'aggregation' in params:
            query_params.append(('aggregation', params['aggregation']))  # noqa: E501
        if 'interval' in params:
            query_params.append(('interval', params['interval']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/systems/{system_id}/values/{key}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AssetKeyValuesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
