# coding: utf-8

"""
    Netilion API Documentation

    Welcome to the Netilion API Documentation, which provides interactive access and documentation to our REST API. Please visit our developer portal for further instructions and information: https://developer.netilion.endress.com/   # noqa: E501

    OpenAPI spec version: 01.00.00
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from netilion_api.api_client import ApiClient


class ThresholdApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_instrumentation_threshold(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Create an instrumentation threshold  # noqa: E501

        Create a new instrumentation threshold. This action requires ```can_udpate``` permission on the instrumentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_instrumentation_threshold(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ThresholdRequest body: Object body that will be created. (required)
        :param int instrumentation_id: Id of the specified instrumentation (required)
        :return: ThresholdResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_instrumentation_threshold_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_instrumentation_threshold_with_http_info(body, instrumentation_id, **kwargs)  # noqa: E501
            return data

    def create_instrumentation_threshold_with_http_info(self, body, instrumentation_id, **kwargs):  # noqa: E501
        """Create an instrumentation threshold  # noqa: E501

        Create a new instrumentation threshold. This action requires ```can_udpate``` permission on the instrumentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_instrumentation_threshold_with_http_info(body, instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ThresholdRequest body: Object body that will be created. (required)
        :param int instrumentation_id: Id of the specified instrumentation (required)
        :return: ThresholdResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'instrumentation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_instrumentation_threshold" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_instrumentation_threshold`")  # noqa: E501
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `create_instrumentation_threshold`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/thresholds', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ThresholdResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_recipe_threshold(self, body, recipe_id, **kwargs):  # noqa: E501
        """Create an recipe threshold  # noqa: E501

        Create a new recipe threshold. This action requires ```can_udpate``` permission on the recipe.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_recipe_threshold(body, recipe_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ThresholdRequest body: Object body that will be created. (required)
        :param int recipe_id: Id of the specified recipe (required)
        :return: ThresholdResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_recipe_threshold_with_http_info(body, recipe_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_recipe_threshold_with_http_info(body, recipe_id, **kwargs)  # noqa: E501
            return data

    def create_recipe_threshold_with_http_info(self, body, recipe_id, **kwargs):  # noqa: E501
        """Create an recipe threshold  # noqa: E501

        Create a new recipe threshold. This action requires ```can_udpate``` permission on the recipe.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_recipe_threshold_with_http_info(body, recipe_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ThresholdRequest body: Object body that will be created. (required)
        :param int recipe_id: Id of the specified recipe (required)
        :return: ThresholdResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'recipe_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_recipe_threshold" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_recipe_threshold`")  # noqa: E501
        # verify the required parameter 'recipe_id' is set
        if ('recipe_id' not in params or
                params['recipe_id'] is None):
            raise ValueError("Missing the required parameter `recipe_id` when calling `create_recipe_threshold`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'recipe_id' in params:
            path_params['recipe_id'] = params['recipe_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/recipes/{recipe_id}/thresholds', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ThresholdResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_system_threshold(self, body, system_id, **kwargs):  # noqa: E501
        """Create an system threshold  # noqa: E501

        Create a new system threshold. This action requires ```can_udpate``` permission on the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_system_threshold(body, system_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ThresholdRequest body: Object body that will be created. (required)
        :param int system_id: Id of the specified system (required)
        :return: ThresholdResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_system_threshold_with_http_info(body, system_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_system_threshold_with_http_info(body, system_id, **kwargs)  # noqa: E501
            return data

    def create_system_threshold_with_http_info(self, body, system_id, **kwargs):  # noqa: E501
        """Create an system threshold  # noqa: E501

        Create a new system threshold. This action requires ```can_udpate``` permission on the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_system_threshold_with_http_info(body, system_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ThresholdRequest body: Object body that will be created. (required)
        :param int system_id: Id of the specified system (required)
        :return: ThresholdResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'system_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_system_threshold" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_system_threshold`")  # noqa: E501
        # verify the required parameter 'system_id' is set
        if ('system_id' not in params or
                params['system_id'] is None):
            raise ValueError("Missing the required parameter `system_id` when calling `create_system_threshold`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'system_id' in params:
            path_params['system_id'] = params['system_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/systems/{system_id}/thresholds', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ThresholdResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_instrumentation_threshold(self, instrumentation_id, id, **kwargs):  # noqa: E501
        """Delete an instrumentation threshold.  # noqa: E501

        Delete an instrumentation threshold.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_instrumentation_threshold(instrumentation_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: Id of the instrumentation (required)
        :param int id: Id of the instrumentation threshold (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_instrumentation_threshold_with_http_info(instrumentation_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_instrumentation_threshold_with_http_info(instrumentation_id, id, **kwargs)  # noqa: E501
            return data

    def delete_instrumentation_threshold_with_http_info(self, instrumentation_id, id, **kwargs):  # noqa: E501
        """Delete an instrumentation threshold.  # noqa: E501

        Delete an instrumentation threshold.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_instrumentation_threshold_with_http_info(instrumentation_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: Id of the instrumentation (required)
        :param int id: Id of the instrumentation threshold (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instrumentation_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_instrumentation_threshold" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `delete_instrumentation_threshold`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_instrumentation_threshold`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/thresholds/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_recipe_threshold(self, recipe_id, id, **kwargs):  # noqa: E501
        """Delete an recipe threshold.  # noqa: E501

        Delete an recipe threshold.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_recipe_threshold(recipe_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int recipe_id: Id of the recipe (required)
        :param int id: Id of the recipe threshold (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_recipe_threshold_with_http_info(recipe_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_recipe_threshold_with_http_info(recipe_id, id, **kwargs)  # noqa: E501
            return data

    def delete_recipe_threshold_with_http_info(self, recipe_id, id, **kwargs):  # noqa: E501
        """Delete an recipe threshold.  # noqa: E501

        Delete an recipe threshold.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_recipe_threshold_with_http_info(recipe_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int recipe_id: Id of the recipe (required)
        :param int id: Id of the recipe threshold (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['recipe_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_recipe_threshold" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'recipe_id' is set
        if ('recipe_id' not in params or
                params['recipe_id'] is None):
            raise ValueError("Missing the required parameter `recipe_id` when calling `delete_recipe_threshold`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_recipe_threshold`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'recipe_id' in params:
            path_params['recipe_id'] = params['recipe_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/recipes/{recipe_id}/thresholds/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_system_threshold(self, system_id, id, **kwargs):  # noqa: E501
        """Delete an system threshold.  # noqa: E501

        Delete an system threshold.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_system_threshold(system_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int system_id: Id of the system (required)
        :param int id: Id of the system threshold (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_system_threshold_with_http_info(system_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_system_threshold_with_http_info(system_id, id, **kwargs)  # noqa: E501
            return data

    def delete_system_threshold_with_http_info(self, system_id, id, **kwargs):  # noqa: E501
        """Delete an system threshold.  # noqa: E501

        Delete an system threshold.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_system_threshold_with_http_info(system_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int system_id: Id of the system (required)
        :param int id: Id of the system threshold (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['system_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_system_threshold" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'system_id' is set
        if ('system_id' not in params or
                params['system_id'] is None):
            raise ValueError("Missing the required parameter `system_id` when calling `delete_system_threshold`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_system_threshold`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'system_id' in params:
            path_params['system_id'] = params['system_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/systems/{system_id}/thresholds/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_instrumentation_threshold(self, instrumentation_id, id, **kwargs):  # noqa: E501
        """Get an instrumentation threshold  # noqa: E501

        Get a single threshold of an instrumentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentation_threshold(instrumentation_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: Id of the instrumentation (required)
        :param int id: Id of the instrumentation threshold (required)
        :return: ThresholdResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_instrumentation_threshold_with_http_info(instrumentation_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_instrumentation_threshold_with_http_info(instrumentation_id, id, **kwargs)  # noqa: E501
            return data

    def get_instrumentation_threshold_with_http_info(self, instrumentation_id, id, **kwargs):  # noqa: E501
        """Get an instrumentation threshold  # noqa: E501

        Get a single threshold of an instrumentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentation_threshold_with_http_info(instrumentation_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: Id of the instrumentation (required)
        :param int id: Id of the instrumentation threshold (required)
        :return: ThresholdResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instrumentation_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instrumentation_threshold" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `get_instrumentation_threshold`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_instrumentation_threshold`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/thresholds/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ThresholdResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_instrumentation_thresholds(self, instrumentation_id, **kwargs):  # noqa: E501
        """Get instrumentation thresholds  # noqa: E501

        Get all thresholds of an instrumentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentation_thresholds(instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: Id of the instrumentation (required)
        :param str key: filter by key
        :param str threshold_type: filter by type
        :param str order_by: Order result by attribute value, accepts `name`, `key`, `threshold_type`, `notification`, `created_at`, `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: ThresholdsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_instrumentation_thresholds_with_http_info(instrumentation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_instrumentation_thresholds_with_http_info(instrumentation_id, **kwargs)  # noqa: E501
            return data

    def get_instrumentation_thresholds_with_http_info(self, instrumentation_id, **kwargs):  # noqa: E501
        """Get instrumentation thresholds  # noqa: E501

        Get all thresholds of an instrumentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instrumentation_thresholds_with_http_info(instrumentation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int instrumentation_id: Id of the instrumentation (required)
        :param str key: filter by key
        :param str threshold_type: filter by type
        :param str order_by: Order result by attribute value, accepts `name`, `key`, `threshold_type`, `notification`, `created_at`, `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: ThresholdsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instrumentation_id', 'key', 'threshold_type', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instrumentation_thresholds" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `get_instrumentation_thresholds`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501

        query_params = []
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
        if 'threshold_type' in params:
            query_params.append(('threshold_type', params['threshold_type']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/thresholds', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ThresholdsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_recipe_threshold(self, recipe_id, id, **kwargs):  # noqa: E501
        """Get an recipe threshold  # noqa: E501

        Get a single threshold of an recipe.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_recipe_threshold(recipe_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int recipe_id: Id of the recipe (required)
        :param int id: Id of the recipe threshold (required)
        :return: ThresholdResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_recipe_threshold_with_http_info(recipe_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_recipe_threshold_with_http_info(recipe_id, id, **kwargs)  # noqa: E501
            return data

    def get_recipe_threshold_with_http_info(self, recipe_id, id, **kwargs):  # noqa: E501
        """Get an recipe threshold  # noqa: E501

        Get a single threshold of an recipe.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_recipe_threshold_with_http_info(recipe_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int recipe_id: Id of the recipe (required)
        :param int id: Id of the recipe threshold (required)
        :return: ThresholdResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['recipe_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_recipe_threshold" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'recipe_id' is set
        if ('recipe_id' not in params or
                params['recipe_id'] is None):
            raise ValueError("Missing the required parameter `recipe_id` when calling `get_recipe_threshold`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_recipe_threshold`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'recipe_id' in params:
            path_params['recipe_id'] = params['recipe_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/recipes/{recipe_id}/thresholds/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ThresholdResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_recipe_thresholds(self, recipe_id, **kwargs):  # noqa: E501
        """Get recipe thresholds  # noqa: E501

        Get all thresholds of an recipe.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_recipe_thresholds(recipe_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int recipe_id: Id of the recipe (required)
        :param str key: filter by key
        :param str threshold_type: filter by type
        :param str order_by: Order result by attribute value, accepts `name`, `key`, `threshold_type`, `notification`, `created_at`, `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: ThresholdsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_recipe_thresholds_with_http_info(recipe_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_recipe_thresholds_with_http_info(recipe_id, **kwargs)  # noqa: E501
            return data

    def get_recipe_thresholds_with_http_info(self, recipe_id, **kwargs):  # noqa: E501
        """Get recipe thresholds  # noqa: E501

        Get all thresholds of an recipe.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_recipe_thresholds_with_http_info(recipe_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int recipe_id: Id of the recipe (required)
        :param str key: filter by key
        :param str threshold_type: filter by type
        :param str order_by: Order result by attribute value, accepts `name`, `key`, `threshold_type`, `notification`, `created_at`, `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: ThresholdsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['recipe_id', 'key', 'threshold_type', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_recipe_thresholds" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'recipe_id' is set
        if ('recipe_id' not in params or
                params['recipe_id'] is None):
            raise ValueError("Missing the required parameter `recipe_id` when calling `get_recipe_thresholds`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'recipe_id' in params:
            path_params['recipe_id'] = params['recipe_id']  # noqa: E501

        query_params = []
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
        if 'threshold_type' in params:
            query_params.append(('threshold_type', params['threshold_type']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/recipes/{recipe_id}/thresholds', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ThresholdsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_system_threshold(self, system_id, id, **kwargs):  # noqa: E501
        """Get an system threshold  # noqa: E501

        Get a single threshold of an system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_system_threshold(system_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int system_id: Id of the system (required)
        :param int id: Id of the system threshold (required)
        :return: ThresholdResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_system_threshold_with_http_info(system_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_system_threshold_with_http_info(system_id, id, **kwargs)  # noqa: E501
            return data

    def get_system_threshold_with_http_info(self, system_id, id, **kwargs):  # noqa: E501
        """Get an system threshold  # noqa: E501

        Get a single threshold of an system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_system_threshold_with_http_info(system_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int system_id: Id of the system (required)
        :param int id: Id of the system threshold (required)
        :return: ThresholdResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['system_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_system_threshold" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'system_id' is set
        if ('system_id' not in params or
                params['system_id'] is None):
            raise ValueError("Missing the required parameter `system_id` when calling `get_system_threshold`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_system_threshold`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'system_id' in params:
            path_params['system_id'] = params['system_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/systems/{system_id}/thresholds/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ThresholdResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_system_thresholds(self, system_id, **kwargs):  # noqa: E501
        """Get system thresholds  # noqa: E501

        Get all thresholds of an system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_system_thresholds(system_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int system_id: Id of the system (required)
        :param str key: filter by key
        :param str threshold_type: filter by type
        :param str order_by: Order result by attribute value, accepts `name`, `key`, `threshold_type`, `notification`, `created_at`, `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: ThresholdsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_system_thresholds_with_http_info(system_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_system_thresholds_with_http_info(system_id, **kwargs)  # noqa: E501
            return data

    def get_system_thresholds_with_http_info(self, system_id, **kwargs):  # noqa: E501
        """Get system thresholds  # noqa: E501

        Get all thresholds of an system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_system_thresholds_with_http_info(system_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int system_id: Id of the system (required)
        :param str key: filter by key
        :param str threshold_type: filter by type
        :param str order_by: Order result by attribute value, accepts `name`, `key`, `threshold_type`, `notification`, `created_at`, `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: ThresholdsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['system_id', 'key', 'threshold_type', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_system_thresholds" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'system_id' is set
        if ('system_id' not in params or
                params['system_id'] is None):
            raise ValueError("Missing the required parameter `system_id` when calling `get_system_thresholds`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'system_id' in params:
            path_params['system_id'] = params['system_id']  # noqa: E501

        query_params = []
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
        if 'threshold_type' in params:
            query_params.append(('threshold_type', params['threshold_type']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/systems/{system_id}/thresholds', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ThresholdsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_instrumentation_threshold(self, body, instrumentation_id, id, **kwargs):  # noqa: E501
        """Update an instrumentation threshold  # noqa: E501

        Replaces the threshold belonging to an instrumentation. This action requires `can_update` permission on the instrumentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_instrumentation_threshold(body, instrumentation_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ThresholdRequest body: Object body that will be updated. (required)
        :param int instrumentation_id: Id of the instrumentation (required)
        :param int id: Id of the instrumentation threshold (required)
        :return: ThresholdResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_instrumentation_threshold_with_http_info(body, instrumentation_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_instrumentation_threshold_with_http_info(body, instrumentation_id, id, **kwargs)  # noqa: E501
            return data

    def update_instrumentation_threshold_with_http_info(self, body, instrumentation_id, id, **kwargs):  # noqa: E501
        """Update an instrumentation threshold  # noqa: E501

        Replaces the threshold belonging to an instrumentation. This action requires `can_update` permission on the instrumentation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_instrumentation_threshold_with_http_info(body, instrumentation_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ThresholdRequest body: Object body that will be updated. (required)
        :param int instrumentation_id: Id of the instrumentation (required)
        :param int id: Id of the instrumentation threshold (required)
        :return: ThresholdResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'instrumentation_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_instrumentation_threshold" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_instrumentation_threshold`")  # noqa: E501
        # verify the required parameter 'instrumentation_id' is set
        if ('instrumentation_id' not in params or
                params['instrumentation_id'] is None):
            raise ValueError("Missing the required parameter `instrumentation_id` when calling `update_instrumentation_threshold`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_instrumentation_threshold`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instrumentation_id' in params:
            path_params['instrumentation_id'] = params['instrumentation_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/instrumentations/{instrumentation_id}/thresholds/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ThresholdResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_recipe_threshold(self, body, recipe_id, id, **kwargs):  # noqa: E501
        """Update an recipe threshold  # noqa: E501

        Replaces the threshold belonging to an recipe. This action requires `can_update` permission on the recipe.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_recipe_threshold(body, recipe_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ThresholdRequest body: Object body that will be updated. (required)
        :param int recipe_id: Id of the recipe (required)
        :param int id: Id of the recipe threshold (required)
        :return: ThresholdResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_recipe_threshold_with_http_info(body, recipe_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_recipe_threshold_with_http_info(body, recipe_id, id, **kwargs)  # noqa: E501
            return data

    def update_recipe_threshold_with_http_info(self, body, recipe_id, id, **kwargs):  # noqa: E501
        """Update an recipe threshold  # noqa: E501

        Replaces the threshold belonging to an recipe. This action requires `can_update` permission on the recipe.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_recipe_threshold_with_http_info(body, recipe_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ThresholdRequest body: Object body that will be updated. (required)
        :param int recipe_id: Id of the recipe (required)
        :param int id: Id of the recipe threshold (required)
        :return: ThresholdResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'recipe_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_recipe_threshold" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_recipe_threshold`")  # noqa: E501
        # verify the required parameter 'recipe_id' is set
        if ('recipe_id' not in params or
                params['recipe_id'] is None):
            raise ValueError("Missing the required parameter `recipe_id` when calling `update_recipe_threshold`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_recipe_threshold`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'recipe_id' in params:
            path_params['recipe_id'] = params['recipe_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/recipes/{recipe_id}/thresholds/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ThresholdResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_system_threshold(self, body, system_id, id, **kwargs):  # noqa: E501
        """Update an system threshold  # noqa: E501

        Replaces the threshold belonging to an system. This action requires `can_update` permission on the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_system_threshold(body, system_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ThresholdRequest body: Object body that will be updated. (required)
        :param int system_id: Id of the system (required)
        :param int id: Id of the system threshold (required)
        :return: ThresholdResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_system_threshold_with_http_info(body, system_id, id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_system_threshold_with_http_info(body, system_id, id, **kwargs)  # noqa: E501
            return data

    def update_system_threshold_with_http_info(self, body, system_id, id, **kwargs):  # noqa: E501
        """Update an system threshold  # noqa: E501

        Replaces the threshold belonging to an system. This action requires `can_update` permission on the system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_system_threshold_with_http_info(body, system_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ThresholdRequest body: Object body that will be updated. (required)
        :param int system_id: Id of the system (required)
        :param int id: Id of the system threshold (required)
        :return: ThresholdResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'system_id', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_system_threshold" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_system_threshold`")  # noqa: E501
        # verify the required parameter 'system_id' is set
        if ('system_id' not in params or
                params['system_id'] is None):
            raise ValueError("Missing the required parameter `system_id` when calling `update_system_threshold`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_system_threshold`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'system_id' in params:
            path_params['system_id'] = params['system_id']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/systems/{system_id}/thresholds/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ThresholdResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
