# coding: utf-8

"""
    Netilion API Documentation

    Welcome to the Netilion API Documentation, which provides interactive access and documentation to our REST API. Please visit our developer portal for further instructions and information: https://developer.netilion.endress.com/   # noqa: E501

    OpenAPI spec version: 01.00.00
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from netilion_api.api_client import ApiClient


class SearchApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def search(self, q, **kwargs):  # noqa: E501
        """search assets, batches, instrumentations, nodes, recipes, systems .  # noqa: E501

        search assets, instrumentations and nodes based on a defined set of fields.   asset - serial_number product_code product_name product_manufacturer_name   specification keys and values (of assets, nodes and instrumentation) when ui_visible is set to true   batches - batch_name      instrumentation - tag   nodes - name   recipes - recipe_name      systems - system_name    These fields may be extended in the  future.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search(q, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str q: search query (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str manufacturer_id: One or multiple ids (comma list). Expected id format is integer
        :param str product_category_id: One or multiple ids (comma list). By adding `+` after the id, the filter considers the given category and all its children (e.g. 3+).
        :param str product_status_id: One or multiple ids (comma list). Expected id format is integer
        :param str subscription_id: One or multiple ids (comma list). Expected id format is integer
        :param str scope: One or multiple scopes (comma list). Possible values are assets, instrumentations, nodes.
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: SearchItemsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_with_http_info(q, **kwargs)  # noqa: E501
        else:
            (data) = self.search_with_http_info(q, **kwargs)  # noqa: E501
            return data

    def search_with_http_info(self, q, **kwargs):  # noqa: E501
        """search assets, batches, instrumentations, nodes, recipes, systems .  # noqa: E501

        search assets, instrumentations and nodes based on a defined set of fields.   asset - serial_number product_code product_name product_manufacturer_name   specification keys and values (of assets, nodes and instrumentation) when ui_visible is set to true   batches - batch_name      instrumentation - tag   nodes - name   recipes - recipe_name      systems - system_name    These fields may be extended in the  future.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_with_http_info(q, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str q: search query (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str manufacturer_id: One or multiple ids (comma list). Expected id format is integer
        :param str product_category_id: One or multiple ids (comma list). By adding `+` after the id, the filter considers the given category and all its children (e.g. 3+).
        :param str product_status_id: One or multiple ids (comma list). Expected id format is integer
        :param str subscription_id: One or multiple ids (comma list). Expected id format is integer
        :param str scope: One or multiple scopes (comma list). Possible values are assets, instrumentations, nodes.
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: SearchItemsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['q', 'page', 'per_page', 'manufacturer_id', 'product_category_id', 'product_status_id', 'subscription_id', 'scope', 'accept_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'q' is set
        if ('q' not in params or
                params['q'] is None):
            raise ValueError("Missing the required parameter `q` when calling `search`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'q' in params:
            query_params.append(('q', params['q']))  # noqa: E501
        if 'manufacturer_id' in params:
            query_params.append(('manufacturer_id', params['manufacturer_id']))  # noqa: E501
        if 'product_category_id' in params:
            query_params.append(('product_category_id', params['product_category_id']))  # noqa: E501
        if 'product_status_id' in params:
            query_params.append(('product_status_id', params['product_status_id']))  # noqa: E501
        if 'subscription_id' in params:
            query_params.append(('subscription_id', params['subscription_id']))  # noqa: E501
        if 'scope' in params:
            query_params.append(('scope', params['scope']))  # noqa: E501

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/search', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SearchItemsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
