# coding: utf-8

"""
    Netilion API Documentation

    Welcome to the Netilion API Documentation, which provides interactive access and documentation to our REST API. Please visit our developer portal for further instructions and information: https://developer.netilion.endress.com/   # noqa: E501

    OpenAPI spec version: 01.00.00
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from netilion_api.api_client import ApiClient


class RequestForQuotationApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_bill_of_materials_to_request_for_quotation(self, body, request_for_quotation_id, **kwargs):  # noqa: E501
        """Add bill of materials to a request for quotation  # noqa: E501

        Add one or more bill of materials to a request for quotation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_bill_of_materials_to_request_for_quotation(body, request_for_quotation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BillOfMaterialIDs body: Resources that shall be added. (required)
        :param int request_for_quotation_id: Id of the request for quotation to which the bill of materials will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_bill_of_materials_to_request_for_quotation_with_http_info(body, request_for_quotation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_bill_of_materials_to_request_for_quotation_with_http_info(body, request_for_quotation_id, **kwargs)  # noqa: E501
            return data

    def add_bill_of_materials_to_request_for_quotation_with_http_info(self, body, request_for_quotation_id, **kwargs):  # noqa: E501
        """Add bill of materials to a request for quotation  # noqa: E501

        Add one or more bill of materials to a request for quotation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_bill_of_materials_to_request_for_quotation_with_http_info(body, request_for_quotation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BillOfMaterialIDs body: Resources that shall be added. (required)
        :param int request_for_quotation_id: Id of the request for quotation to which the bill of materials will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'request_for_quotation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_bill_of_materials_to_request_for_quotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_bill_of_materials_to_request_for_quotation`")  # noqa: E501
        # verify the required parameter 'request_for_quotation_id' is set
        if ('request_for_quotation_id' not in params or
                params['request_for_quotation_id'] is None):
            raise ValueError("Missing the required parameter `request_for_quotation_id` when calling `add_bill_of_materials_to_request_for_quotation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'request_for_quotation_id' in params:
            path_params['request_for_quotation_id'] = params['request_for_quotation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/request_for_quotations/{request_for_quotation_id}/bill_of_materials', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_documents_to_request_for_quotation(self, body, request_for_quotation_id, **kwargs):  # noqa: E501
        """Add documents to a request for quotation  # noqa: E501

        Add one or more documents to a request for quotation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_documents_to_request_for_quotation(body, request_for_quotation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be added. (required)
        :param int request_for_quotation_id: Id of the request for quotation to which the documents will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_documents_to_request_for_quotation_with_http_info(body, request_for_quotation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_documents_to_request_for_quotation_with_http_info(body, request_for_quotation_id, **kwargs)  # noqa: E501
            return data

    def add_documents_to_request_for_quotation_with_http_info(self, body, request_for_quotation_id, **kwargs):  # noqa: E501
        """Add documents to a request for quotation  # noqa: E501

        Add one or more documents to a request for quotation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_documents_to_request_for_quotation_with_http_info(body, request_for_quotation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be added. (required)
        :param int request_for_quotation_id: Id of the request for quotation to which the documents will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'request_for_quotation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_documents_to_request_for_quotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_documents_to_request_for_quotation`")  # noqa: E501
        # verify the required parameter 'request_for_quotation_id' is set
        if ('request_for_quotation_id' not in params or
                params['request_for_quotation_id'] is None):
            raise ValueError("Missing the required parameter `request_for_quotation_id` when calling `add_documents_to_request_for_quotation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'request_for_quotation_id' in params:
            path_params['request_for_quotation_id'] = params['request_for_quotation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/request_for_quotations/{request_for_quotation_id}/documents', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_quotations_to_request_for_quotation(self, body, request_for_quotation_id, **kwargs):  # noqa: E501
        """Add quotations to a request for quotation  # noqa: E501

        Add one or more quotations to a request for quotation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_quotations_to_request_for_quotation(body, request_for_quotation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param QuotationIDs body: Resources that shall be added. (required)
        :param int request_for_quotation_id: Id of the request for quotation to which the quotations will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_quotations_to_request_for_quotation_with_http_info(body, request_for_quotation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_quotations_to_request_for_quotation_with_http_info(body, request_for_quotation_id, **kwargs)  # noqa: E501
            return data

    def add_quotations_to_request_for_quotation_with_http_info(self, body, request_for_quotation_id, **kwargs):  # noqa: E501
        """Add quotations to a request for quotation  # noqa: E501

        Add one or more quotations to a request for quotation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_quotations_to_request_for_quotation_with_http_info(body, request_for_quotation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param QuotationIDs body: Resources that shall be added. (required)
        :param int request_for_quotation_id: Id of the request for quotation to which the quotations will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'request_for_quotation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_quotations_to_request_for_quotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_quotations_to_request_for_quotation`")  # noqa: E501
        # verify the required parameter 'request_for_quotation_id' is set
        if ('request_for_quotation_id' not in params or
                params['request_for_quotation_id'] is None):
            raise ValueError("Missing the required parameter `request_for_quotation_id` when calling `add_quotations_to_request_for_quotation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'request_for_quotation_id' in params:
            path_params['request_for_quotation_id'] = params['request_for_quotation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/request_for_quotations/{request_for_quotation_id}/quotations', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_request_for_quotation(self, body, **kwargs):  # noqa: E501
        """Create a new request for quotation  # noqa: E501

        Create a new request for quotation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_request_for_quotation(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestForQuotationRequest body: Object body that will be created (required)
        :return: RequestForQuotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_request_for_quotation_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_request_for_quotation_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_request_for_quotation_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create a new request for quotation  # noqa: E501

        Create a new request for quotation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_request_for_quotation_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestForQuotationRequest body: Object body that will be created (required)
        :return: RequestForQuotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_request_for_quotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_request_for_quotation`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/request_for_quotations', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RequestForQuotationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_bill_of_materials_from_request_for_quotation(self, body, request_for_quotation_id, **kwargs):  # noqa: E501
        """Remove bill of materials from a request for quotation  # noqa: E501

        Remove one or more bill of materials from a request for quotation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_bill_of_materials_from_request_for_quotation(body, request_for_quotation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BillOfMaterialIDs body: Resources that shall be removed. (required)
        :param int request_for_quotation_id: Id of the request for quotation from which the bill of materials will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_bill_of_materials_from_request_for_quotation_with_http_info(body, request_for_quotation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_bill_of_materials_from_request_for_quotation_with_http_info(body, request_for_quotation_id, **kwargs)  # noqa: E501
            return data

    def delete_bill_of_materials_from_request_for_quotation_with_http_info(self, body, request_for_quotation_id, **kwargs):  # noqa: E501
        """Remove bill of materials from a request for quotation  # noqa: E501

        Remove one or more bill of materials from a request for quotation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_bill_of_materials_from_request_for_quotation_with_http_info(body, request_for_quotation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BillOfMaterialIDs body: Resources that shall be removed. (required)
        :param int request_for_quotation_id: Id of the request for quotation from which the bill of materials will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'request_for_quotation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_bill_of_materials_from_request_for_quotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `delete_bill_of_materials_from_request_for_quotation`")  # noqa: E501
        # verify the required parameter 'request_for_quotation_id' is set
        if ('request_for_quotation_id' not in params or
                params['request_for_quotation_id'] is None):
            raise ValueError("Missing the required parameter `request_for_quotation_id` when calling `delete_bill_of_materials_from_request_for_quotation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'request_for_quotation_id' in params:
            path_params['request_for_quotation_id'] = params['request_for_quotation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/request_for_quotations/{request_for_quotation_id}/bill_of_materials', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_documents_of_request_for_quotation(self, body, request_for_quotation_id, **kwargs):  # noqa: E501
        """Remove documents from a request for quotation  # noqa: E501

        Remove one or more documents from a request for quotation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_documents_of_request_for_quotation(body, request_for_quotation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be removed. (required)
        :param int request_for_quotation_id: Id of the request for quotation from which the documents will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_documents_of_request_for_quotation_with_http_info(body, request_for_quotation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_documents_of_request_for_quotation_with_http_info(body, request_for_quotation_id, **kwargs)  # noqa: E501
            return data

    def delete_documents_of_request_for_quotation_with_http_info(self, body, request_for_quotation_id, **kwargs):  # noqa: E501
        """Remove documents from a request for quotation  # noqa: E501

        Remove one or more documents from a request for quotation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_documents_of_request_for_quotation_with_http_info(body, request_for_quotation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be removed. (required)
        :param int request_for_quotation_id: Id of the request for quotation from which the documents will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'request_for_quotation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_documents_of_request_for_quotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `delete_documents_of_request_for_quotation`")  # noqa: E501
        # verify the required parameter 'request_for_quotation_id' is set
        if ('request_for_quotation_id' not in params or
                params['request_for_quotation_id'] is None):
            raise ValueError("Missing the required parameter `request_for_quotation_id` when calling `delete_documents_of_request_for_quotation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'request_for_quotation_id' in params:
            path_params['request_for_quotation_id'] = params['request_for_quotation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/request_for_quotations/{request_for_quotation_id}/documents', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_quotations_from_request_for_quotation(self, body, request_for_quotation_id, **kwargs):  # noqa: E501
        """Remove quotations from a request for quotation  # noqa: E501

        Remove one or more quotations from a request for quotation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_quotations_from_request_for_quotation(body, request_for_quotation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param QuotationIDs body: Resources that shall be removed. (required)
        :param int request_for_quotation_id: Id of the request for quotation from which the quotations will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_quotations_from_request_for_quotation_with_http_info(body, request_for_quotation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_quotations_from_request_for_quotation_with_http_info(body, request_for_quotation_id, **kwargs)  # noqa: E501
            return data

    def delete_quotations_from_request_for_quotation_with_http_info(self, body, request_for_quotation_id, **kwargs):  # noqa: E501
        """Remove quotations from a request for quotation  # noqa: E501

        Remove one or more quotations from a request for quotation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_quotations_from_request_for_quotation_with_http_info(body, request_for_quotation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param QuotationIDs body: Resources that shall be removed. (required)
        :param int request_for_quotation_id: Id of the request for quotation from which the quotations will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'request_for_quotation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_quotations_from_request_for_quotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `delete_quotations_from_request_for_quotation`")  # noqa: E501
        # verify the required parameter 'request_for_quotation_id' is set
        if ('request_for_quotation_id' not in params or
                params['request_for_quotation_id'] is None):
            raise ValueError("Missing the required parameter `request_for_quotation_id` when calling `delete_quotations_from_request_for_quotation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'request_for_quotation_id' in params:
            path_params['request_for_quotation_id'] = params['request_for_quotation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/request_for_quotations/{request_for_quotation_id}/quotations', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_request_for_quotation(self, id, **kwargs):  # noqa: E501
        """Delete a request for quotation  # noqa: E501

        Delete a specific resource identified by the id in the URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_request_for_quotation(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the request for quotation to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_request_for_quotation_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_request_for_quotation_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_request_for_quotation_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete a request for quotation  # noqa: E501

        Delete a specific resource identified by the id in the URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_request_for_quotation_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the request for quotation to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_request_for_quotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_request_for_quotation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/request_for_quotations/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_bill_of_materials_of_request_for_quotation(self, request_for_quotation_id, **kwargs):  # noqa: E501
        """Get all bill of materials of one request for quotation  # noqa: E501

        Returns a list of all bill of materials that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bill_of_materials_of_request_for_quotation(request_for_quotation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int request_for_quotation_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str name: Filter accepts `*` as wildcard
        :param str author: Filter accepts `*` as wildcard
        :param str _date: Expected date format is YYYY-MM-DD
        :param str date_from: Expected date format is YYYY-MM-DD
        :param str date_to: Expected date format is YYYY-MM-DD
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: BillOfMaterialsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_bill_of_materials_of_request_for_quotation_with_http_info(request_for_quotation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_bill_of_materials_of_request_for_quotation_with_http_info(request_for_quotation_id, **kwargs)  # noqa: E501
            return data

    def get_bill_of_materials_of_request_for_quotation_with_http_info(self, request_for_quotation_id, **kwargs):  # noqa: E501
        """Get all bill of materials of one request for quotation  # noqa: E501

        Returns a list of all bill of materials that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bill_of_materials_of_request_for_quotation_with_http_info(request_for_quotation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int request_for_quotation_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str name: Filter accepts `*` as wildcard
        :param str author: Filter accepts `*` as wildcard
        :param str _date: Expected date format is YYYY-MM-DD
        :param str date_from: Expected date format is YYYY-MM-DD
        :param str date_to: Expected date format is YYYY-MM-DD
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: BillOfMaterialsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['request_for_quotation_id', 'page', 'per_page', 'name', 'author', '_date', 'date_from', 'date_to', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bill_of_materials_of_request_for_quotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'request_for_quotation_id' is set
        if ('request_for_quotation_id' not in params or
                params['request_for_quotation_id'] is None):
            raise ValueError("Missing the required parameter `request_for_quotation_id` when calling `get_bill_of_materials_of_request_for_quotation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'request_for_quotation_id' in params:
            path_params['request_for_quotation_id'] = params['request_for_quotation_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'author' in params:
            query_params.append(('author', params['author']))  # noqa: E501
        if '_date' in params:
            query_params.append(('date', params['_date']))  # noqa: E501
        if 'date_from' in params:
            query_params.append(('date_from', params['date_from']))  # noqa: E501
        if 'date_to' in params:
            query_params.append(('date_to', params['date_to']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/request_for_quotations/{request_for_quotation_id}/bill_of_materials', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BillOfMaterialsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_documents_of_request_for_quotation(self, request_for_quotation_id, **kwargs):  # noqa: E501
        """Get all documents of one request for quotation  # noqa: E501

        Returns a list of documents. You can apply the query parameters listed below to get a filtered list. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language. Possible include values: ```status, tenant, classification, categories, categories.parent, attachments```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_documents_of_request_for_quotation(request_for_quotation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int request_for_quotation_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str document_version: Filter accepts `*` as wildcard
        :param str number: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str classification_id: One or multiple ids (comma list). Expected id format is integer
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str category_id: One or multiple ids (comma list). By adding `+` after the id, the filter considers the given category and all its children (e.g. 3+).
        :param date valid_from: Expected date format is YYYY-MM-DD
        :param date valid_until: Expected date format is YYYY-MM-DD
        :param date valid_at: Expected date format is YYYY-MM-DD or YYYY-MM or YYYY
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: DocumentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_documents_of_request_for_quotation_with_http_info(request_for_quotation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_documents_of_request_for_quotation_with_http_info(request_for_quotation_id, **kwargs)  # noqa: E501
            return data

    def get_documents_of_request_for_quotation_with_http_info(self, request_for_quotation_id, **kwargs):  # noqa: E501
        """Get all documents of one request for quotation  # noqa: E501

        Returns a list of documents. You can apply the query parameters listed below to get a filtered list. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language. Possible include values: ```status, tenant, classification, categories, categories.parent, attachments```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_documents_of_request_for_quotation_with_http_info(request_for_quotation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int request_for_quotation_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str document_version: Filter accepts `*` as wildcard
        :param str number: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str classification_id: One or multiple ids (comma list). Expected id format is integer
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str category_id: One or multiple ids (comma list). By adding `+` after the id, the filter considers the given category and all its children (e.g. 3+).
        :param date valid_from: Expected date format is YYYY-MM-DD
        :param date valid_until: Expected date format is YYYY-MM-DD
        :param date valid_at: Expected date format is YYYY-MM-DD or YYYY-MM or YYYY
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: DocumentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['request_for_quotation_id', 'page', 'per_page', 'include', 'name', 'document_version', 'number', 'status_id', 'classification_id', 'tenant_id', 'category_id', 'valid_from', 'valid_until', 'valid_at', 'order_by', 'accept_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_documents_of_request_for_quotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'request_for_quotation_id' is set
        if ('request_for_quotation_id' not in params or
                params['request_for_quotation_id'] is None):
            raise ValueError("Missing the required parameter `request_for_quotation_id` when calling `get_documents_of_request_for_quotation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'request_for_quotation_id' in params:
            path_params['request_for_quotation_id'] = params['request_for_quotation_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'document_version' in params:
            query_params.append(('document_version', params['document_version']))  # noqa: E501
        if 'number' in params:
            query_params.append(('number', params['number']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if 'classification_id' in params:
            query_params.append(('classification_id', params['classification_id']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'category_id' in params:
            query_params.append(('category_id', params['category_id']))  # noqa: E501
        if 'valid_from' in params:
            query_params.append(('valid_from', params['valid_from']))  # noqa: E501
        if 'valid_until' in params:
            query_params.append(('valid_until', params['valid_until']))  # noqa: E501
        if 'valid_at' in params:
            query_params.append(('valid_at', params['valid_at']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/request_for_quotations/{request_for_quotation_id}/documents', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocumentsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_quotations_of_request_for_quotation(self, request_for_quotation_id, **kwargs):  # noqa: E501
        """Get all quotations of one request for quotation  # noqa: E501

        Returns a list of all quotations that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_quotations_of_request_for_quotation(request_for_quotation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int request_for_quotation_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str name: Filter accepts `*` as wildcard
        :param str number: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str _date: Expected date format is YYYY-MM-DD
        :param str date_from: Expected date format is YYYY-MM-DD
        :param str date_to: Expected date format is YYYY-MM-DD
        :param str sender_id: One or multiple ids (comma list). Expected id format is integer
        :param str receiver_id: One or multiple ids (comma list). Expected id format is integer
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: QuotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_quotations_of_request_for_quotation_with_http_info(request_for_quotation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_quotations_of_request_for_quotation_with_http_info(request_for_quotation_id, **kwargs)  # noqa: E501
            return data

    def get_quotations_of_request_for_quotation_with_http_info(self, request_for_quotation_id, **kwargs):  # noqa: E501
        """Get all quotations of one request for quotation  # noqa: E501

        Returns a list of all quotations that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_quotations_of_request_for_quotation_with_http_info(request_for_quotation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int request_for_quotation_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str name: Filter accepts `*` as wildcard
        :param str number: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str _date: Expected date format is YYYY-MM-DD
        :param str date_from: Expected date format is YYYY-MM-DD
        :param str date_to: Expected date format is YYYY-MM-DD
        :param str sender_id: One or multiple ids (comma list). Expected id format is integer
        :param str receiver_id: One or multiple ids (comma list). Expected id format is integer
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: QuotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['request_for_quotation_id', 'page', 'per_page', 'name', 'number', 'status_id', '_date', 'date_from', 'date_to', 'sender_id', 'receiver_id', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quotations_of_request_for_quotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'request_for_quotation_id' is set
        if ('request_for_quotation_id' not in params or
                params['request_for_quotation_id'] is None):
            raise ValueError("Missing the required parameter `request_for_quotation_id` when calling `get_quotations_of_request_for_quotation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'request_for_quotation_id' in params:
            path_params['request_for_quotation_id'] = params['request_for_quotation_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'number' in params:
            query_params.append(('number', params['number']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if '_date' in params:
            query_params.append(('date', params['_date']))  # noqa: E501
        if 'date_from' in params:
            query_params.append(('date_from', params['date_from']))  # noqa: E501
        if 'date_to' in params:
            query_params.append(('date_to', params['date_to']))  # noqa: E501
        if 'sender_id' in params:
            query_params.append(('sender_id', params['sender_id']))  # noqa: E501
        if 'receiver_id' in params:
            query_params.append(('receiver_id', params['receiver_id']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/request_for_quotations/{request_for_quotation_id}/quotations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QuotationsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_request_for_quotation_by_id(self, id, **kwargs):  # noqa: E501
        """Get a single request for quotation  # noqa: E501

        Get a specific request for quotation identified by the id in the URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_request_for_quotation_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the request for quotation to fetch (required)
        :return: RequestForQuotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_request_for_quotation_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_request_for_quotation_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_request_for_quotation_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get a single request for quotation  # noqa: E501

        Get a specific request for quotation identified by the id in the URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_request_for_quotation_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the request for quotation to fetch (required)
        :return: RequestForQuotationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_request_for_quotation_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_request_for_quotation_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/request_for_quotations/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RequestForQuotationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_request_for_quotation_id_status(self, request_for_quotation_id, **kwargs):  # noqa: E501
        """Get the status of the specific request for quotation  # noqa: E501

        Returns the status of the request for quotation. Needed if only permission on request for quotation but not on tenant. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language. Possible include value: ```tenant```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_request_for_quotation_id_status(request_for_quotation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int request_for_quotation_id: Id of the specified request for quotation (required)
        :param str include: Comma separated list of objects to include in response
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: RequestForQuotationStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_request_for_quotation_id_status_with_http_info(request_for_quotation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_request_for_quotation_id_status_with_http_info(request_for_quotation_id, **kwargs)  # noqa: E501
            return data

    def get_request_for_quotation_id_status_with_http_info(self, request_for_quotation_id, **kwargs):  # noqa: E501
        """Get the status of the specific request for quotation  # noqa: E501

        Returns the status of the request for quotation. Needed if only permission on request for quotation but not on tenant. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language. Possible include value: ```tenant```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_request_for_quotation_id_status_with_http_info(request_for_quotation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int request_for_quotation_id: Id of the specified request for quotation (required)
        :param str include: Comma separated list of objects to include in response
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: RequestForQuotationStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['request_for_quotation_id', 'include', 'accept_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_request_for_quotation_id_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'request_for_quotation_id' is set
        if ('request_for_quotation_id' not in params or
                params['request_for_quotation_id'] is None):
            raise ValueError("Missing the required parameter `request_for_quotation_id` when calling `get_request_for_quotation_id_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'request_for_quotation_id' in params:
            path_params['request_for_quotation_id'] = params['request_for_quotation_id']  # noqa: E501

        query_params = []
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/request_for_quotations/{request_for_quotation_id}/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RequestForQuotationStatusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_request_for_quotations(self, **kwargs):  # noqa: E501
        """Get a range of request for quotations  # noqa: E501

        Returns a list of request for quotations. If the query has no matches, the response is an empty list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_request_for_quotations(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str name: Filter accepts `*` as wildcard
        :param str number: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str _date: Expected date format is YYYY-MM-DD
        :param str date_from: Expected date format is YYYY-MM-DD
        :param str date_to: Expected date format is YYYY-MM-DD
        :param str sender_id: One or multiple ids (comma list). Expected id format is integer
        :param str receiver_id: One or multiple ids (comma list). Expected id format is integer
        :param str author: Filter accepts `*` as wildcard
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: RequestForQuotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_request_for_quotations_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_request_for_quotations_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_request_for_quotations_with_http_info(self, **kwargs):  # noqa: E501
        """Get a range of request for quotations  # noqa: E501

        Returns a list of request for quotations. If the query has no matches, the response is an empty list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_request_for_quotations_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str name: Filter accepts `*` as wildcard
        :param str number: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str _date: Expected date format is YYYY-MM-DD
        :param str date_from: Expected date format is YYYY-MM-DD
        :param str date_to: Expected date format is YYYY-MM-DD
        :param str sender_id: One or multiple ids (comma list). Expected id format is integer
        :param str receiver_id: One or multiple ids (comma list). Expected id format is integer
        :param str author: Filter accepts `*` as wildcard
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: RequestForQuotationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page', 'per_page', 'name', 'number', 'status_id', '_date', 'date_from', 'date_to', 'sender_id', 'receiver_id', 'author', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_request_for_quotations" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'number' in params:
            query_params.append(('number', params['number']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if '_date' in params:
            query_params.append(('date', params['_date']))  # noqa: E501
        if 'date_from' in params:
            query_params.append(('date_from', params['date_from']))  # noqa: E501
        if 'date_to' in params:
            query_params.append(('date_to', params['date_to']))  # noqa: E501
        if 'sender_id' in params:
            query_params.append(('sender_id', params['sender_id']))  # noqa: E501
        if 'receiver_id' in params:
            query_params.append(('receiver_id', params['receiver_id']))  # noqa: E501
        if 'author' in params:
            query_params.append(('author', params['author']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/request_for_quotations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RequestForQuotationsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_bill_of_materials_of_request_for_quotation(self, body, request_for_quotation_id, **kwargs):  # noqa: E501
        """Replace the bill of materials of a request for quotation  # noqa: E501

        Replaces all bill of materials belonging to a request for quotation. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_bill_of_materials_of_request_for_quotation(body, request_for_quotation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BillOfMaterialIDs body: Resources that shall be replaced (required)
        :param int request_for_quotation_id: Id of the request for quotation of which the bill of materials will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_bill_of_materials_of_request_for_quotation_with_http_info(body, request_for_quotation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_bill_of_materials_of_request_for_quotation_with_http_info(body, request_for_quotation_id, **kwargs)  # noqa: E501
            return data

    def replace_bill_of_materials_of_request_for_quotation_with_http_info(self, body, request_for_quotation_id, **kwargs):  # noqa: E501
        """Replace the bill of materials of a request for quotation  # noqa: E501

        Replaces all bill of materials belonging to a request for quotation. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_bill_of_materials_of_request_for_quotation_with_http_info(body, request_for_quotation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param BillOfMaterialIDs body: Resources that shall be replaced (required)
        :param int request_for_quotation_id: Id of the request for quotation of which the bill of materials will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'request_for_quotation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_bill_of_materials_of_request_for_quotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_bill_of_materials_of_request_for_quotation`")  # noqa: E501
        # verify the required parameter 'request_for_quotation_id' is set
        if ('request_for_quotation_id' not in params or
                params['request_for_quotation_id'] is None):
            raise ValueError("Missing the required parameter `request_for_quotation_id` when calling `replace_bill_of_materials_of_request_for_quotation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'request_for_quotation_id' in params:
            path_params['request_for_quotation_id'] = params['request_for_quotation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/request_for_quotations/{request_for_quotation_id}/bill_of_materials', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_documents_of_request_for_quotation(self, body, request_for_quotation_id, **kwargs):  # noqa: E501
        """Replace the documents of a request for quotation  # noqa: E501

        Replaces all documents belonging to a request for quotation. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_documents_of_request_for_quotation(body, request_for_quotation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be replaced (required)
        :param int request_for_quotation_id: Id of the request for quotation of which the documents will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_documents_of_request_for_quotation_with_http_info(body, request_for_quotation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_documents_of_request_for_quotation_with_http_info(body, request_for_quotation_id, **kwargs)  # noqa: E501
            return data

    def replace_documents_of_request_for_quotation_with_http_info(self, body, request_for_quotation_id, **kwargs):  # noqa: E501
        """Replace the documents of a request for quotation  # noqa: E501

        Replaces all documents belonging to a request for quotation. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_documents_of_request_for_quotation_with_http_info(body, request_for_quotation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be replaced (required)
        :param int request_for_quotation_id: Id of the request for quotation of which the documents will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'request_for_quotation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_documents_of_request_for_quotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_documents_of_request_for_quotation`")  # noqa: E501
        # verify the required parameter 'request_for_quotation_id' is set
        if ('request_for_quotation_id' not in params or
                params['request_for_quotation_id'] is None):
            raise ValueError("Missing the required parameter `request_for_quotation_id` when calling `replace_documents_of_request_for_quotation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'request_for_quotation_id' in params:
            path_params['request_for_quotation_id'] = params['request_for_quotation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/request_for_quotations/{request_for_quotation_id}/documents', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_quotations_of_request_for_quotation(self, body, request_for_quotation_id, **kwargs):  # noqa: E501
        """Replace the quotations of a request for quotation  # noqa: E501

        Replaces all quotations belonging to a request for quotation. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_quotations_of_request_for_quotation(body, request_for_quotation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param QuotationIDs body: Resources that shall be replaced (required)
        :param int request_for_quotation_id: Id of the request for quotation of which the quotations will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_quotations_of_request_for_quotation_with_http_info(body, request_for_quotation_id, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_quotations_of_request_for_quotation_with_http_info(body, request_for_quotation_id, **kwargs)  # noqa: E501
            return data

    def replace_quotations_of_request_for_quotation_with_http_info(self, body, request_for_quotation_id, **kwargs):  # noqa: E501
        """Replace the quotations of a request for quotation  # noqa: E501

        Replaces all quotations belonging to a request for quotation. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_quotations_of_request_for_quotation_with_http_info(body, request_for_quotation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param QuotationIDs body: Resources that shall be replaced (required)
        :param int request_for_quotation_id: Id of the request for quotation of which the quotations will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'request_for_quotation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_quotations_of_request_for_quotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_quotations_of_request_for_quotation`")  # noqa: E501
        # verify the required parameter 'request_for_quotation_id' is set
        if ('request_for_quotation_id' not in params or
                params['request_for_quotation_id'] is None):
            raise ValueError("Missing the required parameter `request_for_quotation_id` when calling `replace_quotations_of_request_for_quotation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'request_for_quotation_id' in params:
            path_params['request_for_quotation_id'] = params['request_for_quotation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/request_for_quotations/{request_for_quotation_id}/quotations', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_request_for_quotation(self, body, id, **kwargs):  # noqa: E501
        """Update a request for quotation  # noqa: E501

        Update accessible parameters of the requested resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_request_for_quotation(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestForQuotationRequest body: Parameters that shall be updated. (required)
        :param int id: Id of the request for quotation to update (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_request_for_quotation_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_request_for_quotation_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def update_request_for_quotation_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Update a request for quotation  # noqa: E501

        Update accessible parameters of the requested resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_request_for_quotation_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RequestForQuotationRequest body: Parameters that shall be updated. (required)
        :param int id: Id of the request for quotation to update (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_request_for_quotation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_request_for_quotation`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_request_for_quotation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/request_for_quotations/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
