# coding: utf-8

"""
    Netilion API Documentation

    Welcome to the Netilion API Documentation, which provides interactive access and documentation to our REST API. Please visit our developer portal for further instructions and information: https://developer.netilion.endress.com/   # noqa: E501

    OpenAPI spec version: 01.00.00
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from netilion_api.api_client import ApiClient


class PurchaseOrderApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_deliviers_to_purchase_order(self, body, purchase_order_id, **kwargs):  # noqa: E501
        """Add deliveries to a purchase order  # noqa: E501

        Add one or more deliveries to a purchase order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_deliviers_to_purchase_order(body, purchase_order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeliveryIDs body: Resources that shall be added. (required)
        :param int purchase_order_id: Id of the purchase order to which the deliveries will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_deliviers_to_purchase_order_with_http_info(body, purchase_order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_deliviers_to_purchase_order_with_http_info(body, purchase_order_id, **kwargs)  # noqa: E501
            return data

    def add_deliviers_to_purchase_order_with_http_info(self, body, purchase_order_id, **kwargs):  # noqa: E501
        """Add deliveries to a purchase order  # noqa: E501

        Add one or more deliveries to a purchase order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_deliviers_to_purchase_order_with_http_info(body, purchase_order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeliveryIDs body: Resources that shall be added. (required)
        :param int purchase_order_id: Id of the purchase order to which the deliveries will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'purchase_order_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_deliviers_to_purchase_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_deliviers_to_purchase_order`")  # noqa: E501
        # verify the required parameter 'purchase_order_id' is set
        if ('purchase_order_id' not in params or
                params['purchase_order_id'] is None):
            raise ValueError("Missing the required parameter `purchase_order_id` when calling `add_deliviers_to_purchase_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'purchase_order_id' in params:
            path_params['purchase_order_id'] = params['purchase_order_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/purchase_orders/{purchase_order_id}/deliveries', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_documents_to_purchase_order(self, body, purchase_order_id, **kwargs):  # noqa: E501
        """Add documents to a purchase order  # noqa: E501

        Add one or more documents to a purchase order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_documents_to_purchase_order(body, purchase_order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be added. (required)
        :param int purchase_order_id: Id of the purchase order to which the documents will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_documents_to_purchase_order_with_http_info(body, purchase_order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_documents_to_purchase_order_with_http_info(body, purchase_order_id, **kwargs)  # noqa: E501
            return data

    def add_documents_to_purchase_order_with_http_info(self, body, purchase_order_id, **kwargs):  # noqa: E501
        """Add documents to a purchase order  # noqa: E501

        Add one or more documents to a purchase order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_documents_to_purchase_order_with_http_info(body, purchase_order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be added. (required)
        :param int purchase_order_id: Id of the purchase order to which the documents will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'purchase_order_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_documents_to_purchase_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_documents_to_purchase_order`")  # noqa: E501
        # verify the required parameter 'purchase_order_id' is set
        if ('purchase_order_id' not in params or
                params['purchase_order_id'] is None):
            raise ValueError("Missing the required parameter `purchase_order_id` when calling `add_documents_to_purchase_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'purchase_order_id' in params:
            path_params['purchase_order_id'] = params['purchase_order_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/purchase_orders/{purchase_order_id}/documents', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_products_to_purchase_order(self, body, purchase_order_id, **kwargs):  # noqa: E501
        """Add products to a purchase order  # noqa: E501

        Add one or more products to a purchase order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_products_to_purchase_order(body, purchase_order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProductIDs body: Resources that shall be added. (required)
        :param int purchase_order_id: Id of the purchase order to which the products will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_products_to_purchase_order_with_http_info(body, purchase_order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_products_to_purchase_order_with_http_info(body, purchase_order_id, **kwargs)  # noqa: E501
            return data

    def add_products_to_purchase_order_with_http_info(self, body, purchase_order_id, **kwargs):  # noqa: E501
        """Add products to a purchase order  # noqa: E501

        Add one or more products to a purchase order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_products_to_purchase_order_with_http_info(body, purchase_order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProductIDs body: Resources that shall be added. (required)
        :param int purchase_order_id: Id of the purchase order to which the products will be added (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'purchase_order_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_products_to_purchase_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_products_to_purchase_order`")  # noqa: E501
        # verify the required parameter 'purchase_order_id' is set
        if ('purchase_order_id' not in params or
                params['purchase_order_id'] is None):
            raise ValueError("Missing the required parameter `purchase_order_id` when calling `add_products_to_purchase_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'purchase_order_id' in params:
            path_params['purchase_order_id'] = params['purchase_order_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/purchase_orders/{purchase_order_id}/products', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_purchase_order(self, body, **kwargs):  # noqa: E501
        """Create a new purchase order  # noqa: E501

        Create a new purchase order with a sender and a receiver.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_purchase_order(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PurchaseOrderRequest body: Object body that will be created. (required)
        :return: PurchaseOrderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_purchase_order_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_purchase_order_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_purchase_order_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create a new purchase order  # noqa: E501

        Create a new purchase order with a sender and a receiver.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_purchase_order_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PurchaseOrderRequest body: Object body that will be created. (required)
        :return: PurchaseOrderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_purchase_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_purchase_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/purchase_orders', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PurchaseOrderResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_purchase_order(self, id, **kwargs):  # noqa: E501
        """Delete a purchase order  # noqa: E501

        Delete a specific resource identified by the id in the URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_purchase_order(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the purchase order to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_purchase_order_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_purchase_order_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def delete_purchase_order_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete a purchase order  # noqa: E501

        Delete a specific resource identified by the id in the URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_purchase_order_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the purchase order to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_purchase_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_purchase_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/purchase_orders/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_deliviers_of_purchase_order(self, purchase_order_id, **kwargs):  # noqa: E501
        """Get all deliveries of one purchase order  # noqa: E501

        Returns a list of all deliveries that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_deliviers_of_purchase_order(purchase_order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int purchase_order_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str number: Filter accepts `*` as wildcard
        :param str name: Filter accepts `*` as wildcard
        :param date date_of_shipment: Expected date format is YYYY-MM-DD
        :param date date_of_shipment_from: Expected date format is YYYY-MM-DD
        :param date date_of_shipment_to: Expected date format is YYYY-MM-DD
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str sender_id: One or multiple ids (comma list). Expected id format is integer
        :param str receiver_id: One or multiple ids (comma list). Expected id format is integer
        :param str customer_number: Filter accepts `*` as wildcard
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: DeliveriesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_deliviers_of_purchase_order_with_http_info(purchase_order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_deliviers_of_purchase_order_with_http_info(purchase_order_id, **kwargs)  # noqa: E501
            return data

    def get_deliviers_of_purchase_order_with_http_info(self, purchase_order_id, **kwargs):  # noqa: E501
        """Get all deliveries of one purchase order  # noqa: E501

        Returns a list of all deliveries that are available in your scope. You can apply query parameters in the request to get a filtered list. If the query has no matches, the response will show an empty array.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_deliviers_of_purchase_order_with_http_info(purchase_order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int purchase_order_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str number: Filter accepts `*` as wildcard
        :param str name: Filter accepts `*` as wildcard
        :param date date_of_shipment: Expected date format is YYYY-MM-DD
        :param date date_of_shipment_from: Expected date format is YYYY-MM-DD
        :param date date_of_shipment_to: Expected date format is YYYY-MM-DD
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str sender_id: One or multiple ids (comma list). Expected id format is integer
        :param str receiver_id: One or multiple ids (comma list). Expected id format is integer
        :param str customer_number: Filter accepts `*` as wildcard
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: DeliveriesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['purchase_order_id', 'page', 'per_page', 'number', 'name', 'date_of_shipment', 'date_of_shipment_from', 'date_of_shipment_to', 'status_id', 'sender_id', 'receiver_id', 'customer_number', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_deliviers_of_purchase_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'purchase_order_id' is set
        if ('purchase_order_id' not in params or
                params['purchase_order_id'] is None):
            raise ValueError("Missing the required parameter `purchase_order_id` when calling `get_deliviers_of_purchase_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'purchase_order_id' in params:
            path_params['purchase_order_id'] = params['purchase_order_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'number' in params:
            query_params.append(('number', params['number']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'date_of_shipment' in params:
            query_params.append(('date_of_shipment', params['date_of_shipment']))  # noqa: E501
        if 'date_of_shipment_from' in params:
            query_params.append(('date_of_shipment_from', params['date_of_shipment_from']))  # noqa: E501
        if 'date_of_shipment_to' in params:
            query_params.append(('date_of_shipment_to', params['date_of_shipment_to']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if 'sender_id' in params:
            query_params.append(('sender_id', params['sender_id']))  # noqa: E501
        if 'receiver_id' in params:
            query_params.append(('receiver_id', params['receiver_id']))  # noqa: E501
        if 'customer_number' in params:
            query_params.append(('customer_number', params['customer_number']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/purchase_orders/{purchase_order_id}/deliveries', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DeliveriesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_documents_of_purchase_order(self, purchase_order_id, **kwargs):  # noqa: E501
        """Get all documents of one purchase order  # noqa: E501

        Returns a list of documents. If the query has no matches, the response is an empty list. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language. Possible include values: ```status, tenant, classification, categories, categories.parent, categories.standards, attachments```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_documents_of_purchase_order(purchase_order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int purchase_order_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str document_version: Filter accepts `*` as wildcard
        :param str number: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str classification_id: One or multiple ids (comma list). Expected id format is integer
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str category_id: One or multiple ids (comma list). By adding `+` after the id, the filter considers the given category and all its children (e.g. 3+).
        :param date valid_from: Expected date format is YYYY-MM-DD
        :param date valid_until: Expected date format is YYYY-MM-DD
        :param date valid_at: Expected date format is YYYY-MM-DD or YYYY-MM or YYYY
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: DocumentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_documents_of_purchase_order_with_http_info(purchase_order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_documents_of_purchase_order_with_http_info(purchase_order_id, **kwargs)  # noqa: E501
            return data

    def get_documents_of_purchase_order_with_http_info(self, purchase_order_id, **kwargs):  # noqa: E501
        """Get all documents of one purchase order  # noqa: E501

        Returns a list of documents. If the query has no matches, the response is an empty list. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language. Possible include values: ```status, tenant, classification, categories, categories.parent, categories.standards, attachments```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_documents_of_purchase_order_with_http_info(purchase_order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int purchase_order_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str name: Filter accepts `*` as wildcard
        :param str document_version: Filter accepts `*` as wildcard
        :param str number: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str classification_id: One or multiple ids (comma list). Expected id format is integer
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str category_id: One or multiple ids (comma list). By adding `+` after the id, the filter considers the given category and all its children (e.g. 3+).
        :param date valid_from: Expected date format is YYYY-MM-DD
        :param date valid_until: Expected date format is YYYY-MM-DD
        :param date valid_at: Expected date format is YYYY-MM-DD or YYYY-MM or YYYY
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: DocumentsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['purchase_order_id', 'page', 'per_page', 'include', 'name', 'document_version', 'number', 'status_id', 'classification_id', 'tenant_id', 'category_id', 'valid_from', 'valid_until', 'valid_at', 'order_by', 'accept_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_documents_of_purchase_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'purchase_order_id' is set
        if ('purchase_order_id' not in params or
                params['purchase_order_id'] is None):
            raise ValueError("Missing the required parameter `purchase_order_id` when calling `get_documents_of_purchase_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'purchase_order_id' in params:
            path_params['purchase_order_id'] = params['purchase_order_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'document_version' in params:
            query_params.append(('document_version', params['document_version']))  # noqa: E501
        if 'number' in params:
            query_params.append(('number', params['number']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if 'classification_id' in params:
            query_params.append(('classification_id', params['classification_id']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'category_id' in params:
            query_params.append(('category_id', params['category_id']))  # noqa: E501
        if 'valid_from' in params:
            query_params.append(('valid_from', params['valid_from']))  # noqa: E501
        if 'valid_until' in params:
            query_params.append(('valid_until', params['valid_until']))  # noqa: E501
        if 'valid_at' in params:
            query_params.append(('valid_at', params['valid_at']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/purchase_orders/{purchase_order_id}/documents', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocumentsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_products_of_purchase_order(self, purchase_order_id, **kwargs):  # noqa: E501
        """Get all products of one purchase  # noqa: E501

        Returns a list of all products that are available in your scope. You can apply the query parameters listed below to get a filtered list. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language. Possible include values: ```status, tenant, parent, manufacturer, pictures, categories, categories.parent```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_products_of_purchase_order(purchase_order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int purchase_order_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str product_code: Filter accepts `*` as wildcard
        :param str name: Filter accepts `*` as wildcard
        :param str manufacturer_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str parent_id: One or multiple ids (comma list). \"null\" to retrieve all objects without parent, \"!null\" for all objects with parent.
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str category_id: One or multiple ids (comma list). By adding `+` after the id, the filter considers the given category and all its children (e.g. 3+).
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: ProductsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_products_of_purchase_order_with_http_info(purchase_order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_products_of_purchase_order_with_http_info(purchase_order_id, **kwargs)  # noqa: E501
            return data

    def get_products_of_purchase_order_with_http_info(self, purchase_order_id, **kwargs):  # noqa: E501
        """Get all products of one purchase  # noqa: E501

        Returns a list of all products that are available in your scope. You can apply the query parameters listed below to get a filtered list. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language. Possible include values: ```status, tenant, parent, manufacturer, pictures, categories, categories.parent```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_products_of_purchase_order_with_http_info(purchase_order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int purchase_order_id: The resource defined in the URL (required)
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str include: Comma separated list of objects to include in response
        :param str product_code: Filter accepts `*` as wildcard
        :param str name: Filter accepts `*` as wildcard
        :param str manufacturer_id: One or multiple ids (comma list). Expected id format is integer
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str parent_id: One or multiple ids (comma list). \"null\" to retrieve all objects without parent, \"!null\" for all objects with parent.
        :param str tenant_id: One or multiple ids (comma list). Expected id format is integer
        :param str category_id: One or multiple ids (comma list). By adding `+` after the id, the filter considers the given category and all its children (e.g. 3+).
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: ProductsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['purchase_order_id', 'page', 'per_page', 'include', 'product_code', 'name', 'manufacturer_id', 'status_id', 'parent_id', 'tenant_id', 'category_id', 'order_by', 'accept_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_products_of_purchase_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'purchase_order_id' is set
        if ('purchase_order_id' not in params or
                params['purchase_order_id'] is None):
            raise ValueError("Missing the required parameter `purchase_order_id` when calling `get_products_of_purchase_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'purchase_order_id' in params:
            path_params['purchase_order_id'] = params['purchase_order_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'product_code' in params:
            query_params.append(('product_code', params['product_code']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'manufacturer_id' in params:
            query_params.append(('manufacturer_id', params['manufacturer_id']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if 'parent_id' in params:
            query_params.append(('parent_id', params['parent_id']))  # noqa: E501
        if 'tenant_id' in params:
            query_params.append(('tenant_id', params['tenant_id']))  # noqa: E501
        if 'category_id' in params:
            query_params.append(('category_id', params['category_id']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/purchase_orders/{purchase_order_id}/products', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProductsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_purchase_order_by_id(self, id, **kwargs):  # noqa: E501
        """Get a single purchase order  # noqa: E501

        Get a specific purchase order identified by the id in the URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_purchase_order_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the purchase order to fetch (required)
        :return: PurchaseOrderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_purchase_order_by_id_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_purchase_order_by_id_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_purchase_order_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get a single purchase order  # noqa: E501

        Get a specific purchase order identified by the id in the URL.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_purchase_order_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the purchase order to fetch (required)
        :return: PurchaseOrderResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_purchase_order_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_purchase_order_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/purchase_orders/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PurchaseOrderResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_purchase_order_id_status(self, purchase_order_id, **kwargs):  # noqa: E501
        """Get the status of the specific purchase order  # noqa: E501

        Returns the status of the purchase order. Needed if only permission on purchase order but not on tenant. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language. Possible include value: ```tenant```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_purchase_order_id_status(purchase_order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int purchase_order_id: Id of the specified purchase order (required)
        :param str include: Comma separated list of objects to include in response
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: PurchaseOrderStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_purchase_order_id_status_with_http_info(purchase_order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_purchase_order_id_status_with_http_info(purchase_order_id, **kwargs)  # noqa: E501
            return data

    def get_purchase_order_id_status_with_http_info(self, purchase_order_id, **kwargs):  # noqa: E501
        """Get the status of the specific purchase order  # noqa: E501

        Returns the status of the purchase order. Needed if only permission on purchase order but not on tenant. Parameters supporting translation: ```name, description```. To get a translation set Accept-Language. Possible include value: ```tenant```  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_purchase_order_id_status_with_http_info(purchase_order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int purchase_order_id: Id of the specified purchase order (required)
        :param str include: Comma separated list of objects to include in response
        :param str accept_language: The client's accepted languages. One or several (e.g. fr,de,en)
        :return: PurchaseOrderStatusResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['purchase_order_id', 'include', 'accept_language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_purchase_order_id_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'purchase_order_id' is set
        if ('purchase_order_id' not in params or
                params['purchase_order_id'] is None):
            raise ValueError("Missing the required parameter `purchase_order_id` when calling `get_purchase_order_id_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'purchase_order_id' in params:
            path_params['purchase_order_id'] = params['purchase_order_id']  # noqa: E501

        query_params = []
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501

        header_params = {}
        if 'accept_language' in params:
            header_params['Accept-Language'] = params['accept_language']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/purchase_orders/{purchase_order_id}/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PurchaseOrderStatusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_purchase_orders(self, **kwargs):  # noqa: E501
        """Get a range of purchase orders  # noqa: E501

        Returns a list of purchase orders. If the query has no matches, the response is an empty list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_purchase_orders(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str name: Filter accepts `*` as wildcard
        :param str number: Filter accepts `*` as wildcard
        :param str customer_purchase_order_number: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str _date: Expected date format is YYYY-MM-DD
        :param str date_from: Expected date format is YYYY-MM-DD
        :param str date_to: Expected date format is YYYY-MM-DD
        :param str sender_id: One or multiple ids (comma list). Expected id format is integer
        :param str receiver_id: One or multiple ids (comma list). Expected id format is integer
        :param str quotation_id: One or multiple ids (comma list). Expected id format is integer
        :param str customer_number: Filter accepts `*` as wildcard
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: PurchaseOrdersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_purchase_orders_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_purchase_orders_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_purchase_orders_with_http_info(self, **kwargs):  # noqa: E501
        """Get a range of purchase orders  # noqa: E501

        Returns a list of purchase orders. If the query has no matches, the response is an empty list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_purchase_orders_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: Page number to load
        :param int per_page: Number of items to load per page
        :param str name: Filter accepts `*` as wildcard
        :param str number: Filter accepts `*` as wildcard
        :param str customer_purchase_order_number: Filter accepts `*` as wildcard
        :param str status_id: One or multiple ids (comma list). Expected id format is integer
        :param str _date: Expected date format is YYYY-MM-DD
        :param str date_from: Expected date format is YYYY-MM-DD
        :param str date_to: Expected date format is YYYY-MM-DD
        :param str sender_id: One or multiple ids (comma list). Expected id format is integer
        :param str receiver_id: One or multiple ids (comma list). Expected id format is integer
        :param str quotation_id: One or multiple ids (comma list). Expected id format is integer
        :param str customer_number: Filter accepts `*` as wildcard
        :param str order_by: Order result by attribute value, accepts `id`, `created_at` or `updated_at`. Add `-` as a prefix for descending order. Default value is `id`
        :return: PurchaseOrdersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page', 'per_page', 'name', 'number', 'customer_purchase_order_number', 'status_id', '_date', 'date_from', 'date_to', 'sender_id', 'receiver_id', 'quotation_id', 'customer_number', 'order_by']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_purchase_orders" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'per_page' in params:
            query_params.append(('per_page', params['per_page']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'number' in params:
            query_params.append(('number', params['number']))  # noqa: E501
        if 'customer_purchase_order_number' in params:
            query_params.append(('customer_purchase_order_number', params['customer_purchase_order_number']))  # noqa: E501
        if 'status_id' in params:
            query_params.append(('status_id', params['status_id']))  # noqa: E501
        if '_date' in params:
            query_params.append(('date', params['_date']))  # noqa: E501
        if 'date_from' in params:
            query_params.append(('date_from', params['date_from']))  # noqa: E501
        if 'date_to' in params:
            query_params.append(('date_to', params['date_to']))  # noqa: E501
        if 'sender_id' in params:
            query_params.append(('sender_id', params['sender_id']))  # noqa: E501
        if 'receiver_id' in params:
            query_params.append(('receiver_id', params['receiver_id']))  # noqa: E501
        if 'quotation_id' in params:
            query_params.append(('quotation_id', params['quotation_id']))  # noqa: E501
        if 'customer_number' in params:
            query_params.append(('customer_number', params['customer_number']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('order_by', params['order_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/purchase_orders', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PurchaseOrdersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_deliviers_from_purchase_order(self, body, purchase_order_id, **kwargs):  # noqa: E501
        """Remove deliveries from a purchase order  # noqa: E501

        Remove one or more deliveries from a purchase order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_deliviers_from_purchase_order(body, purchase_order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeliveryIDs body: Resources that shall be removed. (required)
        :param int purchase_order_id: Id of the purchase order from which the deliveries will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_deliviers_from_purchase_order_with_http_info(body, purchase_order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_deliviers_from_purchase_order_with_http_info(body, purchase_order_id, **kwargs)  # noqa: E501
            return data

    def remove_deliviers_from_purchase_order_with_http_info(self, body, purchase_order_id, **kwargs):  # noqa: E501
        """Remove deliveries from a purchase order  # noqa: E501

        Remove one or more deliveries from a purchase order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_deliviers_from_purchase_order_with_http_info(body, purchase_order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeliveryIDs body: Resources that shall be removed. (required)
        :param int purchase_order_id: Id of the purchase order from which the deliveries will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'purchase_order_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_deliviers_from_purchase_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_deliviers_from_purchase_order`")  # noqa: E501
        # verify the required parameter 'purchase_order_id' is set
        if ('purchase_order_id' not in params or
                params['purchase_order_id'] is None):
            raise ValueError("Missing the required parameter `purchase_order_id` when calling `remove_deliviers_from_purchase_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'purchase_order_id' in params:
            path_params['purchase_order_id'] = params['purchase_order_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/purchase_orders/{purchase_order_id}/deliveries', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_documents_from_purchase_order(self, body, purchase_order_id, **kwargs):  # noqa: E501
        """Remove documents from a purchase order  # noqa: E501

        Remove one or more documents from a purchase order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_documents_from_purchase_order(body, purchase_order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be removed. (required)
        :param int purchase_order_id: Id of the purchase order from which the documents will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_documents_from_purchase_order_with_http_info(body, purchase_order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_documents_from_purchase_order_with_http_info(body, purchase_order_id, **kwargs)  # noqa: E501
            return data

    def remove_documents_from_purchase_order_with_http_info(self, body, purchase_order_id, **kwargs):  # noqa: E501
        """Remove documents from a purchase order  # noqa: E501

        Remove one or more documents from a purchase order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_documents_from_purchase_order_with_http_info(body, purchase_order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be removed. (required)
        :param int purchase_order_id: Id of the purchase order from which the documents will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'purchase_order_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_documents_from_purchase_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_documents_from_purchase_order`")  # noqa: E501
        # verify the required parameter 'purchase_order_id' is set
        if ('purchase_order_id' not in params or
                params['purchase_order_id'] is None):
            raise ValueError("Missing the required parameter `purchase_order_id` when calling `remove_documents_from_purchase_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'purchase_order_id' in params:
            path_params['purchase_order_id'] = params['purchase_order_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/purchase_orders/{purchase_order_id}/documents', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_products_from_purchase_order(self, body, purchase_order_id, **kwargs):  # noqa: E501
        """Remove products from a purchase order  # noqa: E501

        Remove one or more products from a purchase order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_products_from_purchase_order(body, purchase_order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProductIDs body: Resources that shall be removed. (required)
        :param int purchase_order_id: Id of the purchase order from which the products will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_products_from_purchase_order_with_http_info(body, purchase_order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_products_from_purchase_order_with_http_info(body, purchase_order_id, **kwargs)  # noqa: E501
            return data

    def remove_products_from_purchase_order_with_http_info(self, body, purchase_order_id, **kwargs):  # noqa: E501
        """Remove products from a purchase order  # noqa: E501

        Remove one or more products from a purchase order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_products_from_purchase_order_with_http_info(body, purchase_order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProductIDs body: Resources that shall be removed. (required)
        :param int purchase_order_id: Id of the purchase order from which the products will be removed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'purchase_order_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_products_from_purchase_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `remove_products_from_purchase_order`")  # noqa: E501
        # verify the required parameter 'purchase_order_id' is set
        if ('purchase_order_id' not in params or
                params['purchase_order_id'] is None):
            raise ValueError("Missing the required parameter `purchase_order_id` when calling `remove_products_from_purchase_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'purchase_order_id' in params:
            path_params['purchase_order_id'] = params['purchase_order_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/purchase_orders/{purchase_order_id}/products', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_deliviers_of_purchase_order(self, body, purchase_order_id, **kwargs):  # noqa: E501
        """Replace the deliveries of a purchase order  # noqa: E501

        Replaces all deliveries belonging to a purchase order. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_deliviers_of_purchase_order(body, purchase_order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeliveryIDs body: Resources that shall be replaced (required)
        :param int purchase_order_id: Id of the purchase order of which the deliveries will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_deliviers_of_purchase_order_with_http_info(body, purchase_order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_deliviers_of_purchase_order_with_http_info(body, purchase_order_id, **kwargs)  # noqa: E501
            return data

    def replace_deliviers_of_purchase_order_with_http_info(self, body, purchase_order_id, **kwargs):  # noqa: E501
        """Replace the deliveries of a purchase order  # noqa: E501

        Replaces all deliveries belonging to a purchase order. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_deliviers_of_purchase_order_with_http_info(body, purchase_order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DeliveryIDs body: Resources that shall be replaced (required)
        :param int purchase_order_id: Id of the purchase order of which the deliveries will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'purchase_order_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_deliviers_of_purchase_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_deliviers_of_purchase_order`")  # noqa: E501
        # verify the required parameter 'purchase_order_id' is set
        if ('purchase_order_id' not in params or
                params['purchase_order_id'] is None):
            raise ValueError("Missing the required parameter `purchase_order_id` when calling `replace_deliviers_of_purchase_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'purchase_order_id' in params:
            path_params['purchase_order_id'] = params['purchase_order_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/purchase_orders/{purchase_order_id}/deliveries', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_documents_of_purchase_order(self, body, purchase_order_id, **kwargs):  # noqa: E501
        """Replace the documents of a purchase order  # noqa: E501

        Replaces all documents belonging to a purchase order. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_documents_of_purchase_order(body, purchase_order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be replaced (required)
        :param int purchase_order_id: Id of the purchase order of which the documents will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_documents_of_purchase_order_with_http_info(body, purchase_order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_documents_of_purchase_order_with_http_info(body, purchase_order_id, **kwargs)  # noqa: E501
            return data

    def replace_documents_of_purchase_order_with_http_info(self, body, purchase_order_id, **kwargs):  # noqa: E501
        """Replace the documents of a purchase order  # noqa: E501

        Replaces all documents belonging to a purchase order. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_documents_of_purchase_order_with_http_info(body, purchase_order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DocumentIDs body: Resources that shall be replaced (required)
        :param int purchase_order_id: Id of the purchase order of which the documents will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'purchase_order_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_documents_of_purchase_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_documents_of_purchase_order`")  # noqa: E501
        # verify the required parameter 'purchase_order_id' is set
        if ('purchase_order_id' not in params or
                params['purchase_order_id'] is None):
            raise ValueError("Missing the required parameter `purchase_order_id` when calling `replace_documents_of_purchase_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'purchase_order_id' in params:
            path_params['purchase_order_id'] = params['purchase_order_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/purchase_orders/{purchase_order_id}/documents', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def replace_products_of_purchase_order(self, body, purchase_order_id, **kwargs):  # noqa: E501
        """Replace the products of a purchase order  # noqa: E501

        Replaces all products belonging to a purchase order. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_products_of_purchase_order(body, purchase_order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProductIDs body: Resources that shall be replaced (required)
        :param int purchase_order_id: Id of the purchase order of which the products will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.replace_products_of_purchase_order_with_http_info(body, purchase_order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.replace_products_of_purchase_order_with_http_info(body, purchase_order_id, **kwargs)  # noqa: E501
            return data

    def replace_products_of_purchase_order_with_http_info(self, body, purchase_order_id, **kwargs):  # noqa: E501
        """Replace the products of a purchase order  # noqa: E501

        Replaces all products belonging to a purchase order. You can send a list of resources that will replace all previous values.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.replace_products_of_purchase_order_with_http_info(body, purchase_order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProductIDs body: Resources that shall be replaced (required)
        :param int purchase_order_id: Id of the purchase order of which the products will be replaced (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'purchase_order_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_products_of_purchase_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_products_of_purchase_order`")  # noqa: E501
        # verify the required parameter 'purchase_order_id' is set
        if ('purchase_order_id' not in params or
                params['purchase_order_id'] is None):
            raise ValueError("Missing the required parameter `purchase_order_id` when calling `replace_products_of_purchase_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'purchase_order_id' in params:
            path_params['purchase_order_id'] = params['purchase_order_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/purchase_orders/{purchase_order_id}/products', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_product_quantities_of_purchase_order(self, body, purchase_order_id, **kwargs):  # noqa: E501
        """Change the product quantity in a purchase order  # noqa: E501

        Sets a new quantity of a product in a purchase order or deletes the line in case quantity is zero.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_product_quantities_of_purchase_order(body, purchase_order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProductQuantity body: Resources that shall be changed or removed (required)
        :param int purchase_order_id: Id of the purchase order of which the change will be done (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_product_quantities_of_purchase_order_with_http_info(body, purchase_order_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_product_quantities_of_purchase_order_with_http_info(body, purchase_order_id, **kwargs)  # noqa: E501
            return data

    def update_product_quantities_of_purchase_order_with_http_info(self, body, purchase_order_id, **kwargs):  # noqa: E501
        """Change the product quantity in a purchase order  # noqa: E501

        Sets a new quantity of a product in a purchase order or deletes the line in case quantity is zero.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_product_quantities_of_purchase_order_with_http_info(body, purchase_order_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProductQuantity body: Resources that shall be changed or removed (required)
        :param int purchase_order_id: Id of the purchase order of which the change will be done (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'purchase_order_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_product_quantities_of_purchase_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_product_quantities_of_purchase_order`")  # noqa: E501
        # verify the required parameter 'purchase_order_id' is set
        if ('purchase_order_id' not in params or
                params['purchase_order_id'] is None):
            raise ValueError("Missing the required parameter `purchase_order_id` when calling `update_product_quantities_of_purchase_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'purchase_order_id' in params:
            path_params['purchase_order_id'] = params['purchase_order_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/purchase_orders/{purchase_order_id}/products/quantity', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_purchase_order(self, body, id, **kwargs):  # noqa: E501
        """Update a purchase order  # noqa: E501

        Update accessible parameters of the requested resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_purchase_order(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PurchaseOrderRequest body: Parameters that shall be updated. (required)
        :param int id: Id of the purchase order to update (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_purchase_order_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_purchase_order_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def update_purchase_order_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Update a purchase order  # noqa: E501

        Update accessible parameters of the requested resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_purchase_order_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PurchaseOrderRequest body: Parameters that shall be updated. (required)
        :param int id: Id of the purchase order to update (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_purchase_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_purchase_order`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_purchase_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API-Key', 'Authentication']  # noqa: E501

        return self.api_client.call_api(
            '/purchase_orders/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
